/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib.repository.localdb.requests;

import java.sql.Timestamp;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.json.Json;
import org.gvsig.json.JsonObjectBuilder;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.vcsgis.lib.VCSGisEntity;
import org.gvsig.vcsgis.lib.repository.localdb.VCSGisRepositoryLocaldbImpl;
import org.gvsig.vcsgis.lib.repository.localdb.requests.AbstractRequestLocaldb;
import org.gvsig.vcsgis.lib.repository.localdb.requests.CommitRequestLocaldb;
import org.gvsig.vcsgis.lib.repository.localdb.tables.DataRepoTable;
import org.gvsig.vcsgis.lib.repository.localdb.tables.EntitiesRepoTable;
import org.gvsig.vcsgis.lib.repository.localdb.tables.RevisionsRepoTable;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisRowCreateRequest;
import org.gvsig.vcsgis.lib.requests.RowCreateRequestHelper;

public class RowCreateRequestLocaldb
extends AbstractRequestLocaldb
implements VCSGisRowCreateRequest {
    protected GeometryManager geometryManager = GeometryLocator.getGeometryManager();

    public RowCreateRequestLocaldb(VCSGisRepositoryLocaldbImpl repository, String entityName, String localRevisionCode) {
        super(new RowCreateRequestHelper(repository, entityName, localRevisionCode));
    }

    @Override
    public RowCreateRequestHelper helper() {
        return (RowCreateRequestHelper)super.helper();
    }

    public Timestamp getEfectiveDate() {
        return this.helper().getEfectiveDate();
    }

    public void setEfectiveDate(Timestamp efectiveDate) {
        this.helper().setEfectiveDate(efectiveDate);
    }

    public String getComment() {
        return this.helper().getComment();
    }

    public void setComment(String comment) {
        this.helper().setComment(comment);
    }

    public String getEntityName() {
        return this.helper().getEntityName();
    }

    public void setEfectiveDate(String efectiveDate) {
        this.helper().setEfectiveDate(efectiveDate);
    }

    public String getData() {
        return this.helper().getData();
    }

    public void setData(String data) {
        this.helper().setData(data);
    }

    public String getEntityCode() {
        return this.helper().getEntityCode();
    }

    public String getEntityRevisionCode() {
        return this.helper().getEntityRevisionCode();
    }

    public String getRelatedFeatureCode() {
        return this.helper().getRelatedFeatureCode();
    }

    public String getLocalRevisionCode() {
        return this.helper().getLocalRevisionCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int execute() {
        int n;
        FeatureStore dataStore;
        FeatureStore revisionsStore;
        FeatureStore entitiesStore;
        block18: {
            int n2;
            block17: {
                int n3;
                block16: {
                    entitiesStore = null;
                    revisionsStore = null;
                    dataStore = null;
                    try {
                        VCSGisRepositoryLocaldbImpl repo = this.getRepository();
                        EntitiesRepoTable entitiesTable = new EntitiesRepoTable();
                        RevisionsRepoTable revisionsTable = new RevisionsRepoTable();
                        EntitiesRepoTable.EntityRepoRow entity = entitiesTable.getByEntityName(repo, this.getEntityName());
                        if (entity == null) {
                            int n4 = this.error(240, "Entity '" + this.getEntityName() + "' not exists.");
                            return n4;
                        }
                        if (!this.isAuthorized((VCSGisEntity)entity)) {
                            int n5 = this.getLastErrorCode();
                            return n5;
                        }
                        if (!StringUtils.equalsIgnoreCase((CharSequence)entity.getRepositoryRevisionCode(), (CharSequence)this.getLocalRevisionCode())) {
                            n3 = this.error(510, "Revision 'REVISION[" + this.getLocalRevisionCode() + "]' in 'ENTITY[" + this.getEntityName() + "]' not is head revision 'REVISION[" + entity.getRepositoryRevisionCode() + "]', workspace out of date.");
                            DisposeUtils.disposeQuietly((Disposable)dataStore);
                            break block16;
                        }
                        String data = this.getData();
                        if (StringUtils.isBlank((CharSequence)data)) {
                            n2 = this.error(13, "Data can be empty");
                            DisposeUtils.disposeQuietly(dataStore);
                            break block17;
                        }
                        entitiesStore = repo.getFeatureStore("VCSGISREPO_ENTITIES", false);
                        revisionsStore = repo.openFeatureStore("VCSGISREPO_REVISIONS", null, false);
                        dataStore = repo.getFeatureStore("VCSGISREPO_DATA", false);
                        entitiesStore.edit(1);
                        revisionsStore.edit(1);
                        dataStore.edit(1);
                        long nextRevisionNumber = revisionsTable.calculateNextRevisionNumber(revisionsStore);
                        this.helper().relatedFeatureCode = repo.createUniqueCode();
                        RevisionsRepoTable.RevisionRepoRow revision = new RevisionsRepoTable.RevisionRepoRow(repo);
                        revision.newCode();
                        revision.setOperationDate(this.helper().now());
                        revision.setEfectiveDate(this.helper().getEfectiveDate());
                        revision.setComment(this.helper().getComment());
                        revision.setUserCode(this.helper().getRepository().getUserCode());
                        revision.setEntityCode(entity.getEntityCode());
                        revision.setRevisionNumber(nextRevisionNumber++);
                        revision.insert(revisionsStore);
                        entity.setRepositoryRevisionCode(revision.getCode());
                        entity.update(entitiesStore);
                        JsonObjectBuilder builderData = Json.createObjectBuilder((String)data);
                        Geometry geom = CommitRequestLocaldb.buildBox2D(repo, (VCSGisEntity)entity, this.helper().relatedFeatureCode, data, this.geometryManager, null);
                        builderData.add(entity.getFeatureIdFieldName(), this.helper().relatedFeatureCode);
                        DataRepoTable.DataRepoRow row = new DataRepoTable.DataRepoRow(repo, entity.getDataTableName());
                        row.newCode();
                        row.setEntityCode(entity.getEntityCode());
                        row.setRevisionCode(revision.getCode());
                        row.setRevisionNumber(revision.getNumber());
                        row.setEfectiveDate(revision.getEfectiveDate());
                        row.setOperation(2);
                        row.setIdentifier(this.helper().relatedFeatureCode);
                        row.setGeometry(geom);
                        row.setValues(builderData.toString());
                        row.insert(dataStore);
                        this.helper().entityCode = entity.getEntityCode();
                        this.helper().entityRevision = entity.getRepositoryRevisionCode();
                        entitiesStore.finishEditing();
                        revisionsStore.finishEditing();
                        dataStore.finishEditing();
                        this.getRepository().notifyWatchers(this, entity.getEntityName(), entity.getRepositoryRevisionCode());
                        n = 0;
                        DisposeUtils.disposeQuietly((Disposable)dataStore);
                        break block18;
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Can't create row", (Throwable)ex);
                        if (entitiesStore != null) {
                            entitiesStore.cancelEditingQuietly();
                        }
                        if (revisionsStore != null) {
                            revisionsStore.cancelEditingQuietly();
                        }
                        if (dataStore != null) {
                            dataStore.cancelEditingQuietly();
                        }
                        int n6 = this.error(500, "Can't create row; " + ex.getMessage());
                        return n6;
                    }
                }
                DisposeUtils.disposeQuietly((Disposable)revisionsStore);
                DisposeUtils.disposeQuietly((Disposable)entitiesStore);
                return n3;
            }
            DisposeUtils.disposeQuietly(revisionsStore);
            DisposeUtils.disposeQuietly((Disposable)entitiesStore);
            return n2;
        }
        DisposeUtils.disposeQuietly((Disposable)revisionsStore);
        DisposeUtils.disposeQuietly((Disposable)entitiesStore);
        return n;
        finally {
            DisposeUtils.disposeQuietly(dataStore);
            DisposeUtils.disposeQuietly(revisionsStore);
            DisposeUtils.disposeQuietly(entitiesStore);
        }
    }
}

