/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib.repository.localdb.requests;

import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.dal.feature.DisposableFeatureSetIterable;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.vcsgis.lib.VCSGisUser;
import org.gvsig.vcsgis.lib.VCSGisUserImpl;
import org.gvsig.vcsgis.lib.repository.localdb.VCSGisRepositoryLocaldbImpl;
import org.gvsig.vcsgis.lib.repository.localdb.requests.AbstractRequestLocaldb;
import org.gvsig.vcsgis.lib.repository.localdb.tables.UsersRepoTable;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisUsersRequest;
import org.gvsig.vcsgis.lib.requests.UsersRequestHelper;

public class UsersRequestLocaldb
extends AbstractRequestLocaldb
implements VCSGisUsersRequest {
    public UsersRequestLocaldb(VCSGisRepositoryLocaldbImpl repository) {
        super(new UsersRequestHelper(repository));
    }

    @Override
    public UsersRequestHelper helper() {
        return (UsersRequestHelper)super.helper();
    }

    public List<VCSGisUser> getUsers() {
        return this.helper().getUsers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute() {
        int n;
        if (!this.isAuthorized()) {
            return this.getLastErrorCode();
        }
        LOGGER.info("Process request: " + this.getRequestName() + " user '" + this.getUserCode() + "'.");
        DisposableFeatureSetIterable usersTable_it = null;
        try {
            UsersRepoTable usersTable = new UsersRepoTable();
            ArrayList<VCSGisUser> list = new ArrayList<VCSGisUser>();
            usersTable_it = usersTable.getAll(this.getRepository());
            for (Feature fUser : usersTable_it) {
                VCSGisUserImpl user = new VCSGisUserImpl();
                user.copyFrom(new UsersRepoTable.UserRepoRow(this.getRepository(), fUser));
                list.add(user);
            }
            this.helper().users = list;
            n = this.error(0);
        }
        catch (Exception ex) {
            int n2;
            try {
                LOGGER.warn("Can't retrieve topology plans from '" + this.getRepository().getLabel() + "'.", (Throwable)ex);
                n2 = this.error(30, "Can't retrieve topology plans from '" + this.getRepository().getLabel() + "'.");
            }
            catch (Throwable throwable) {
                DisposeUtils.disposeQuietly(usersTable_it);
                throw throwable;
            }
            DisposeUtils.disposeQuietly((Disposable)usersTable_it);
            return n2;
        }
        DisposeUtils.disposeQuietly((Disposable)usersTable_it);
        return n;
    }
}

