/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib.repository.remoteclient;

import java.net.MalformedURLException;
import java.net.URL;
import javax.json.JsonObject;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.json.Json;
import org.gvsig.json.JsonObjectBuilder;
import org.gvsig.tools.util.Factory;
import org.gvsig.vcsgis.lib.VCSGisEntity;
import org.gvsig.vcsgis.lib.VCSGisLocator;
import org.gvsig.vcsgis.lib.repository.AbstractRepository;
import org.gvsig.vcsgis.lib.repository.VCSGisRepositoryClient;
import org.gvsig.vcsgis.lib.repository.remoteclient.requests.AuthenticateRequestClient;
import org.gvsig.vcsgis.lib.repository.remoteclient.requests.CheckoutRequestClient;
import org.gvsig.vcsgis.lib.repository.remoteclient.requests.CommitRequestClient;
import org.gvsig.vcsgis.lib.repository.remoteclient.requests.EntitiesRequestClient;
import org.gvsig.vcsgis.lib.repository.remoteclient.requests.HistoryRequestClient;
import org.gvsig.vcsgis.lib.repository.remoteclient.requests.ListWCRequestClient;
import org.gvsig.vcsgis.lib.repository.remoteclient.requests.LogRequestClient;
import org.gvsig.vcsgis.lib.repository.remoteclient.requests.PrepareWCRequestClient;
import org.gvsig.vcsgis.lib.repository.remoteclient.requests.RevisionChangesRequestClient;
import org.gvsig.vcsgis.lib.repository.remoteclient.requests.RowCreateRequestClient;
import org.gvsig.vcsgis.lib.repository.remoteclient.requests.RowDeleteRequestClient;
import org.gvsig.vcsgis.lib.repository.remoteclient.requests.RowIsOutofdateRequestClient;
import org.gvsig.vcsgis.lib.repository.remoteclient.requests.RowUpdateRequestClient;
import org.gvsig.vcsgis.lib.repository.remoteclient.requests.TopologyPlansRequestClient;
import org.gvsig.vcsgis.lib.repository.remoteclient.requests.UpdateRequestClient;
import org.gvsig.vcsgis.lib.repository.remoteclient.requests.UsersRequestClient;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisAuthenticateRequest;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisCheckoutRequest;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisCommitRequest;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisEntitiesRequest;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisHistoryRequest;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisListWCRequest;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisLogRequest;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisPrepareWCRequest;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisRevisionChangesRequest;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisRowCreateRequest;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisRowDeleteRequest;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisRowIsOutofdateRequest;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisRowUpdateRequest;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisTopologyPlansRequest;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisUpdateRequest;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisUsersRequest;

public class VCSGisRepositoryClientImpl
extends AbstractRepository
implements VCSGisRepositoryClient {
    private URL url;
    private long requestTimeout = 60000L;

    public VCSGisRepositoryClientImpl() {
    }

    public static void selfRegister() {
        Json.registerSerializer(VCSGisRepositoryClientImpl.class);
    }

    public VCSGisRepositoryClientImpl(URL url, Factory authenticateRequestFactory) {
        this();
        this.url = url;
    }

    public void doDispose() {
        this.url = null;
    }

    public URL getUrl() {
        return this.url;
    }

    public URL getUrl(String ... parts) {
        try {
            StringBuilder builder = new StringBuilder();
            String url_s = this.url.toString();
            if (url_s.endsWith("/")) {
                url_s = StringUtils.removeEnd((String)url_s, (String)"/");
            }
            builder.append(url_s);
            for (String part : parts) {
                builder.append("/");
                builder.append(part);
            }
            builder.append("?auth=");
            builder.append(this.getAuthenticationToken());
            builder.append("&user=");
            builder.append(this.getUserCode());
            return new URL(builder.toString());
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }

    public long getRequestTimeout() {
        return this.requestTimeout;
    }

    public long getTimeoutForReceiveElements() {
        return this.requestTimeout;
    }

    public void fromJson(JsonObject json) {
        this.url = (URL)Json.toObject((JsonObject)json, (String)"url");
    }

    public JsonObjectBuilder toJsonBuilder() {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add_class((Object)this);
        builder.add("url", (Object)this.url);
        return builder;
    }

    public VCSGisCommitRequest createCommitRequest() {
        CommitRequestClient request = new CommitRequestClient(this);
        return request;
    }

    public VCSGisCheckoutRequest createCheckoutRequest(String entityName) {
        CheckoutRequestClient request = new CheckoutRequestClient(this, entityName);
        return request;
    }

    public VCSGisUpdateRequest createUpdateRequest(String entityName) {
        UpdateRequestClient request = new UpdateRequestClient(this, entityName);
        return request;
    }

    public VCSGisLogRequest createLogRequest(String entityName) {
        LogRequestClient request = new LogRequestClient(this, entityName);
        return request;
    }

    public VCSGisEntitiesRequest createEntitiesRequest() {
        return new EntitiesRequestClient(this);
    }

    public VCSGisListWCRequest createListWCRequest() {
        return new ListWCRequestClient(this);
    }

    public VCSGisHistoryRequest createHistoryRequest(String entityName) {
        return new HistoryRequestClient(this, entityName);
    }

    public VCSGisEntity getEntityByName(String entityName) {
        VCSGisEntitiesRequest request = this.createEntitiesRequest();
        if (request.execute() != 0) {
            return null;
        }
        for (VCSGisEntity repositoryEntity : request.getRepositoryEntities()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)repositoryEntity.getEntityName(), (CharSequence)entityName)) continue;
            return repositoryEntity;
        }
        return null;
    }

    public VCSGisRowCreateRequest createRowCreateRequest(String entityName, String localRevisionCode) {
        RowCreateRequestClient request = new RowCreateRequestClient(this, entityName, localRevisionCode);
        return request;
    }

    public VCSGisRowDeleteRequest createRowDeleteRequest(String entityName, String localRevisionCode) {
        RowDeleteRequestClient request = new RowDeleteRequestClient(this, entityName, localRevisionCode);
        return request;
    }

    public VCSGisRowUpdateRequest createRowUpdateRequest(String entityName, String localRevisionCode) {
        RowUpdateRequestClient request = new RowUpdateRequestClient(this, entityName, localRevisionCode);
        return request;
    }

    public VCSGisAuthenticateRequest createAuthenticateRequest(String userName, String password) {
        Factory factory = VCSGisLocator.getVCSGisManager().getAuthenticateRequestFactory();
        AuthenticateRequestClient request = factory == null ? new AuthenticateRequestClient(this) : (VCSGisAuthenticateRequest)factory.create(new Object[0]);
        request.setUserName(userName);
        request.setPassword(password);
        return request;
    }

    public VCSGisTopologyPlansRequest createTopologyPlansRequest() {
        TopologyPlansRequestClient request = new TopologyPlansRequestClient(this);
        return request;
    }

    public VCSGisUsersRequest createUsersRequest() {
        UsersRequestClient request = new UsersRequestClient(this);
        return request;
    }

    public VCSGisRowIsOutofdateRequest createRowIsOutofdatedRequest(String entityName, String localRevisionCode, String recordCode) {
        RowIsOutofdateRequestClient req = new RowIsOutofdateRequestClient(this, entityName, localRevisionCode, recordCode);
        return req;
    }

    public VCSGisPrepareWCRequest createPrepareWCRequest() {
        PrepareWCRequestClient request = new PrepareWCRequestClient(this);
        return request;
    }

    public VCSGisRevisionChangesRequest createRevisionChangesRequest(String entityName) {
        RevisionChangesRequestClient request = new RevisionChangesRequestClient(this, entityName);
        return request;
    }

    public String getCode() {
        return DigestUtils.md5Hex((String)this.url.toString());
    }
}

