/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib.repository.remoteclient.requests;

import java.io.BufferedReader;
import java.io.Writer;
import javax.json.JsonObject;
import org.apache.commons.io.IOUtils;
import org.gvsig.json.Json;
import org.gvsig.json.JsonObjectBuilder;
import org.gvsig.tools.dispose.DisposableIterable;
import org.gvsig.vcsgis.lib.EntityEditableImpl;
import org.gvsig.vcsgis.lib.PipedIterator;
import org.gvsig.vcsgis.lib.SAJParserImpl;
import org.gvsig.vcsgis.lib.VCSGisEntity;
import org.gvsig.vcsgis.lib.VCSGisRepositoryDataImpl;
import org.gvsig.vcsgis.lib.repository.VCSGisRepositoryData;
import org.gvsig.vcsgis.lib.repository.remoteclient.VCSGisRepositoryClientImpl;
import org.gvsig.vcsgis.lib.repository.remoteclient.requests.AbstractRequestClient;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisRevisionChangesRequest;
import org.gvsig.vcsgis.lib.requests.RevisionChangesRequestHelper;

public class RevisionChangesRequestClient
extends AbstractRequestClient
implements VCSGisRevisionChangesRequest {
    public RevisionChangesRequestClient(VCSGisRepositoryClientImpl repository, String entityName) {
        super(new RevisionChangesRequestHelper(repository, entityName), "revisionchanges");
    }

    @Override
    public RevisionChangesRequestHelper helper() {
        return (RevisionChangesRequestHelper)super.helper();
    }

    public String getEntityName() {
        return this.helper().getEntityName();
    }

    public String getLocalRevisionCode1() {
        return this.helper().getLocalRevisionCode1();
    }

    public void setLocalRevisionCode1(String revisionCode) {
        this.helper().setLocalRevisionCode1(revisionCode);
    }

    public String getLocalRevisionCode2() {
        return this.helper().getLocalRevisionCode2();
    }

    public void setLocalRevisionCode2(String revisionCode) {
        this.helper().setLocalRevisionCode2(revisionCode);
    }

    public VCSGisEntity getEntity() {
        return this.helper().getEntity();
    }

    public DisposableIterable<VCSGisRepositoryData> getData() {
        return this.helper().getData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestProducer(Writer out) {
        try {
            LOGGER.debug("===: [" + this.getRequestName() + "] requestProducer 1");
            JsonObjectBuilder parametersBuilder = Json.createObjectBuilder();
            parametersBuilder.add("EntityName", this.getEntityName());
            parametersBuilder.add("LocalRevisionCode1", this.getLocalRevisionCode1());
            parametersBuilder.add("LocalRevisionCode2", this.getLocalRevisionCode2());
            JsonObjectBuilder builder = Json.createObjectBuilder();
            builder.add("Parameters", (javax.json.JsonObjectBuilder)parametersBuilder);
            IOUtils.write((String)builder.toString(), (Writer)out);
            this.error(0);
        }
        catch (Exception ex) {
            LOGGER.warn("Can't produce Json data for " + this.getRequestName() + " request.", (Throwable)ex);
            this.error(600, "Can't produce Json data for " + this.getRequestName() + " request. " + ex.getMessage());
        }
        finally {
            IOUtils.closeQuietly((Writer)out);
        }
    }

    @Override
    public void responseConsumer(BufferedReader request_contents) {
        LOGGER.debug("===: [" + this.getRequestName() + "] responseConsumer 1");
        PipedIterator<VCSGisRepositoryData> dataIterator = new PipedIterator<VCSGisRepositoryData>(this.getRepository().getTimeoutForReceiveElements());
        this.helper().data = dataIterator;
        LOGGER.debug("===: [" + this.getRequestName() + "] responseConsumer 2");
        SAJParserImpl parser = new SAJParserImpl(request_contents, (context, e, value) -> {
            if (e == null) {
                return;
            }
            switch (e) {
                case END_OBJECT: {
                    switch (context.getPathName()) {
                        case "/Parameters": {
                            JsonObject jsonParams = ((javax.json.JsonObjectBuilder)value).build();
                            this.helper().error(jsonParams.getInt("StatusCode", 0), jsonParams.getString("StatusMessage", null));
                            this.helper().entity = jsonParams.isNull("Entity") ? null : new EntityEditableImpl(jsonParams.getJsonObject("Entity"));
                            this.notifyResponseConsumers();
                            break;
                        }
                        case "/Data/?": {
                            JsonObject jsonData = ((javax.json.JsonObjectBuilder)value).build();
                            VCSGisRepositoryDataImpl data = new VCSGisRepositoryDataImpl(jsonData);
                            dataIterator.put(data);
                        }
                    }
                    break;
                }
                case END_ARRAY: {
                    if (!"/Data".equals(context.getPathName())) break;
                    dataIterator.close();
                    break;
                }
                case START_ARRAY: {
                    switch (context.getPathName()) {
                        case "/Data": {
                            context.setArrayBuilder(null);
                        }
                    }
                }
            }
        });
        parser.parse();
    }
}

