/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib.repository.remoteclient.requests;

import java.io.BufferedReader;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonValue;
import org.gvsig.vcsgis.lib.VCSGisUser;
import org.gvsig.vcsgis.lib.VCSGisUserImpl;
import org.gvsig.vcsgis.lib.VCSGisUtils;
import org.gvsig.vcsgis.lib.repository.remoteclient.VCSGisRepositoryClientImpl;
import org.gvsig.vcsgis.lib.repository.remoteclient.requests.AbstractRequestClient;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisUsersRequest;
import org.gvsig.vcsgis.lib.requests.UsersRequestHelper;

public class UsersRequestClient
extends AbstractRequestClient
implements VCSGisUsersRequest {
    public UsersRequestClient(VCSGisRepositoryClientImpl repository) {
        super(new UsersRequestHelper(repository), "users");
    }

    @Override
    public UsersRequestHelper helper() {
        return (UsersRequestHelper)super.helper();
    }

    public List<VCSGisUser> getUsers() {
        return this.helper().getUsers();
    }

    @Override
    public void requestProducer(Writer out) {
        this.error(0);
    }

    @Override
    public void responseConsumer(BufferedReader inputData) {
        try {
            LOGGER.debug("===: [" + this.getRequestName() + "] responseConsumer");
            ArrayList<VCSGisUser> theUsers = new ArrayList<VCSGisUser>();
            JsonReader reader = Json.createReader((Reader)inputData);
            JsonObject jsonResponse = reader.readObject();
            JsonObject jsonParameters = jsonResponse.getJsonObject("Parameters");
            int statusCode = jsonParameters.getInt("StatusCode", 30);
            LOGGER.debug("===: [" + this.getRequestName() + "] responseConsumer status code " + statusCode);
            if (statusCode != 0) {
                this.error(statusCode, jsonParameters.getString("StatusMessage", VCSGisUtils.getErrorMessage(statusCode)));
                return;
            }
            this.cleanLastError();
            JsonArray jsonUsers = jsonResponse.getJsonArray("Users");
            LOGGER.debug("===: [" + this.getRequestName() + "] responseConsumer user " + jsonUsers.size());
            for (JsonValue x : jsonUsers) {
                VCSGisUserImpl user = new VCSGisUserImpl((JsonObject)x);
                LOGGER.debug("===: [" + this.getRequestName() + "] responseConsumer user " + user.getIdentifier());
                theUsers.add(user);
            }
            this.helper().users = theUsers;
            LOGGER.debug("===: [" + this.getRequestName() + "] responseConsumer ok");
            this.error(0);
        }
        catch (Exception ex) {
            LOGGER.warn("Can't retrieve users from '" + this.getRequestUrl() + "'.", (Throwable)ex);
            this.error(30, "Can't retrieve users from '" + this.getRequestUrl() + "'.");
        }
    }
}

