/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib.requests;

import org.gvsig.tools.dispose.DisposableIterable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.vcsgis.lib.VCSGisEntity;
import org.gvsig.vcsgis.lib.VCSGisEntityEditable;
import org.gvsig.vcsgis.lib.repository.VCSGisRepository;
import org.gvsig.vcsgis.lib.repository.VCSGisRepositoryData;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisRevisionChangesRequest;
import org.gvsig.vcsgis.lib.requests.AbstractRequestHelper;

public class RevisionChangesRequestHelper
extends AbstractRequestHelper
implements VCSGisRevisionChangesRequest {
    private static final String REQUEST_NAME = "RevisionChanges";
    public String entityName;
    public String localRevisionCode1;
    public String localRevisionCode2;
    public VCSGisEntityEditable entity;
    public DisposableIterable<VCSGisRepositoryData> data;

    public RevisionChangesRequestHelper(VCSGisRepository repository, String entityName) {
        super(repository, REQUEST_NAME);
        this.entityName = entityName;
        this.localRevisionCode1 = null;
        this.localRevisionCode2 = null;
        this.entity = null;
        this.data = null;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getLocalRevisionCode1() {
        return this.localRevisionCode1;
    }

    public void setLocalRevisionCode1(String revisionCode) {
        this.localRevisionCode1 = revisionCode;
    }

    public String getLocalRevisionCode2() {
        return this.localRevisionCode2;
    }

    public void setLocalRevisionCode2(String revisionCode) {
        this.localRevisionCode2 = revisionCode;
    }

    public DisposableIterable<VCSGisRepositoryData> getData() {
        if (this.data == null) {
            throw new IllegalStateException("The request needs to be executed before calling this method.");
        }
        return this.data;
    }

    public VCSGisEntity getEntity() {
        if (this.data == null) {
            throw new IllegalStateException("The request needs to be executed before calling this method.");
        }
        return this.entity;
    }

    @Override
    public void dispose() {
        super.dispose();
        DisposeUtils.disposeQuietly(this.data);
        this.data = null;
        this.entity = null;
        this.entityName = null;
        this.localRevisionCode1 = null;
        this.localRevisionCode2 = null;
    }
}

