/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib.server.handlers;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonReader;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.mutable.MutableObject;
import org.gvsig.json.Json;
import org.gvsig.json.JsonObjectBuilder;
import org.gvsig.vcsgis.lib.repository.VCSGisRepository;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisAuthenticateRequest;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisRequest;
import org.gvsig.vcsgis.lib.server.handlers.AbstractVCSGisServertHandler;

public class AuthenticateHandler
extends AbstractVCSGisServertHandler {
    public AuthenticateHandler(VCSGisRepository repository) {
        super(repository, "EntitiesHandler");
    }

    @Override
    protected void requestProducer(MutableObject<VCSGisRequest> req, Map<String, String> params, Reader request_contents) throws IOException {
        JsonObject jsonParameters = null;
        try {
            JsonReader reader = Json.createReader((Reader)request_contents);
            JsonObject jsonRequest = reader.readObject();
            jsonParameters = jsonRequest.getJsonObject("Parameters");
        }
        catch (JsonException reader) {
            // empty catch block
        }
        String userName = params.get("UserId");
        String password = params.get("Password");
        if (jsonParameters != null) {
            userName = jsonParameters.getString("UserId", userName);
            password = jsonParameters.getString("Password", password);
        }
        LOGGER.debug("===: [" + this.getName() + "] requestProducer 1");
        VCSGisAuthenticateRequest request = this.getRepository().createAuthenticateRequest(userName, password);
        req.setValue((Object)request);
        LOGGER.debug("===: [" + this.getName() + "] requestProducer 2 notifyRequestConsumers");
        this.notifyRequestConsumers();
        LOGGER.debug("===: [" + this.getName() + "] requestProducer 3 return");
    }

    @Override
    protected void responseProducer(VCSGisRequest req, Writer response_contents) throws IOException {
        LOGGER.debug("===: [" + this.getName() + "] responseProducer  1");
        VCSGisAuthenticateRequest request = (VCSGisAuthenticateRequest)req;
        LOGGER.debug("===: [" + this.getName() + "] responseProducer  3");
        JsonObjectBuilder builder = Json.createObjectBuilder();
        JsonObjectBuilder jsonParams = Json.createObjectBuilder();
        jsonParams.add("StatusCode", request.getLastErrorCode());
        jsonParams.add("StatusMessage", request.getLastErrorMessage());
        jsonParams.add("UserCode", request.getUserCode());
        jsonParams.add("AuthenticationToken", request.getAuthenticationToken());
        builder.add("Parameters", (javax.json.JsonObjectBuilder)jsonParams);
        LOGGER.debug("===: [" + this.getName() + "] responseProducer 2 notifyResponseConsumers");
        this.notifyResponseConsumers();
        LOGGER.debug("===: [" + this.getName() + "] responseProducer 3 write json to response");
        IOUtils.write((String)builder.toString(), (Writer)response_contents);
        LOGGER.debug("===: [" + this.getName() + "] responseProducer 4 flush");
        response_contents.flush();
        LOGGER.debug("===: [" + this.getName() + "] responseProducer 5 return");
    }
}

