/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib.server.servlets;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.json.JsonObject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.gvsig.json.Json;
import org.gvsig.vcsgis.lib.server.VCSGisServerController;
import org.gvsig.vcsgis.lib.server.VCSGisServerHandler;
import org.gvsig.vcsgis.lib.server.servlets.AbstractVCSGisServlet;

public class RepoInfoServlet
extends AbstractVCSGisServlet {
    @Override
    protected VCSGisServerHandler createHandler(VCSGisServerController vcsgisserver) {
        return null;
    }

    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.doGet(request, response);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        StringBuilder builder;
        response.setStatus(200);
        response.setContentType("text/html");
        response.setCharacterEncoding("utf-8");
        response.getWriter().println("<h1>VCSGis repository information</h1>");
        this.initLibraries();
        File prepared_working_copies_folder = null;
        File conf_folder = null;
        try {
            prepared_working_copies_folder = new File(this.getServletContext().getRealPath("/preparedwcs"));
        }
        catch (Exception ex) {
            LOGGER.debug("", (Throwable)ex);
        }
        try {
            conf_folder = new File(prepared_working_copies_folder, "../../../conf").getCanonicalFile();
            if (!conf_folder.exists()) {
                conf_folder = null;
            }
        }
        catch (Exception ex) {
            LOGGER.debug("", (Throwable)ex);
        }
        JsonObject config = this.getConfiguration();
        boolean repoinfo_extended = config == null || config.getBoolean("repoinfo_extended", true);
        response.getWriter().println("Context: " + this.getContextID() + "<br>");
        response.getWriter().println("VCSGis Version: " + this.getVersion() + "<br>");
        response.getWriter().println("Client host: " + request.getRemoteHost() + "<br><br>");
        if (config == null) {
            response.getWriter().println("<p>Can't retrieve vcsgisserver config information</p>");
        } else if (config.containsKey((Object)"ConnectionParameters")) {
            builder = new StringBuilder();
            JsonObject params = config.getJsonObject("ConnectionParameters");
            builder.append("<b>Repository connection parameters</b>:<ul>\n");
            builder.append("<li>ProviderName: ").append(Json.toObject((JsonObject)params, (String)"ProviderName")).append("</li>\n");
            if (repoinfo_extended) {
                builder.append("<li>Host: ").append(Json.toObject((JsonObject)params, (String)"host")).append("</li>\n");
                builder.append("<li>Port: ").append(Json.toObject((JsonObject)params, (String)"port")).append("</li>\n");
                builder.append("<li>DBName: ").append(Json.toObject((JsonObject)params, (String)"dbname")).append("</li>\n");
                builder.append("<li>DBUser: ").append(Json.toObject((JsonObject)params, (String)"dbuser")).append("</li>\n");
                builder.append("<li>DBCatalog: ").append(Json.toObject((JsonObject)params, (String)"Catalog")).append("</li>\n");
                builder.append("<li>DBSchema: ").append(Json.toObject((JsonObject)params, (String)"Schema")).append("</li>\n");
                builder.append("<li>DBFile: ").append(Json.toObject((JsonObject)params, (String)"database_file")).append("</li>\n");
            }
            builder.append("</ul>\n");
            response.getWriter().println(builder.toString());
        }
        if (repoinfo_extended) {
            builder = new StringBuilder();
            builder.append("<br>\n");
            builder.append("expected PREPARED_WORKING_COPIES_FOLDER=").append(prepared_working_copies_folder).append("<br>\n");
            builder.append("<br>\n");
            builder.append("VCSGIS_SERVER_CONFIG=").append(System.getenv("VCSGIS_SERVER_CONFIG")).append("<br>\n");
            builder.append("CATALINA_BASE=").append(System.getenv("CATALINA_BASE")).append("<br>\n");
            builder.append("CONF_FOLDER=").append(conf_folder).append("<br>\n");
            builder.append("<br>\n");
            builder.append("CONFIG URL=").append(this.getConfigurationURL()).append("<br>\n");
            builder.append("<br>\n");
            builder.append("CALLBACK_METHOD=").append(Json.toObject((JsonObject)config, (String)"CALLBACK_METHOD")).append("<br>\n");
            builder.append("<br>\n");
            builder.append("Set \"repoinfo_extended\":false in config file to remove this information.<br>\n");
            builder.append("<br>\n");
            response.getWriter().println(builder.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getVersion() {
        String string;
        InputStream stream;
        block5: {
            stream = null;
            stream = this.getServletContext().getResourceAsStream("META-INF/maven/org.gvsig/org.gvsig.vcsgis.tomcat.webapp/pom.properties");
            if (stream != null) break block5;
            String string2 = "unknown";
            IOUtils.closeQuietly((InputStream)stream);
            return string2;
        }
        try {
            String version;
            Properties prop = new Properties();
            prop.load(stream);
            string = version = prop.getProperty("version");
        }
        catch (IOException ex) {
            String string3;
            try {
                string3 = "unknown";
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(stream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)stream);
            return string3;
        }
        IOUtils.closeQuietly((InputStream)stream);
        return string;
    }
}

