/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib.server.servlets;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.vcsgis.lib.repository.localdb.VCSGisRepositoryLocaldbImpl;
import org.gvsig.vcsgis.lib.repository.localdb.tables.HooksRepoTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VCSGisServletContextListener
implements ServletContextListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(VCSGisServletContextListener.class);

    public void contextInitialized(ServletContextEvent sce) {
        LOGGER.info("VCSGis start application");
    }

    public void contextDestroyed(ServletContextEvent sce) {
        VCSGisRepositoryLocaldbImpl repository;
        LOGGER.info("VCSGis end application");
        ServletContext context = sce.getServletContext();
        HooksRepoTable.WatchersNotifier watchersNotifier = (HooksRepoTable.WatchersNotifier)context.getAttribute("VCSGisWatchersNotifier");
        if (watchersNotifier != null) {
            watchersNotifier.shutdown();
            context.setAttribute("VCSGisWatchersNotifier", null);
        }
        if ((repository = (VCSGisRepositoryLocaldbImpl)((Object)context.getAttribute("VCSGisRepository"))) != null) {
            DisposeUtils.disposeQuietly((Disposable)repository);
            context.setAttribute("VCSGisRepository", null);
        }
    }
}

