/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib.workspace;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.EditingNotification;
import org.gvsig.fmap.dal.EditingNotificationManager;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureStoreNotification;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.store.jdbc.JDBCStoreParameters;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposableInfo;
import org.gvsig.tools.dispose.DisposableManager;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dynobject.Tags;
import org.gvsig.tools.observer.Observable;
import org.gvsig.tools.observer.Observer;
import org.gvsig.vcsgis.lib.VCSGisLocator;
import org.gvsig.vcsgis.lib.VCSGisManager;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspaceImpl;
import org.gvsig.vcsgis.lib.workspace.tables.EntitiesTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureStoreObserver
implements Observer {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeatureStoreObserver.class);
    private VCSGisManager manager = null;
    private static final List<Pair<WeakReference<FeatureStore>, Integer>> inediting_list = new ArrayList<Pair<WeakReference<FeatureStore>, Integer>>();

    private VCSGisManager getManager() {
        if (this.manager == null) {
            this.manager = VCSGisLocator.getManager();
        }
        return this.manager;
    }

    private VCSGisWorkspaceImpl getWorkspace(FeatureStore store) {
        return (VCSGisWorkspaceImpl)this.getManager().getWorkspace(store);
    }

    public void update(Observable observable, Object notification) {
        EditingNotification enotification;
        FeatureStoreNotification fsnotification;
        VCSGisWorkspaceImpl workspace;
        block44: {
            block42: {
                block43: {
                    Feature feature;
                    FeatureStore store;
                    workspace = null;
                    fsnotification = null;
                    enotification = null;
                    if (!(notification instanceof EditingNotification)) break block42;
                    enotification = (EditingNotification)notification;
                    if (!enotification.getType().equals("BEFORE_INSERT_FEATURE") || (workspace = this.getWorkspace(store = enotification.getFeatureStore())) == null || !StringUtils.isBlank((CharSequence)(feature = enotification.getFeature()).getString("VCSGISCODE")) || !(feature instanceof EditableFeature)) break block43;
                    ((EditableFeature)feature).set("VCSGISCODE", (Object)workspace.createUniqueCode());
                }
                DisposeUtils.disposeQuietly(workspace);
                return;
            }
            fsnotification = (FeatureStoreNotification)notification;
            if (fsnotification != null) break block44;
            DisposeUtils.disposeQuietly(workspace);
            return;
        }
        try {
            FeatureStore store = (FeatureStore)fsnotification.getSource();
            switch (fsnotification.getType()) {
                case "after_Open_DataStore": {
                    workspace = this.getWorkspace(store);
                    if (workspace == null) break;
                    store.setProperty("DAL.featureTypeEditMode", (Object)1);
                    store.setProperty("DAL.featureTypeEditMode.msg", (Object)"_The_table_is_under_version_control_The_changes_you_make_will_be_lost_next_checkout");
                    FeatureType ft = store.getDefaultFeatureTypeQuietly();
                    if (ft == null) break;
                    Tags tags = ft.getTags();
                    tags.set("vcsgis.storename", (Object)store.getName());
                    EntitiesTable.EntityRow entity = workspace.getWorkspaceEntityByName(store.getName());
                    if (entity == null) break;
                    if (!tags.has("vcsgis.label")) {
                        tags.set("vcsgis.label", (Object)entity.getLabel());
                    }
                    if (!tags.has("vcsgis.datamodel")) {
                        tags.set("vcsgis.datamodel", (Object)entity.getDataModels());
                    }
                    if (!tags.has("vcsgis.category")) {
                        tags.set("vcsgis.category", (Object)entity.getCategory());
                    }
                    if (!tags.has("vcsgis.fieldforlabel")) {
                        tags.set("vcsgis.fieldforlabel", (Object)entity.getFieldForLabel());
                    }
                    if (!tags.has("vcsgis.resources")) {
                        tags.set("vcsgis.resources", (Object)entity.getResources());
                    }
                    if (StringUtils.isBlank((CharSequence)ft.getLabel())) {
                        ft.setLabel(entity.getLabel());
                    }
                    if (!StringUtils.isBlank((CharSequence)ft.getDescription())) break;
                    ft.setDescription(entity.getDescription());
                    break;
                }
                case "before_Insert_Feature": {
                    workspace = this.getWorkspace(store);
                    if (workspace == null) break;
                    EditableFeature feature = (EditableFeature)fsnotification.getFeature();
                    if (StringUtils.isBlank((CharSequence)feature.getString("VCSGISCODE"))) {
                        feature.set("VCSGISCODE", (Object)workspace.createUniqueCode());
                    }
                    if (!store.isAppending() && store.getMode() != 3) break;
                    workspace.addChange(fsnotification.getEditingSession(), 2, store, (Feature)feature);
                    break;
                }
                case "before_Update_Feature": {
                    if (!store.isAppending() && store.getMode() != 3 || (workspace = this.getWorkspace(store)) == null) break;
                    workspace.addChange(fsnotification.getEditingSession(), 1, store, fsnotification.getFeature());
                    break;
                }
                case "before_Delete_Feature": {
                    if (store.isAppending()) {
                        workspace = this.getWorkspace(store);
                        if (workspace == null) break;
                        workspace.addChange(fsnotification.getEditingSession(), 0, store, fsnotification.getFeature());
                        break;
                    }
                    if (store.getMode() != 3 || (workspace = this.getWorkspace(store)) == null) break;
                    Feature f = fsnotification.getFeature();
                    if (f == null) {
                        workspace.addDeleteChanges(fsnotification.getEditingSession(), store, fsnotification.getExpression());
                        break;
                    }
                    workspace.addChange(fsnotification.getEditingSession(), 0, store, fsnotification.getFeature());
                    break;
                }
                case "after_Update_Type": {
                    if (!store.isAppending()) break;
                    break;
                }
                case "before_FinishEditing_DataStore": {
                    int stat;
                    if (!store.isEditing()) break;
                    boolean provocaError = false;
                    if (provocaError) {
                        throw new RuntimeException();
                    }
                    workspace = this.getWorkspace(store);
                    if (workspace == null || (stat = workspace.addChanges(store, fsnotification.getEditingSession(), fsnotification.getInsertedsFeatures(), fsnotification.getUpdatedsFeatures(), fsnotification.getDeletedsFeatures(), fsnotification.getChangedsFeatureTypes())) == 0) break;
                    fsnotification.cancel();
                    break;
                }
                case "failed_FinishEditing_DataStore": {
                    if (!store.isEditing() || (workspace = this.getWorkspace(store)) == null) break;
                    workspace.cancelChanges(store, fsnotification.getEditingSession());
                    break;
                }
                case "after_FinishEditing_DataStore": {
                    this.remove_from_inediting_list(store);
                    workspace = this.getWorkspace(store);
                    if (workspace == null) break;
                    workspace.acceptChanges(store, fsnotification.getEditingSession());
                    if (!workspace.isAResourceTable(store.getName())) break;
                    DALLocator.getDataManager().clearAllCachedResources();
                    break;
                }
                case "after_StartEditing_DataStore": {
                    this.add_to_inediting_list(store, fsnotification.getEditMode());
                    break;
                }
                case "after_CancelEditing_DataStore": {
                    this.remove_from_inediting_list(store);
                    workspace = this.getWorkspace(store);
                    if (workspace == null) break;
                    workspace.cancelChanges(store, fsnotification.getEditingSession());
                }
            }
        }
        catch (Throwable th) {
            try {
                if (fsnotification != null) {
                    fsnotification.abort(th);
                }
                if (enotification != null) {
                    enotification.abort(th);
                }
                throw th;
            }
            catch (Throwable throwable) {
                DisposeUtils.disposeQuietly(workspace);
                throw throwable;
            }
        }
        DisposeUtils.disposeQuietly((Disposable)workspace);
    }

    public static void install() {
        DataManager dataManager = DALLocator.getDataManager();
        FeatureStoreObserver obs = new FeatureStoreObserver();
        dataManager.addStoreObserver((Observer)obs);
        EditingNotificationManager editingNotificationManager = DALSwingLocator.getEditingNotificationManager();
        editingNotificationManager.addObserver((Observer)obs);
    }

    static int getEditMode(FeatureStore store) {
        if (store == null) {
            return -1;
        }
        for (int i = 0; i < inediting_list.size(); ++i) {
            WeakReference ref;
            Pair<WeakReference<FeatureStore>, Integer> pair = inediting_list.get(i);
            if (pair == null || (ref = (WeakReference)pair.getLeft()) == null) continue;
            FeatureStore currentStore = (FeatureStore)ref.get();
            if (currentStore == null) {
                inediting_list.set(i, null);
                break;
            }
            if (!StringUtils.equalsIgnoreCase((CharSequence)store.getFullName(), (CharSequence)currentStore.getFullName())) continue;
            return (Integer)pair.getRight();
        }
        return 0;
    }

    public static boolean isEditing(FeatureStore store) {
        int editMode = FeatureStoreObserver.getEditMode(store);
        return editMode != 0;
    }

    private void remove_from_inediting_list(FeatureStore store) {
        boolean found = false;
        for (int i = 0; i < inediting_list.size(); ++i) {
            Pair<WeakReference<FeatureStore>, Integer> pair = inediting_list.get(i);
            if (pair == null) continue;
            WeakReference ref = (WeakReference)pair.getLeft();
            if (ref == null) {
                inediting_list.set(i, null);
                continue;
            }
            FeatureStore currentStore = (FeatureStore)ref.get();
            if (currentStore == null) {
                inediting_list.set(i, null);
                continue;
            }
            if (currentStore == store) {
                LOGGER.trace("Terminate editing " + store.getFullName());
                inediting_list.set(i, null);
                found = true;
                continue;
            }
            if (currentStore.getMode() != 0) continue;
            inediting_list.set(i, null);
        }
        if (!found) {
            LOGGER.warn("Terminate editing of non editing store " + store.getFullName());
        }
    }

    private void add_to_inediting_list(FeatureStore store, int editMode) {
        if (store == null) {
            return;
        }
        LOGGER.trace("Start editing " + store.getFullName());
        WeakReference<FeatureStore> newref = new WeakReference<FeatureStore>(store);
        for (int i = 0; i < inediting_list.size(); ++i) {
            Pair<WeakReference<FeatureStore>, Integer> pair = inediting_list.get(i);
            if (pair != null && pair.getLeft() != null && ((WeakReference)pair.getLeft()).get() != null) continue;
            if (newref == null) {
                inediting_list.set(i, null);
                continue;
            }
            inediting_list.set(i, (Pair<WeakReference<FeatureStore>, Integer>)new ImmutablePair(newref, (Object)editMode));
            newref = null;
        }
        if (newref != null) {
            inediting_list.add((Pair<WeakReference<FeatureStore>, Integer>)new ImmutablePair(newref, (Object)editMode));
        }
    }

    public static List<Pair<WeakReference<FeatureStore>, Integer>> getInEditingList() {
        return inediting_list;
    }

    public static boolean isThereAnyStoreInEditing() {
        for (int i = 0; i < inediting_list.size(); ++i) {
            WeakReference ref;
            Pair<WeakReference<FeatureStore>, Integer> pair = inediting_list.get(i);
            if (pair == null || (ref = (WeakReference)pair.getLeft()) == null) continue;
            FeatureStore currentStore = (FeatureStore)ref.get();
            if (currentStore == null) {
                inediting_list.set(i, null);
                break;
            }
            if ((Integer)pair.getRight() == 0) continue;
            return true;
        }
        return false;
    }

    public static boolean IsThereConflictingStoresInEdition() {
        for (int i = 0; i < inediting_list.size(); ++i) {
            WeakReference ref;
            Pair<WeakReference<FeatureStore>, Integer> pair = inediting_list.get(i);
            if (pair == null || (ref = (WeakReference)pair.getLeft()) == null) continue;
            FeatureStore currentStore = (FeatureStore)ref.get();
            if (currentStore == null) {
                inediting_list.set(i, null);
                break;
            }
            if (!(currentStore.getParameters() instanceof JDBCStoreParameters) || (Integer)pair.getRight() == 0) continue;
            return true;
        }
        return false;
    }

    public static int getReferencesCount() {
        DisposableManager disposableManager = ToolsLocator.getDisposableManager();
        int count = 0;
        for (DisposableInfo boundDisposable : disposableManager.getBoundDisposables()) {
            count += boundDisposable.getReferencesCount();
        }
        return count;
    }

    public static Object getReferences() {
        HashMap<Integer, Integer> references = new HashMap<Integer, Integer>();
        DisposableManager disposableManager = ToolsLocator.getDisposableManager();
        for (DisposableInfo boundDisposable : disposableManager.getBoundDisposables()) {
            references.put(boundDisposable.getDisposable().hashCode(), boundDisposable.getReferencesCount());
        }
        return references;
    }

    public static void dumpDisposables(Object references) {
        DisposableManager disposableManager = ToolsLocator.getDisposableManager();
        for (DisposableInfo boundDisposable : disposableManager.getBoundDisposables()) {
            Disposable d = boundDisposable.getDisposable();
            Integer x = (Integer)((Map)references).get(d.hashCode());
            if (x != null && boundDisposable.getReferencesCount() <= x) continue;
            String s = "";
            try {
                s = Objects.toString(d);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            LOGGER.info(String.format("%x", d.hashCode()) + " " + (boundDisposable.getReferencesCount() - (x == null ? 0 : x)) + " " + d.getClass().getSimpleName() + " " + s);
        }
    }
}

