/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib.workspace;

import java.util.Date;
import java.util.Objects;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.store.jdbc.JDBCServerExplorerParameters;
import org.gvsig.fmap.dal.store.jdbc2.JDBCServerExplorer;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dispose.impl.AbstractDisposable;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.vcsgis.lib.VCSGisLocator;
import org.gvsig.vcsgis.lib.VCSGisManagerImpl;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspace;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspaceDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VCSGisWorkspaceDescriptorImpl
extends AbstractDisposable
implements VCSGisWorkspaceDescriptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(VCSGisWorkspaceDescriptorImpl.class);
    private String label;
    private String code;
    private JDBCServerExplorerParameters explorerParameters;
    private JDBCServerExplorer explorer;
    private VCSGisWorkspace workspace;
    private long lastUse;
    private boolean disposed = false;

    public VCSGisWorkspaceDescriptorImpl() {
    }

    public VCSGisWorkspaceDescriptorImpl(VCSGisWorkspace workspace) {
        this.setWorkspace(workspace);
    }

    public String getCode() {
        return this.code;
    }

    public boolean isWorkspaceInitialized() {
        return this.workspace != null && this.workspace.getExplorer() != null;
    }

    public VCSGisWorkspace getWorkspace() {
        boolean workspaceIsValid;
        boolean haveWorkspace = this.workspace != null;
        boolean bl = workspaceIsValid = haveWorkspace && this.workspace.getExplorer() != null;
        if (!haveWorkspace || !workspaceIsValid) {
            LOGGER.info("Descriptor has not workspace or is invalid: " + this.getDebugInfo());
            VCSGisManagerImpl manager = (VCSGisManagerImpl)VCSGisLocator.getVCSGisManager();
            VCSGisWorkspace theWorkspace = manager.openWorkspace(this.getExplorer(), false);
            this.setWorkspace(theWorkspace);
            ((VCSGisManagerImpl)VCSGisLocator.getVCSGisManager()).addToIdentityManager(this.workspace);
        }
        this.lastUse = new Date().getTime();
        DisposeUtils.bind((Disposable)this.workspace);
        return this.workspace;
    }

    public String getLabel() {
        return this.label;
    }

    public VCSGisWorkspaceDescriptor getValue() {
        return this;
    }

    public JDBCServerExplorer getExplorer() {
        if (this.explorer == null) {
            if (this.workspace == null || this.workspace.getExplorer() == null) {
                try {
                    DataManager manager = DALLocator.getDataManager();
                    this.explorer = (JDBCServerExplorer)manager.openServerExplorer(this.explorerParameters.getProviderName(), (DataServerExplorerParameters)this.explorerParameters);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            } else {
                this.explorer = this.workspace.getExplorer();
            }
        }
        DisposeUtils.bind((Disposable)this.explorer);
        return this.explorer;
    }

    public JDBCServerExplorerParameters getExplorerParameters() {
        return this.explorerParameters;
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set("label", this.label);
        state.set("code", this.code);
        state.set("explorerParameters", (Persistent)this.explorerParameters);
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        this.code = state.getString("code");
        this.label = state.getString("label");
        this.explorerParameters = (JDBCServerExplorerParameters)state.get("explorerParameters");
    }

    public static void selfRegister() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        if (manager.getDefinition("VCSGisWorkspaceDescriptor") == null) {
            DynStruct definition = manager.addDefinition(VCSGisWorkspaceDescriptorImpl.class, "VCSGisWorkspaceDescriptor", "VCSGisWorkspaceDescriptor persistent definition", null, null);
            definition.addDynFieldString("code");
            definition.addDynFieldString("label");
            definition.addDynFieldObject("explorerParameters").setClassOfValue(JDBCServerExplorerParameters.class).setMandatory(true);
        }
    }

    public String toString() {
        return this.getLabel();
    }

    public void setWorkspace(VCSGisWorkspace workspace) {
        if (workspace == null) {
            throw new IllegalArgumentException("workspace can't be null.");
        }
        DisposeUtils.disposeQuietly((Disposable)this.workspace);
        DisposeUtils.disposeQuietly((Disposable)this.explorer);
        this.workspace = workspace;
        DisposeUtils.bind((Disposable)this.workspace);
        this.explorerParameters = workspace.getExplorerParameters();
        this.explorer = null;
        this.label = workspace.getLabel();
        this.code = workspace.getCode();
        this.lastUse = new Date().getTime();
    }

    protected void doDispose() throws BaseException {
        DisposeUtils.disposeQuietly((Disposable)this.workspace);
        DisposeUtils.disposeQuietly((Disposable)this.explorer);
        this.explorerParameters = null;
        this.explorer = null;
        this.workspace = null;
        this.code = null;
        this.disposed = true;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public void dropExpiredCaches() {
        long now = new Date().getTime();
        if (now > this.lastUse + 60000L) {
            this.dropCaches();
        }
    }

    public void dropCaches() {
        DisposeUtils.disposeQuietly((Disposable)this.workspace);
        DisposeUtils.disposeQuietly((Disposable)this.explorer);
        this.workspace = null;
        this.explorer = null;
    }

    public String getDebugInfo() {
        boolean wsvalid = this.workspace != null && this.workspace.getExplorer() != null;
        boolean hasws = this.workspace != null;
        String url = this.explorerParameters == null ? null : this.explorerParameters.getUrl();
        return "{ code:'" + Objects.toString(this.code) + "', label:'" + Objects.toString(this.label) + "', url:'" + Objects.toString(url) + "', hasws:'" + hasws + "', wsvalid:'" + wsvalid + "'}";
    }
}

