/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.cache.buffer;

public abstract class RasterBase {
    private static final long serialVersionUID = 1L;
    private int dataType = 32;
    private int bandCount = 0;
    private int width = 0;
    private int height = 0;
    private int x = 0;
    private int y = 0;
    public double noDataValue = -99999.0;

    public RasterBase(int x, int y, int w, int h) {
        this.x = x;
        this.y = y;
        this.width = w;
        this.height = h;
    }

    public RasterBase(int x, int y, int w, int h, int dataType, int nBands) {
        this.x = x;
        this.y = y;
        this.width = w;
        this.height = h;
        this.dataType = dataType;
        this.bandCount = nBands;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getDataType() {
        return this.dataType;
    }

    public void setDataType(int dataType) {
        this.dataType = dataType;
    }

    public int getBandCount() {
        return this.bandCount;
    }

    public void setBandCount(int bandCount) {
        this.bandCount = bandCount;
    }

    public void bandPlusPlus() {
        ++this.bandCount;
    }

    public void bandLessLess() {
        --this.bandCount;
    }

    public double getNoDataValue() {
        return this.noDataValue;
    }

    public void setNoDataValue(double noDataValue) {
        this.noDataValue = noDataValue;
    }

    public int getDataSize() {
        if (this.getDataType() == 0) {
            return 1;
        }
        if (this.getDataType() == 2 | this.getDataType() == 1) {
            return 2;
        }
        if (this.getDataType() == 3) {
            return 4;
        }
        if (this.getDataType() == 4) {
            return 8;
        }
        if (this.getDataType() == 5) {
            return 16;
        }
        return 0;
    }

    public long sizeof() {
        return this.getDataSize() * this.getWidth() * this.getHeight() * this.getBandCount();
    }
}

