/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.layout;

import java.awt.geom.AffineTransform;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.gvsig.andami.PluginServices;
import org.gvsig.app.project.ProjectManager;
import org.gvsig.app.project.documents.layout.Attributes;
import org.gvsig.app.project.documents.layout.CustomizableObserverHelper;
import org.gvsig.app.project.documents.layout.DefaultLayoutManager;
import org.gvsig.app.project.documents.layout.DefaultLayoutNotification;
import org.gvsig.app.project.documents.layout.LayoutContext;
import org.gvsig.app.project.documents.layout.TocModelChangedImpl;
import org.gvsig.app.project.documents.layout.TocModelChangedNotification;
import org.gvsig.app.project.documents.layout.commands.FrameCommandsRecord;
import org.gvsig.app.project.documents.layout.commands.FrameManager;
import org.gvsig.app.project.documents.layout.fframes.FFrame;
import org.gvsig.app.project.documents.layout.fframes.FFrameGroup;
import org.gvsig.app.project.documents.layout.fframes.IFFrame;
import org.gvsig.app.project.documents.layout.fframes.IFFrameUseFMap;
import org.gvsig.app.project.documents.layout.toc.TocModelObserver;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.observer.Observable;
import org.gvsig.tools.observer.ObservableHelper;
import org.gvsig.tools.observer.Observer;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;

public class DefaultLayoutContext
implements LayoutContext {
    public static final String PERSISTENCE_DEFINITION_NAME = "LayoutContext";
    private static final String ISADJUSTINGTOGRID_FIELD = "isAdjustingToGrid";
    private static final String IS_GRID_VISIBLE = "IS_GRID_VISIBLE";
    private static final String IS_RULER_VISIBLE = "IS_RULER_VISIBLE";
    private static final String ISEDITABLE_FIELD = "isEditable";
    private static final String HAS_WINDOW_BEEN_EVER_OPEN_FIELD = "hasDocBeenOpened";
    private static final String NUMBEHIND_FIELD = "numBehind";
    private static final String NUMBEFORE_FIELD = "numBefore";
    private static final String ATTRIBUTES_FIELD = "attributes";
    private static final String FFRAMES_FIELD = "fframes";
    private static DefaultLayoutManager layoutManager = null;
    private Attributes m_attributes = null;
    private IFFrame[] fframes;
    private FrameCommandsRecord fcr;
    private static Hashtable nums = new Hashtable();
    private int numBefore = 0;
    private int numBehind = 0;
    private boolean isEditable = true;
    private Boolean adjustToGrid = null;
    private boolean hasDocBeenOpened = false;
    private Boolean m_showRuler;
    private Boolean isGridVisible = null;
    private AffineTransform m_MatrizTransf;
    private ObservableHelper observers;
    private CustomizableObserverHelper tocObservers = new CustomizableObserverHelper(){

        @Override
        protected void doNotify(Object listener, Object data) {
            TocModelObserver l = (TocModelObserver)listener;
            l.tocUpdated(DefaultLayoutContext.this, (TocModelChangedNotification)data);
        }
    };
    private MapContext tocModel = null;

    public DefaultLayoutContext() {
        layoutManager = (DefaultLayoutManager)ProjectManager.getInstance().getDocumentManager("project.document.layout");
        this.observers = new ObservableHelper();
        this.m_attributes = new Attributes();
        this.m_MatrizTransf = new AffineTransform();
        this.m_MatrizTransf.setToIdentity();
        FrameManager fm = new FrameManager();
        this.fcr = new FrameCommandsRecord(fm);
        this.updateFFrames();
    }

    @Override
    public AffineTransform getAT() {
        return this.m_MatrizTransf;
    }

    @Override
    public Attributes getAttributes() {
        return this.m_attributes;
    }

    @Override
    public void setAtributes(Attributes attributes) {
        this.m_attributes = attributes;
    }

    @Override
    public IFFrame[] getFFrames() {
        return this.fframes;
    }

    @Override
    public IFFrame getFFrame(int i) {
        return this.fframes[i];
    }

    @Override
    public void updateFFrames() {
        ArrayList<IFFrame> frames = new ArrayList<IFFrame>();
        IFFrame[] auxfframes = this.fcr.getFrameManager().getFFrames();
        for (int j = this.numBehind; j <= this.numBefore; ++j) {
            for (int i = 0; i < auxfframes.length; ++i) {
                if (auxfframes[i].getLevel() != j) continue;
                frames.add(auxfframes[i]);
            }
        }
        this.fframes = frames.toArray(new IFFrame[0]);
    }

    @Override
    public void delFFrameSelected() {
        this.fcr.startComplex(PluginServices.getText((Object)this, (String)"remove_elements"));
        IFFrame[] validFrames = this.fcr.getFrameManager().getFFrames();
        for (int i = 0; i < validFrames.length; ++i) {
            IFFrame fframe = validFrames[i];
            if (!fframe.isSelected()) continue;
            fframe.setSelected(false);
            this.fcr.delete(fframe);
        }
        this.fcr.endComplex();
        this.updateFFrames();
    }

    @Override
    public void clearSelection() {
        for (int i = this.fcr.getFrameManager().getAllFFrames().length - 1; i >= 0; --i) {
            IFFrame fframe = this.fcr.getFrameManager().getFFrame(i);
            if (fframe.getSelected() == 0) continue;
            fframe.setSelected(false);
        }
    }

    @Override
    public void delFFrame(int index) {
        IFFrame frame = this.getFFrame(index);
        this.delFFrame(frame);
    }

    @Override
    public void delFFrame(IFFrame frame) {
        for (int i = 0; i < this.fcr.getFrameManager().getAllFFrames().length; ++i) {
            if (!this.fcr.getFrameManager().getFFrame(i).equals(frame)) continue;
            frame.setSelected(false);
            this.fcr.delete(frame);
        }
        this.updateFFrames();
    }

    @Override
    public FrameCommandsRecord getFrameCommandsRecord() {
        return this.fcr;
    }

    @Override
    public void addFFrame(IFFrame frame, boolean clearSelection, boolean select) {
        frame.setLayoutContext(this);
        IFFrame[] fframes = this.getFFrames();
        if (clearSelection) {
            for (int i = fframes.length - 1; i >= 0; --i) {
                IFFrame fframe1 = fframes[i];
                fframe1.setSelected(false);
            }
        }
        if (nums.containsKey(frame.getClass())) {
            nums.put(frame.getClass(), new Integer(Integer.parseInt(nums.get(frame.getClass()).toString()) + 1));
        } else {
            nums.put(frame.getClass(), new Integer(0));
        }
        frame.setNum(Integer.parseInt(nums.get(frame.getClass()).toString()));
        this.fcr.insert(frame);
        frame.setSelected(select);
        frame.setLevel(this.getNumBefore());
        this.updateFFrames();
    }

    @Override
    public void addFFrameSameProperties(IFFrame frame) {
        this.fcr.insert(frame);
        frame.setSelected(true);
        frame.setLevel(this.getNumBefore());
        this.updateFFrames();
    }

    @Override
    public int getNumBehind() {
        return --this.numBehind;
    }

    @Override
    public int getNumBefore() {
        return ++this.numBefore;
    }

    @Override
    public IFFrame[] getAllFFrames() {
        ArrayList all = new ArrayList();
        return this.allFFrames(this.getFFrames(), all).toArray(new IFFrame[0]);
    }

    @Override
    public Iterator deepiterator() {
        ArrayList all = new ArrayList();
        this.allFFrames(this.getFFrames(), all);
        return all.iterator();
    }

    @Override
    public Iterator iterator() {
        return Arrays.asList(this.fframes).iterator();
    }

    private List allFFrames(IFFrame[] fframes, List all) {
        for (int i = 0; i < fframes.length; ++i) {
            if (fframes[i] instanceof FFrameGroup) {
                List groupFrames = this.allFFrames(((FFrameGroup)fframes[i]).getFFrames(), all);
                if (all.containsAll(groupFrames)) continue;
                all.addAll(groupFrames);
                continue;
            }
            if (all.contains(fframes[i])) continue;
            all.add(fframes[i]);
        }
        return all;
    }

    @Override
    public IFFrame[] getSelectedFFrames() {
        ArrayList<IFFrame> selecList = new ArrayList<IFFrame>();
        IFFrame[] fframes = this.getFFrames();
        for (int i = fframes.length - 1; i >= 0; --i) {
            IFFrame fframe = fframes[i];
            if (fframe.getSelected() == 0) continue;
            selecList.add(fframe);
        }
        return selecList.toArray(new IFFrame[selecList.size()]);
    }

    @Override
    public <T> T[] getSelectedFFrames(Class<T> clazz) {
        ArrayList<IFFrame> selecList = new ArrayList<IFFrame>();
        IFFrame[] fframes = this.getFFrames();
        for (int i = fframes.length - 1; i >= 0; --i) {
            IFFrame fframe = fframes[i];
            if (!clazz.isInstance(fframe) || fframe.getSelected() == 0) continue;
            selecList.add(fframe);
        }
        Object[] newInstance = (Object[])Array.newInstance(clazz, selecList.size());
        return selecList.toArray(newInstance);
    }

    @Override
    public boolean isEditable() {
        return this.isEditable;
    }

    @Override
    public void setEditable(boolean b) {
        if (!b) {
            this.clearSelection();
            PluginServices.getMainFrame().setSelectedTool("ZOOM_IN");
        }
        this.isEditable = b;
    }

    @Override
    public boolean isAdjustingToGrid() {
        if (this.adjustToGrid == null) {
            this.adjustToGrid = new Boolean(layoutManager.getDefaultAdjustToGrid());
        }
        return this.adjustToGrid;
    }

    @Override
    public void setAdjustToGrid(boolean b) {
        this.adjustToGrid = new Boolean(b);
    }

    @Override
    public void setRuler(boolean b) {
        this.m_showRuler = new Boolean(b);
    }

    @Override
    public boolean getRuler() {
        if (this.m_showRuler == null) {
            this.m_showRuler = new Boolean(layoutManager.getDefaultShowRulers());
        }
        return this.m_showRuler;
    }

    @Override
    public boolean isGridVisible() {
        if (this.isGridVisible == null) {
            this.isGridVisible = new Boolean(layoutManager.getDefaultShowGrid());
        }
        return this.isGridVisible;
    }

    @Override
    public void setGridVisible(boolean b) {
        this.isGridVisible = new Boolean(b);
    }

    @Override
    public void fullRefresh() {
        IFFrame[] fframes = this.getFFrames();
        for (int i = 0; i < fframes.length; ++i) {
            if (!(fframes[i] instanceof IFFrameUseFMap)) continue;
            IFFrameUseFMap fframe = (IFFrameUseFMap)fframes[i];
            fframe.refresh();
        }
        this.notifAllObservers();
    }

    @Override
    public void notifAllObservers() {
        this.observers.notifyObservers((Observable)this, (Object)new DefaultLayoutNotification("layout_refresh"));
    }

    public static void registerPersistent() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        if (manager.getDefinition(PERSISTENCE_DEFINITION_NAME) == null) {
            DynStruct definition = manager.addDefinition(DefaultLayoutContext.class, PERSISTENCE_DEFINITION_NAME, "Layout context persistence definition", null, null);
            definition.addDynFieldInt(NUMBEHIND_FIELD).setMandatory(true);
            definition.addDynFieldInt(NUMBEFORE_FIELD).setMandatory(true);
            definition.addDynFieldObject(ATTRIBUTES_FIELD).setClassOfValue(Attributes.class).setMandatory(true);
            definition.addDynFieldArray(FFRAMES_FIELD).setClassOfItems(IFFrame.class).setMandatory(true);
            definition.addDynFieldBoolean(ISADJUSTINGTOGRID_FIELD).setMandatory(true);
            definition.addDynFieldBoolean(ISEDITABLE_FIELD).setMandatory(true);
            definition.addDynFieldBoolean(IS_GRID_VISIBLE).setMandatory(false);
            definition.addDynFieldBoolean(IS_RULER_VISIBLE).setMandatory(false);
            definition.addDynFieldBoolean(HAS_WINDOW_BEEN_EVER_OPEN_FIELD).setMandatory(false);
        }
        FFrame.registerPersistent();
        Attributes.registerPersistent();
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        this.adjustToGrid = state.getBoolean(ISADJUSTINGTOGRID_FIELD);
        this.isEditable = state.getBoolean(ISEDITABLE_FIELD);
        if (state.hasValue(IS_GRID_VISIBLE)) {
            this.isGridVisible = state.getBoolean(IS_GRID_VISIBLE);
        }
        if (state.hasValue(IS_RULER_VISIBLE)) {
            this.m_showRuler = state.getBoolean(IS_RULER_VISIBLE);
        }
        if (state.hasValue(HAS_WINDOW_BEEN_EVER_OPEN_FIELD)) {
            this.setHasDocBeenOpened(state.getBoolean(HAS_WINDOW_BEEN_EVER_OPEN_FIELD));
        } else {
            this.setHasDocBeenOpened(true);
        }
        this.numBehind = state.getInt(NUMBEHIND_FIELD);
        this.numBefore = state.getInt(NUMBEFORE_FIELD);
        this.m_attributes = (Attributes)state.get(ATTRIBUTES_FIELD);
        IFFrame[] fframes = (IFFrame[])state.getArray(FFRAMES_FIELD, IFFrame.class);
        for (int i = 0; i < fframes.length; ++i) {
            this.addFFrame(fframes[i], true, true);
        }
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set(ISADJUSTINGTOGRID_FIELD, this.isAdjustingToGrid());
        state.set(ISEDITABLE_FIELD, this.isEditable());
        state.set(NUMBEHIND_FIELD, this.numBehind);
        state.set(NUMBEFORE_FIELD, this.numBefore);
        state.set(ATTRIBUTES_FIELD, (Persistent)this.m_attributes);
        state.set(FFRAMES_FIELD, (Object[])this.fframes);
        state.set(HAS_WINDOW_BEEN_EVER_OPEN_FIELD, new Boolean(this.hasDocBeenOpened()));
        state.set(IS_RULER_VISIBLE, this.getRuler());
        state.set(IS_GRID_VISIBLE, this.isGridVisible());
    }

    @Override
    public void setNumBefore(int numBefore) {
        this.numBefore = numBefore;
    }

    @Override
    public void setNumBehind(int numBehind) {
        this.numBehind = numBehind;
    }

    public void addObserver(Observer o) {
        this.observers.addObserver(o);
    }

    public void deleteObserver(Observer o) {
        this.observers.deleteObserver(o);
    }

    public void deleteObservers() {
        this.observers.deleteObservers();
    }

    @Override
    public void setTocModel(MapContext tocModel) {
        MapContext oldModel = this.tocModel;
        this.tocModel = tocModel;
        if (tocModel == oldModel) {
            return;
        }
        this.tocObservers.notifyObservers(this, new TocModelChangedImpl(TocModelChangedNotification.Type.MODEL_SET, tocModel));
    }

    @Override
    public void notifyTocUpdated(TocModelChangedNotification.Type type) {
        this.tocObservers.notifyObservers(this, new TocModelChangedImpl(type, this.tocModel));
    }

    @Override
    public MapContext getTocModel() {
        return this.tocModel;
    }

    @Override
    public void addTocObserver(TocModelObserver observer) {
        this.tocObservers.addObserver(observer);
    }

    @Override
    public void removeTocObserver(TocModelObserver observer) {
        this.tocObservers.deleteObserver(observer);
    }

    @Override
    public void removeTocObservers() {
        this.tocObservers.deleteObservers();
    }

    @Override
    public boolean hasDocBeenOpened() {
        return this.hasDocBeenOpened;
    }

    @Override
    public void setHasDocBeenOpened(boolean hasBeenOpened) {
        this.hasDocBeenOpened = hasBeenOpened;
    }
}

