/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.layout;

import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.gvsig.app.project.documents.Document;
import org.gvsig.app.project.documents.layout.fframes.IFFrame;
import org.gvsig.app.project.documents.layout.fframes.IFFrameUseFMap;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.FLayers;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FLayoutUtilities {
    private static Logger logger = LoggerFactory.getLogger(FLayoutUtilities.class);

    public static boolean isEqualList(ArrayList n, ArrayList l) {
        if (n.size() != l.size()) {
            return false;
        }
        for (int i = 0; i < n.size(); ++i) {
            if (l.get(i) == n.get(i)) continue;
            return false;
        }
        return true;
    }

    public static double toSheetDistance(double d, AffineTransform at) {
        double dist = d / at.getScaleX();
        return dist;
    }

    public static double fromSheetDistance(double d, AffineTransform at) {
        Point2D.Double pSheet1 = new Point2D.Double(0.0, 0.0);
        Point2D.Double pSheet2 = new Point2D.Double(1.0, 0.0);
        Point2D.Double pScreen1 = new Point2D.Double();
        Point2D.Double pScreen2 = new Point2D.Double();
        try {
            at.transform(pSheet1, pScreen1);
            at.transform(pSheet2, pScreen2);
        }
        catch (Exception e) {
            System.err.print(e.getMessage());
        }
        return pScreen1.distance(pScreen2) * d;
    }

    public static Point2D.Double toSheetPoint(Point2D pScreen, AffineTransform at) {
        Point2D.Double pWorld = new Point2D.Double();
        try {
            AffineTransform at1 = at.createInverse();
            at1.transform(pScreen, pWorld);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
        return pWorld;
    }

    public static Rectangle2D.Double toSheetRect(Rectangle2D r, AffineTransform at) {
        Point2D.Double pSheet = FLayoutUtilities.toSheetPoint(new Point2D.Double(r.getX(), r.getY()), at);
        Point2D.Double pSheetX = FLayoutUtilities.toSheetPoint(new Point2D.Double(r.getMaxX(), r.getMinY()), at);
        Point2D.Double pSheetY = FLayoutUtilities.toSheetPoint(new Point2D.Double(r.getMinX(), r.getMaxY()), at);
        Rectangle2D.Double res = new Rectangle2D.Double();
        res.setRect(pSheet.getX(), pSheet.getY(), pSheet.distance(pSheetX), pSheet.distance(pSheetY));
        return res;
    }

    public static Point2D.Double fromSheetPoint(Point2D pSheet, AffineTransform at) {
        Point2D.Double pScreen = new Point2D.Double();
        try {
            at.transform(pSheet, pScreen);
        }
        catch (Exception e) {
            System.err.print(e.getMessage());
        }
        return pScreen;
    }

    public static Rectangle2D.Double fromSheetRect(Rectangle2D r, AffineTransform at) {
        Point2D.Double pSheet = new Point2D.Double(r.getX(), r.getY());
        Point2D.Double pSX = new Point2D.Double(r.getMaxX(), r.getMinY());
        Point2D.Double pSY = new Point2D.Double(r.getMinX(), r.getMaxY());
        Point2D.Double pScreen = new Point2D.Double();
        Point2D.Double pScreenX = new Point2D.Double();
        Point2D.Double pScreenY = new Point2D.Double();
        try {
            at.transform(pSheet, pScreen);
            at.transform(pSX, pScreenX);
            at.transform(pSY, pScreenY);
        }
        catch (Exception e) {
            System.err.print(e.getMessage());
        }
        Rectangle2D.Double res = new Rectangle2D.Double();
        res.setRect(pScreen.getX(), pScreen.getY(), pScreen.distance(pScreenX), pScreen.distance(pScreenY));
        return res;
    }

    public static Point getPointGrid(Point p, double distX, double distY, AffineTransform at) {
        if (distX * at.getScaleX() < 2.0 && distY * at.getScaleY() < 2.0) {
            return p;
        }
        Point2D.Double auxp = FLayoutUtilities.fromSheetPoint(new Point2D.Double(0.0, 0.0), at);
        double gridintx = distX * at.getScaleX();
        double gridinty = distY * at.getScaleY();
        double seppx = (long)p.x - Math.round(auxp.x);
        double seppy = (long)p.y - Math.round(auxp.y);
        long round_int_p_x = Math.round(seppx / gridintx);
        long round_int_p_y = Math.round(seppy / gridinty);
        seppx = (double)round_int_p_x * gridintx;
        seppy = (double)round_int_p_y * gridinty;
        return new Point((int)(auxp.x + seppx), (int)(auxp.y + seppy));
    }

    public static boolean isPosible(Rectangle2D.Double r) {
        return !(r.getMaxX() > 2.147483647E9 || r.getMaxY() > 2.147483647E9 || r.getMinX() < -2.147483648E9 || r.getMinY() < -2.147483648E9 || r.getWidth() > 2.147483647E9) && !(r.getHeight() > 2.147483647E9);
    }

    public static List<Document> removeEditing(List<Document> list) {
        ArrayList<Document> resp = new ArrayList<Document>();
        Document item = null;
        ViewDocument viewdoc = null;
        for (int i = 0; i < list.size(); ++i) {
            item = list.get(i);
            if (!(item instanceof ViewDocument) || FLayoutUtilities.hasEditingLayers(viewdoc = (ViewDocument)item)) continue;
            resp.add(item);
        }
        return resp;
    }

    public static boolean hasEditingLayers(ViewDocument viewdoc) {
        return FLayoutUtilities.hasEditingLayers(viewdoc.getMapContext().getLayers());
    }

    public static boolean hasEditingLayers(FLayers lyrs) {
        int len = lyrs.getLayersCount();
        FLayer lyr = null;
        FLyrVect vlyr = null;
        for (int i = 0; i < len; ++i) {
            lyr = lyrs.getLayer(i);
            if (!(lyr instanceof FLyrVect ? (vlyr = (FLyrVect)lyr).isEditing() : lyr instanceof FLayers && FLayoutUtilities.hasEditingLayers((FLayers)lyr))) continue;
            return true;
        }
        return false;
    }

    public static Point2D screenCoordinatesToViewportImageCoordinates(Point2D screenp, IFFrame frame) {
        if (screenp == null || frame == null || !(frame instanceof IFFrameUseFMap)) {
            logger.info("Bad parameters in screenCoordinatesToViewportImageCoordinates", (Throwable)new Exception("Null values or Frame has no MapContext"));
            return screenp;
        }
        Rectangle2D.Double rect = frame.getBoundingBox(null);
        double screenRectWidth = rect.width;
        double vpWidth = ((IFFrameUseFMap)frame).getMapContext().getViewPort().getImageWidth();
        if (screenRectWidth < 1.0 || vpWidth < 1.0) {
            logger.info("Bad size in screen/viewport (screenRectWidth = " + screenRectWidth + ", " + "vpWidth = " + vpWidth + ")");
            return screenp;
        }
        Point2D.Double po = new Point2D.Double(screenp.getX() - rect.x, screenp.getY() - rect.y);
        double ratio = vpWidth * 1.0 / (screenRectWidth * 1.0);
        Point2D.Double resp = new Point2D.Double(ratio * ((Point2D)po).getX(), ratio * ((Point2D)po).getY());
        return resp;
    }
}

