/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.layout.fframes;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import org.gvsig.andami.PluginServices;
import org.gvsig.app.project.Project;
import org.gvsig.app.project.documents.layout.FLayoutUtilities;
import org.gvsig.app.project.documents.layout.fframes.AbstractFFrameViewDependence;
import org.gvsig.app.project.documents.layout.fframes.IFFrame;
import org.gvsig.app.project.documents.layout.fframes.IFFrameUseProject;
import org.gvsig.app.project.documents.layout.fframes.IFFrameViewDependence;
import org.gvsig.compat.print.PrintAttributes;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;

public class FFrameGroup
extends AbstractFFrameViewDependence
implements IFFrameUseProject,
IFFrameViewDependence {
    public static final String PERSISTENCE_DEFINITION_NAME = "FFrameGroup";
    private static final String FFRAMES_FIELD = "fframes";
    private List<IFFrame> m_fframes = new ArrayList<IFFrame>();
    private Rectangle2D.Double rg = null;
    private AffineTransform m_at;
    private Project project;

    public void addFFrame(IFFrame fframe) {
        this.m_fframes.add(fframe);
    }

    public IFFrame[] getFFrames() {
        return this.m_fframes.toArray(new IFFrame[0]);
    }

    public Rectangle2D.Double getRectangle(AffineTransform at) {
        IFFrame[] fframes;
        boolean first = true;
        Rectangle2D.Double rec = new Rectangle2D.Double();
        for (IFFrame fframe : fframes = this.getFFrames()) {
            Rectangle2D.Double rs = fframe.getBoundingBox(at);
            if (first) {
                rec.setRect(rs);
                first = false;
            }
            rec.add(rs);
        }
        this.rg = new Rectangle2D.Double();
        this.rg.setRect(FLayoutUtilities.toSheetRect(rec, at));
        return rec;
    }

    @Override
    public void draw(Graphics2D g, AffineTransform at, Rectangle2D rv, BufferedImage imgBase) {
        Rectangle2D.Double r = this.getBoundingBox(at);
        g.rotate(Math.toRadians(this.getRotation()), r.x + r.width / 2.0, r.y + r.height / 2.0);
        this.m_at = at;
        for (int i = 0; i < this.m_fframes.size(); ++i) {
            this.m_fframes.get(i).draw(g, at, rv, imgBase);
        }
        g.rotate(Math.toRadians(-this.getRotation()), r.x + r.width / 2.0, r.y + r.height / 2.0);
    }

    public void setAt(AffineTransform at) {
        this.m_at = at;
    }

    @Override
    public void setBoundBox(Rectangle2D r) {
        this.getBoundBox().setRect(r.getX(), r.getY(), r.getWidth(), r.getHeight());
        if (this.rg != null) {
            IFFrame[] fframes;
            Rectangle2D.Double raux1 = new Rectangle2D.Double(this.rg.x, this.rg.y, this.rg.width, this.rg.height);
            double dx = r.getX() - raux1.x;
            double dy = r.getY() - raux1.y;
            double dw = r.getWidth() / raux1.width;
            double dh = r.getHeight() / raux1.height;
            for (IFFrame fframe : fframes = this.getFFrames()) {
                Rectangle2D.Double raux = new Rectangle2D.Double();
                raux.setRect(fframe.getBoundBox());
                AffineTransform escalado = new AffineTransform();
                escalado.setToScale(dw, dh);
                escalado.translate(dx - r.getX(), dy - r.getY());
                Point2D.Double pd = new Point2D.Double();
                escalado.transform(new Point2D.Double(raux.x, raux.y), pd);
                raux.x = pd.x + r.getX();
                raux.y = pd.y + r.getY();
                raux.width *= dw;
                raux.height *= dh;
                fframe.setBoundBox(raux);
            }
        } else {
            this.rg = new Rectangle2D.Double();
            this.rg.setRect(r);
        }
        this.rg.setRect(r);
    }

    @Override
    public String getNameFFrame() {
        return PluginServices.getText((Object)this, (String)"grupo") + this.num;
    }

    @Override
    public String getName() {
        return PERSISTENCE_DEFINITION_NAME;
    }

    public void print(Graphics2D g, AffineTransform at, Geometry geom, PrintAttributes printingProperties) {
        IFFrame[] fframes;
        Rectangle2D.Double r = this.getBoundingBox(at);
        g.rotate(Math.toRadians(this.getRotation()), r.x + r.width / 2.0, r.y + r.height / 2.0);
        for (IFFrame fframe : fframes = this.m_fframes.toArray(new IFFrame[0])) {
            fframe.print(g, at, geom, printingProperties);
        }
        g.rotate(Math.toRadians(-this.getRotation()), r.x + r.width / 2.0, r.y + r.height / 2.0);
    }

    @Override
    public void setProject(Project project) {
        this.project = project;
    }

    public void initialize() {
    }

    public void clearFFrames() {
        this.m_fframes.clear();
    }

    public IFFrame removeFFrame(int i) {
        return this.m_fframes.remove(i);
    }

    public void removeFFrame(IFFrame fframe) {
        this.m_fframes.remove(fframe);
    }

    @Override
    public IFFrame clone() throws CloneNotSupportedException {
        FFrameGroup frame = (FFrameGroup)super.clone();
        frame.setSelected(this.getSelected() != 0);
        frame.m_fframes = new ArrayList<IFFrame>();
        for (int i = 0; i < this.m_fframes.size(); ++i) {
            frame.addFFrame((IFFrame)this.m_fframes.get(i).clone());
        }
        frame.m_at = this.m_at != null ? new AffineTransform(this.m_at) : new AffineTransform();
        if (this.rg != null) {
            frame.rg = new Rectangle2D.Double(this.rg.x, this.rg.y, this.rg.width, this.rg.height);
        }
        return frame;
    }

    @Override
    public void setFFrameDependence(IFFrame f) {
        IFFrame[] frames;
        for (IFFrame frame : frames = this.getFFrames()) {
            if (!(frame instanceof IFFrameViewDependence)) continue;
            ((IFFrameViewDependence)((Object)frame)).setFFrameDependence(f);
        }
    }

    @Override
    public IFFrame[] getFFrameDependence() {
        IFFrame[] frames = this.getFFrames();
        ArrayList<IFFrame> dependences = new ArrayList<IFFrame>();
        for (int i = 0; i < frames.length; ++i) {
            IFFrame[] framesAux;
            if (!(frames[i] instanceof IFFrameViewDependence)) continue;
            for (IFFrame framesAux1 : framesAux = ((IFFrameViewDependence)((Object)frames[i])).getFFrameDependence()) {
                dependences.add(framesAux[i]);
            }
        }
        return dependences.toArray(new IFFrame[0]);
    }

    @Override
    public void refreshDependence(IFFrame fant, IFFrame fnew) {
        IFFrame[] frames;
        for (IFFrame frame : frames = this.getFFrames()) {
            if (fnew instanceof FFrameGroup) {
                IFFrame[] framesGroupNew;
                for (IFFrame framesGroupNew1 : framesGroupNew = ((FFrameGroup)fnew).getFFrames()) {
                    IFFrame[] framesGroupAnt;
                    if (!(fant instanceof FFrameGroup)) continue;
                    for (IFFrame framesGroupAnt1 : framesGroupAnt = ((FFrameGroup)fant).getFFrames()) {
                        if (!(framesGroupAnt1 instanceof IFFrameViewDependence)) continue;
                        this.refreshDependence(framesGroupAnt1, framesGroupNew1);
                    }
                }
                continue;
            }
            if (!(frame instanceof IFFrameViewDependence)) continue;
            ((IFFrameViewDependence)((Object)frame)).refreshDependence(fant, fnew);
        }
    }

    public static void registerPersistent() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        if (manager.getDefinition(PERSISTENCE_DEFINITION_NAME) == null) {
            DynStruct definition = manager.addDefinition(FFrameGroup.class, PERSISTENCE_DEFINITION_NAME, "FFrameGroup persistence definition", null, null);
            definition.extend(manager.getDefinition("AbstractFFrameViewDependence"));
            definition.addDynFieldList(FFRAMES_FIELD).setClassOfItems(IFFrame.class).setMandatory(true);
        }
    }

    @Override
    public void loadFromState(PersistentState state) throws PersistenceException {
        super.loadFromState(state);
        this.m_fframes = state.getList(FFRAMES_FIELD);
    }

    @Override
    public void saveToState(PersistentState state) throws PersistenceException {
        super.saveToState(state);
        state.set(FFRAMES_FIELD, this.m_fframes);
    }
}

