/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.layout.fframes;

import com.sun.jimi.core.Jimi;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImagingOpException;
import java.io.File;
import javax.swing.ImageIcon;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.UserAgentAdapter;
import org.apache.batik.bridge.ViewBox;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.renderer.StaticRenderer;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.messages.NotificationManager;
import org.gvsig.app.project.documents.layout.fframes.FFrame;
import org.gvsig.app.project.documents.layout.fframes.IFFrame;
import org.gvsig.compat.print.PrintAttributes;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGDocument;

public class FFramePicture
extends FFrame {
    public static final String PERSISTENCE_DEFINITION_NAME = "FFramePicture";
    private static final String PATH_FIELD = "path";
    private static final String QUALITY_FIELD = "quality";
    private static final String VIEWING_FIELD = "viewing";
    protected static RenderingHints defaultRenderingHints = new RenderingHints(null);
    private static final int PRESENTACION = 0;
    private static final int ACTIVO = 1;
    private BufferedImage m_image = null;
    private int m_quality = 0;
    private int m_viewing = 1;
    private String m_path = null;
    private boolean isSVG = false;
    private StaticRenderer renderer = new StaticRenderer();
    private Element elt;
    private GVTBuilder gvtBuilder = new GVTBuilder();
    private GraphicsNode gvtRoot = null;
    private BridgeContext ctx;

    @Override
    public void draw(Graphics2D g, AffineTransform at, Rectangle2D rv, BufferedImage imgBase) {
        Rectangle2D.Double r = this.getBoundingBox(at);
        g.rotate(Math.toRadians(this.getRotation()), r.x + r.width / 2.0, r.y + r.height / 2.0);
        double x = r.getMinX();
        double y = r.getMinY();
        double w = r.getWidth();
        double h = r.getHeight();
        if (this.intersects(rv, r) || w != 0.0 || h != 0.0) {
            if (this.m_image == null && !this.isSVG) {
                this.drawEmpty(g);
            } else if (rv == null || this.getQuality() == 0) {
                if (!this.isSVG) {
                    double scalex = w / (double)this.m_image.getWidth(null);
                    double scaley = h / (double)this.m_image.getHeight(null);
                    try {
                        AffineTransform xform = AffineTransform.getScaleInstance(scalex, scaley);
                        AffineTransform xpos = AffineTransform.getTranslateInstance(x, y);
                        xpos.concatenate(xform);
                        g.drawRenderedImage(this.m_image, xpos);
                    }
                    catch (ImagingOpException e) {
                        NotificationManager.addError((String)"Dibujando FFramePicture", (Throwable)e);
                    }
                } else if (this.isSVG) {
                    try {
                        if (r != null) {
                            this.drawSVG(g, r, rv);
                        }
                    }
                    catch (OutOfMemoryError e) {
                        NotificationManager.addError((String)"Dibujando SVG FFramePicture", (Throwable)e);
                    }
                    catch (IllegalArgumentException e) {
                        NotificationManager.addError((String)"Dibujando SVG FFramePicture", (Throwable)e);
                    }
                }
                System.gc();
            } else {
                this.drawDraft(g);
            }
        }
        g.rotate(Math.toRadians(-this.getRotation()), r.x + r.width / 2.0, r.y + r.height / 2.0);
    }

    private void drawSVG(Graphics2D g, Rectangle2D rect, Rectangle2D rv) {
        AffineTransform ataux;
        if (rv == null || rv.contains(rect)) {
            ataux = new AffineTransform();
            ataux.translate(rect.getX(), rect.getY());
            try {
                ataux.concatenate(ViewBox.getViewTransform(null, (Element)this.elt, (float)((float)rect.getWidth()), (float)((float)rect.getHeight()), (BridgeContext)this.ctx));
                this.gvtRoot.setTransform(ataux);
            }
            catch (Exception exception) {}
        } else {
            ataux = new AffineTransform();
            ataux.translate(rect.getX(), rect.getY());
            ataux.concatenate(ViewBox.getViewTransform(null, (Element)this.elt, (float)((float)rect.getWidth()), (float)((float)rect.getHeight()), (BridgeContext)this.ctx));
            this.gvtRoot.setTransform(ataux);
        }
        RenderingHints renderingHints = defaultRenderingHints;
        g.setRenderingHints(renderingHints);
        if (this.gvtRoot != null) {
            this.gvtRoot.paint(g);
        }
    }

    public void setQuality(int q) {
        this.m_quality = q;
    }

    public int getQuality() {
        return this.m_quality;
    }

    public int getViewing() {
        return this.m_viewing;
    }

    public void setViewing(int v) {
        this.m_viewing = v;
    }

    public void setPath(String path) {
        this.m_path = path;
    }

    public String getPath() {
        return this.m_path;
    }

    public void setImage(BufferedImage image) {
        this.m_image = image;
    }

    public Dimension getBound(String file) {
        Image img = this.load(file);
        if (this.isSVG) {
            return new Dimension(100, 100);
        }
        if (img == null) {
            return new Dimension((int)this.getBoundingBox(null).getWidth(), (int)this.getBoundingBox(null).getHeight());
        }
        return new Dimension(img.getWidth(null), img.getHeight(null));
    }

    public Image load(String file) {
        if (file == null) {
            return null;
        }
        ImageIcon tmpIcon = null;
        File f = new File(file);
        if (file == null || !f.exists()) {
            return null;
        }
        this.setPath(file);
        String iString = file.toLowerCase();
        if (iString.endsWith("jpg") || iString.endsWith("jpeg") || iString.endsWith("gif")) {
            tmpIcon = new ImageIcon(Jimi.getImage((String)file, (int)8));
        } else if (iString.endsWith("png") || iString.endsWith("tif") || iString.endsWith("ico") || iString.endsWith("xpm") || iString.endsWith("bmp")) {
            tmpIcon = new ImageIcon(Jimi.getImage((String)file, (int)8));
        } else if (iString.endsWith("svg")) {
            this.isSVG = true;
            this.obtainStaticRenderer(new File(file));
        } else {
            tmpIcon = new ImageIcon(file);
        }
        if (!this.isSVG && tmpIcon != null) {
            Image image = tmpIcon.getImage();
            if (image.getWidth(null) == -1 || image.getHeight(null) == -1) {
                NotificationManager.showMessageError((String)PluginServices.getText((Object)this, (String)"unsupported_format"), (Exception)new Exception());
                return null;
            }
            BufferedImage bi = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
            Graphics2D biContext = bi.createGraphics();
            biContext.drawImage(image, 0, 0, null);
            this.setImage(bi);
            return image;
        }
        return null;
    }

    private void obtainStaticRenderer(File file) {
        try {
            UserAgentAdapter userAgent = new UserAgentAdapter();
            DocumentLoader loader = new DocumentLoader((UserAgent)userAgent);
            BridgeContext ctx = new BridgeContext((UserAgent)userAgent, loader);
            Document svgDoc = loader.loadDocument(file.toURI().toString());
            this.gvtRoot = this.gvtBuilder.build(ctx, svgDoc);
            this.renderer.setTree(this.gvtRoot);
            this.elt = ((SVGDocument)svgDoc).getRootElement();
            ctx = new BridgeContext((UserAgent)userAgent, loader);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public String getNameFFrame() {
        return PluginServices.getText((Object)this, (String)"imagen") + this.num;
    }

    @Override
    public String getName() {
        return PERSISTENCE_DEFINITION_NAME;
    }

    public void initialize() {
    }

    public void cloneActions(IFFrame frame) {
        this.m_image = null;
    }

    public void print(Graphics2D g, AffineTransform at, Geometry geom, PrintAttributes properties) {
        this.draw(g, at, null, null);
    }

    public static void registerPersistent() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        if (manager.getDefinition(PERSISTENCE_DEFINITION_NAME) == null) {
            DynStruct definition = manager.addDefinition(FFramePicture.class, PERSISTENCE_DEFINITION_NAME, "FFramePicture persistence definition", null, null);
            definition.extend(manager.getDefinition("FFrame"));
            definition.addDynFieldString(PATH_FIELD).setMandatory(true);
            definition.addDynFieldInt(QUALITY_FIELD).setMandatory(true);
            definition.addDynFieldInt(VIEWING_FIELD).setMandatory(true);
        }
    }

    @Override
    public void loadFromState(PersistentState state) throws PersistenceException {
        super.loadFromState(state);
        this.m_path = state.getString(PATH_FIELD);
        this.m_quality = state.getInt(QUALITY_FIELD);
        this.m_viewing = state.getInt(VIEWING_FIELD);
        this.load(this.m_path);
    }

    @Override
    public void saveToState(PersistentState state) throws PersistenceException {
        super.saveToState(state);
        state.set(PATH_FIELD, this.m_path);
        state.set(QUALITY_FIELD, this.m_quality);
        state.set(VIEWING_FIELD, this.m_viewing);
    }

    static {
        defaultRenderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        defaultRenderingHints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
    }
}

