/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.layout.fframes;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.andami.PluginServices;
import org.gvsig.app.project.documents.Document;
import org.gvsig.app.project.documents.layout.FLayoutUtilities;
import org.gvsig.app.project.documents.layout.fframes.FFrame;
import org.gvsig.app.project.documents.layout.report.LayoutReportActionImpl;
import org.gvsig.compat.print.PrintAttributes;
import org.gvsig.expressionevaluator.ExpressionEvaluatorLocator;
import org.gvsig.expressionevaluator.ExpressionEvaluatorManager;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;

public class FFrameText
extends FFrame {
    public static final String PERSISTENCE_DEFINITION_NAME = "FFrameText";
    private static final String TEXT_FIELD = "text";
    private static final String S_FIELD = "s";
    private static final String ISFIXED_FIELD = "isFixed";
    private static final String FONT_FIELD = "font";
    private static final String POS_FIELD = "pos";
    private static final String TEXTCOLOR_FIELD = "textColor";
    private static final String TRANSITIONPIXELSMILIMETERS_FIELD = "transicionPixelsMilimetros";
    private static final String CELLPADDING_FIELD = "cellPadding";
    private static final String FONTSIZE_FIELD = "fontSize";
    private static final String FIXEDFONTSIZE_FIELD = "fixedFontSize";
    private static final String SURROUNDED_FIELD = "surrounded";
    private static final String HASTITLE_FIELD = "hasTitle";
    private static final String TITLE_FIELD = "title";
    private static final String TITLESIZE_FIELD = "titleSize";
    private static final String FRAMEBORDERSIZE_FIELD = "frameBorderSize";
    private static final String FRAMECOLOR_FIELD = "frameColor";
    private static final String TITLECOLOR_FIELD = "titleColor";
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGTH = 2;
    private List<String> m_text = new ArrayList<String>();
    private boolean m_isFixed = false;
    private int m_pos = 0;
    private Color textColor = Color.BLACK;
    private boolean surrounded = false;
    private double cellPadding = 0.0;
    private boolean fixedFontSize = false;
    private int fontSize;
    private boolean hasTitle;
    private String title;
    private int titleSize;
    private double frameBorderSize = 0.0;
    private Color frameColor = Color.BLACK;
    private Color titleColor = Color.BLACK;
    private Font m_f = new Font("SansSerif", 0, 9);
    private boolean transicionPixelsMilimetros = true;

    public void setFont(Font f) {
        this.m_f = f;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public boolean isFontSizeFixed() {
        return this.fixedFontSize;
    }

    public void setFixedFontSize(boolean fixedFontSize) {
        this.fixedFontSize = fixedFontSize;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
    }

    public double getCellPadding() {
        return this.cellPadding;
    }

    public void setTextColor(Color color) {
        this.textColor = color;
    }

    public Font getFont() {
        return new Font(this.m_f.getFontName(), this.m_f.getStyle(), 9);
    }

    public int getPos() {
        return this.m_pos;
    }

    public void setPos(int p) {
        this.m_pos = p;
    }

    @Override
    public void draw(Graphics2D g, AffineTransform at, Rectangle2D rv, BufferedImage imgBase) {
        g.setColor(Color.BLACK);
        Rectangle2D.Double rec = this.getBoundingBox(at);
        Rectangle2D.Double raux = (Rectangle2D.Double)rec.clone();
        g.rotate(Math.toRadians(this.getRotation()), raux.x + raux.width / 2.0, raux.y + raux.height / 2.0);
        int longmax = 1;
        if (this.intersects(rv, raux)) {
            List<String> texts = this.getExpandedTexts();
            if (CollectionUtils.isEmpty(texts)) {
                this.drawEmpty(g);
            } else {
                int scaledFontSize;
                for (String text : texts) {
                    if (text == null) {
                        text = "<NULL>";
                    }
                    if (text.length() <= longmax) continue;
                    longmax = text.length();
                }
                FontRenderContext frc = g.getFontRenderContext();
                double myScale = at.getScaleX() * 0.0234;
                if (this.isFontSizeFixed()) {
                    scaledFontSize = (int)(myScale * (double)this.fontSize);
                } else {
                    scaledFontSize = (int)raux.width / longmax;
                    if (scaledFontSize > (int)(raux.height / (double)texts.size())) {
                        scaledFontSize = (int)(raux.height / (double)texts.size());
                    }
                }
                this.m_f = this.m_f != null ? new Font(this.m_f.getFontName(), this.m_f.getStyle(), scaledFontSize) : new Font("SansSerif", 0, scaledFontSize);
                if (this.hasTitle()) {
                    int scaledTitleFontSize = (int)(myScale * (double)this.titleSize);
                    int gap = 3;
                    if (this.isSurrounded()) {
                        gap += (int)(FLayoutUtilities.fromSheetDistance(this.frameBorderSize, at) * myScale);
                    }
                    g.setColor(this.titleColor);
                    Font titleFont = new Font(this.m_f.getFontName(), this.m_f.getStyle(), scaledTitleFontSize);
                    if (!this.getTitle().equals("")) {
                        TextLayout titleTextLayout = new TextLayout(this.getTitle(), titleFont, frc);
                        titleTextLayout.draw(g, (float)raux.getX(), (float)(raux.getY() - (double)gap * myScale));
                    }
                }
                if (this.isSurrounded()) {
                    g.setColor(this.frameColor);
                    double scaledCellPadding = FLayoutUtilities.fromSheetDistance(this.cellPadding, at);
                    double sizeBorder = FLayoutUtilities.fromSheetDistance(this.frameBorderSize, at);
                    int bordermm = (int)(sizeBorder * 10.0);
                    int scaledCellPaddingmm = (int)(scaledCellPadding * 10.0);
                    g.setStroke(new BasicStroke(bordermm));
                    g.drawRect((int)(raux.x + (double)(bordermm / 2) - 1.0), (int)(raux.y + (double)(bordermm / 2) - 1.0), (int)(raux.width - (double)bordermm + 2.0), (int)(raux.height - (double)bordermm + 2.0));
                    g.setStroke(new BasicStroke(0.0f));
                    raux.setRect(raux.getX() + (double)scaledCellPaddingmm + (double)bordermm, raux.getY() + (double)scaledCellPaddingmm + (double)bordermm, raux.getWidth() - (double)(scaledCellPaddingmm * 2) - (double)(bordermm * 2), raux.getHeight() - (double)(scaledCellPaddingmm * 2) - (double)(bordermm * 2));
                    if (raux.getWidth() <= 0.0 || raux.getHeight() <= 0.0) {
                        g.setColor(Color.red);
                        this.drawError(this.getBoundingBox(at), 15, g, PluginServices.getText((Object)this, (String)"too_large_border") + ": " + this.frameBorderSize + "cm + " + this.cellPadding + "cm");
                        return;
                    }
                }
                g.setColor(this.textColor);
                this.drawText(raux, scaledFontSize, g);
                g.rotate(Math.toRadians(-this.getRotation()), raux.x + raux.width / 2.0, raux.y + raux.height / 2.0);
            }
        }
        raux = null;
    }

    private void drawError(Rectangle2D r, int sfs, Graphics2D g, String error) {
        FontRenderContext frc = g.getFontRenderContext();
        TextLayout textLayout = null;
        this.m_f = new Font(this.m_f.getFontName(), this.m_f.getStyle(), sfs);
        textLayout = new TextLayout(error, this.m_f, frc);
        textLayout.draw(g, (float)r.getCenterX(), (float)r.getCenterY());
    }

    private void drawText(Rectangle2D r, int sfs, Graphics2D g) {
        Rectangle2D txtBound;
        int minSFS = Integer.MAX_VALUE;
        FontRenderContext frc = g.getFontRenderContext();
        List<String> texts = this.getExpandedTexts();
        int ht = (int)(r.getHeight() / (double)texts.size());
        if (this.isFontSizeFixed()) {
            minSFS = sfs;
        } else {
            for (int i = 0; i < texts.size(); ++i) {
                double difH;
                if (StringUtils.isBlank((CharSequence)texts.get(i)) || texts.get(i).equals("\n")) continue;
                TextLayout textaux = new TextLayout(texts.get(i), this.m_f, frc);
                txtBound = textaux.getBounds();
                double difW = txtBound.getWidth() / r.getWidth();
                if (difW > (difH = txtBound.getHeight() * (double)texts.size() / r.getHeight())) {
                    if (minSFS <= sfs) continue;
                    minSFS = (int)((double)sfs / difW);
                    continue;
                }
                if (minSFS <= sfs) continue;
                minSFS = (int)((double)sfs / difH);
            }
        }
        TextLayout textLayout = null;
        block6: for (int i = 0; i < texts.size(); ++i) {
            if (StringUtils.isBlank((CharSequence)texts.get(i))) continue;
            this.m_f = new Font(this.m_f.getFontName(), this.m_f.getStyle(), minSFS);
            textLayout = new TextLayout(texts.get(i), this.m_f, frc);
            txtBound = textLayout.getBounds();
            float difW = (float)(r.getWidth() - txtBound.getWidth());
            switch (this.m_pos) {
                case 0: {
                    textLayout.draw(g, (float)r.getX(), (float)(r.getY() + (double)ht * ((double)i + 0.8)));
                    continue block6;
                }
                case 1: {
                    textLayout.draw(g, (float)r.getX() + difW / 2.0f, (float)(r.getY() + (double)ht * ((double)i + 0.8)));
                    continue block6;
                }
                case 2: {
                    textLayout.draw(g, (float)r.getX() + difW, (float)(r.getY() + (double)ht * ((double)i + 0.8)));
                }
            }
        }
    }

    public void print(Graphics2D g, AffineTransform at, Geometry geom, PrintAttributes properties) {
        this.draw(g, at, null, null);
    }

    public void addText(String s) {
        this.m_text.add(s);
    }

    public List<String> getText() {
        return this.m_text;
    }

    public void setSizeFixed(boolean b) {
        this.m_isFixed = b;
    }

    public boolean isSizeFixed() {
        return this.m_isFixed;
    }

    @Override
    public String getNameFFrame() {
        return PluginServices.getText((Object)this, (String)"texto") + this.num;
    }

    @Override
    public String getName() {
        return PERSISTENCE_DEFINITION_NAME;
    }

    public void setSurrounded(boolean b) {
        this.surrounded = b;
    }

    public boolean isSurrounded() {
        return this.surrounded;
    }

    public void setCellPadding(double i) {
        this.cellPadding = i;
    }

    public boolean hasTitle() {
        return this.hasTitle;
    }

    public String getTitle() {
        return this.title;
    }

    public void setHasTitle(boolean b) {
        this.hasTitle = b;
    }

    public void setTitle(String text) {
        this.title = text;
    }

    public int getTitleSize() {
        return this.titleSize;
    }

    public void setTitleSize(int size) {
        this.titleSize = size;
    }

    public void setFrameBorderSize(double size) {
        this.frameBorderSize = size;
    }

    public double getFrameBorderSize() {
        return this.frameBorderSize;
    }

    public void setFrameColor(Color frameColor) {
        this.frameColor = frameColor;
    }

    public void setTitleColor(Color titleColor) {
        this.titleColor = titleColor;
    }

    public Color getFrameColor() {
        return this.frameColor;
    }

    public Color getTitleColor() {
        return this.titleColor;
    }

    public void clearText() {
        this.m_text.clear();
    }

    public void initialize() {
    }

    public static void registerPersistent() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        if (manager.getDefinition(PERSISTENCE_DEFINITION_NAME) == null) {
            DynStruct definition = manager.addDefinition(FFrameText.class, PERSISTENCE_DEFINITION_NAME, "FFrameText persistence definition", null, null);
            definition.extend(manager.getDefinition("FFrame"));
            definition.addDynFieldObject(S_FIELD).setClassOfValue(Rectangle2D.class).setMandatory(true);
            definition.addDynFieldList(TEXT_FIELD).setClassOfItems(String.class).setMandatory(true);
            definition.addDynFieldBoolean(ISFIXED_FIELD).setMandatory(true);
            definition.addDynFieldObject(FONT_FIELD).setClassOfValue(Font.class).setMandatory(true);
            definition.addDynFieldInt(POS_FIELD).setMandatory(true);
            definition.addDynFieldObject(TEXTCOLOR_FIELD).setClassOfValue(Color.class).setMandatory(false);
            definition.addDynFieldBoolean(TRANSITIONPIXELSMILIMETERS_FIELD).setMandatory(true);
            definition.addDynFieldDouble(CELLPADDING_FIELD).setMandatory(false);
            definition.addDynFieldInt(FONTSIZE_FIELD).setMandatory(false);
            definition.addDynFieldBoolean(FIXEDFONTSIZE_FIELD).setMandatory(false);
            definition.addDynFieldBoolean(SURROUNDED_FIELD).setMandatory(false);
            definition.addDynFieldBoolean(HASTITLE_FIELD).setMandatory(false);
            definition.addDynFieldString(TITLE_FIELD).setMandatory(false);
            definition.addDynFieldInt(TITLESIZE_FIELD).setMandatory(false);
            definition.addDynFieldDouble(FRAMEBORDERSIZE_FIELD).setMandatory(false);
            definition.addDynFieldObject(FRAMECOLOR_FIELD).setClassOfValue(Color.class).setMandatory(false);
            definition.addDynFieldObject(TITLECOLOR_FIELD).setClassOfValue(Color.class).setMandatory(false);
        }
    }

    @Override
    public void loadFromState(PersistentState state) throws PersistenceException {
        super.loadFromState(state);
        Rectangle2D s_2d = (Rectangle2D)state.get(S_FIELD);
        this.s = new Rectangle((int)s_2d.getX(), (int)s_2d.getY(), (int)s_2d.getWidth(), (int)s_2d.getHeight());
        List text_list = state.getList(TEXT_FIELD);
        for (int i = 0; i < text_list.size(); ++i) {
            this.m_text.add((String)text_list.get(i));
        }
        this.m_isFixed = state.getBoolean(ISFIXED_FIELD);
        this.m_f = (Font)state.get(FONT_FIELD);
        this.m_pos = state.getInt(POS_FIELD);
        this.textColor = (Color)state.get(TEXTCOLOR_FIELD);
        this.transicionPixelsMilimetros = state.getBoolean(TRANSITIONPIXELSMILIMETERS_FIELD);
        this.cellPadding = state.getDouble(CELLPADDING_FIELD);
        this.fontSize = state.getInt(FONTSIZE_FIELD);
        this.fixedFontSize = state.getBoolean(FIXEDFONTSIZE_FIELD);
        this.surrounded = state.getBoolean(SURROUNDED_FIELD);
        this.hasTitle = state.getBoolean(HASTITLE_FIELD);
        this.title = state.getString(TITLE_FIELD);
        this.titleSize = state.getInt(TITLESIZE_FIELD);
        this.frameBorderSize = state.getDouble(FRAMEBORDERSIZE_FIELD);
        this.frameColor = (Color)state.get(FRAMECOLOR_FIELD);
        this.titleColor = (Color)state.get(TITLECOLOR_FIELD);
    }

    @Override
    public void saveToState(PersistentState state) throws PersistenceException {
        super.saveToState(state);
        Rectangle2D.Double s_2d = new Rectangle2D.Double(this.s.x, this.s.y, this.s.width, this.s.height);
        state.set(S_FIELD, (Object)s_2d);
        state.set(TEXT_FIELD, this.m_text);
        state.set(ISFIXED_FIELD, this.m_isFixed);
        state.set(FONT_FIELD, (Object)this.m_f);
        state.set(POS_FIELD, this.m_pos);
        state.set(TEXTCOLOR_FIELD, (Object)this.textColor);
        state.set(TRANSITIONPIXELSMILIMETERS_FIELD, this.transicionPixelsMilimetros);
        state.set(CELLPADDING_FIELD, this.cellPadding);
        state.set(FONTSIZE_FIELD, this.fontSize);
        state.set(FIXEDFONTSIZE_FIELD, this.fixedFontSize);
        state.set(SURROUNDED_FIELD, this.surrounded);
        state.set(HASTITLE_FIELD, this.hasTitle);
        state.set(TITLE_FIELD, this.title);
        state.set(TITLESIZE_FIELD, this.titleSize);
        state.set(FRAMEBORDERSIZE_FIELD, this.frameBorderSize);
        state.set(FRAMECOLOR_FIELD, (Object)this.frameColor);
        state.set(TITLECOLOR_FIELD, (Object)this.titleColor);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        FFrameText frame = (FFrameText)super.clone();
        frame.m_text = new ArrayList<String>(this.m_text);
        return frame;
    }

    private List<String> getExpandedTexts() {
        try {
            ExpressionEvaluatorManager expressionManager = ExpressionEvaluatorLocator.getExpressionEvaluatorManager();
            String ss1 = StringUtils.join(this.m_text, (String)"\n");
            if (!expressionManager.isDynamicText(ss1)) {
                return this.m_text;
            }
            Document doc = this.getDocument();
            LayoutReportActionImpl report = (LayoutReportActionImpl)doc.getProperty("$REPORT");
            if (report == null) {
                report = LayoutReportActionImpl.createFakeLayoutReportAction(doc);
            }
            String ss2 = report.evaluateDynamicText(ss1);
            List<String> texts = Arrays.asList(StringUtils.split((String)ss2, (char)'\n'));
            return texts;
        }
        catch (Throwable t) {
            return this.m_text;
        }
    }
}

