/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.layout.gui.dialogs;

import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.apache.commons.io.FilenameUtils;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.SingletonWindow;
import org.gvsig.andami.ui.mdiManager.WindowInfo;
import org.gvsig.app.project.documents.layout.gui.LayoutPanel;
import org.gvsig.app.project.documents.layout.gui.dialogs.EventsFAlign;
import org.gvsig.app.project.documents.layout.gui.dialogs.FAlignDialogView;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.icontheme.IconTheme;
import org.gvsig.tools.util.LabeledValue;
import org.gvsig.tools.util.LabeledValueImpl;

public class FAlignDialog
extends FAlignDialogView
implements SingletonWindow {
    private static final long serialVersionUID = -4811888913915502937L;
    public static final String RELATIVE_TO_THE_PAGE_LABEL = "_the_page";
    public static final String RELATIVE_TO_SELECTION_LABEL = "_the_selection";
    public static final String RELATIVE_TO_GREATER_OBJECT_LABEL = "_the_greater_object";
    public static final String RELATIVE_TO_MINOR_OBJECT_LABEL = "_the_minor_object";
    public static final int RELATIVE_TO_SELECTION = 0;
    public static final int RELATIVE_TO_THE_PAGE = 1;
    public static final int RELATIVE_TO_GREATER_OBJECT = 2;
    public static final int RELATIVE_TO_MINOR_OBJECT = 3;

    public FAlignDialog(LayoutPanel layout) {
        this.initialize();
        this.translate();
    }

    private void initialize() {
        final EventsFAlign listener = new EventsFAlign();
        this.btnLeft.addActionListener(listener);
        this.btnLeft.setActionCommand("LEFT");
        this.btnCenterV.addActionListener(listener);
        this.btnCenterV.setActionCommand("CENTERV");
        this.btnRight.addActionListener(listener);
        this.btnRight.setActionCommand("RIGHT");
        this.btnUp.addActionListener(listener);
        this.btnUp.setActionCommand("UP");
        this.btnCenterH.addActionListener(listener);
        this.btnCenterH.setActionCommand("CENTERH");
        this.btnDown.addActionListener(listener);
        this.btnDown.setActionCommand("DOWN");
        this.btnDistUp.addActionListener(listener);
        this.btnDistUp.setActionCommand("DISTUP");
        this.btnDistCenterV.addActionListener(listener);
        this.btnDistCenterV.setActionCommand("DISTCENTERV");
        this.btnDistDown.addActionListener(listener);
        this.btnDistDown.setActionCommand("DISTDOWN");
        this.btnDistLeft.addActionListener(listener);
        this.btnDistLeft.setActionCommand("DISTLEFT");
        this.btnDistCenterH.addActionListener(listener);
        this.btnDistCenterH.setActionCommand("DISTCENTERH");
        this.btnDistRight.addActionListener(listener);
        this.btnDistRight.setActionCommand("DISTRIGHT");
        this.btnSizeV.addActionListener(listener);
        this.btnSizeV.setActionCommand("SIZECENTERV");
        this.btnSizeH.addActionListener(listener);
        this.btnSizeH.setActionCommand("SIZECENTERH");
        this.btnSizeBoth.addActionListener(listener);
        this.btnSizeBoth.setActionCommand("SIZEOTHER");
        this.btnSpaceRight.addActionListener(listener);
        this.btnSpaceRight.setActionCommand("SPACERIGHT");
        this.btnSpaceDown.addActionListener(listener);
        this.btnSpaceDown.setActionCommand("SPACEDOWN");
        I18nManager i18n = ToolsLocator.getI18nManager();
        this.cboAlignRelativeTo.addItem(new LabeledValueImpl(i18n.getTranslation(RELATIVE_TO_SELECTION_LABEL), (Object)0));
        this.cboAlignRelativeTo.addItem(new LabeledValueImpl(i18n.getTranslation(RELATIVE_TO_THE_PAGE_LABEL), (Object)1));
        this.cboAlignRelativeTo.addItem(new LabeledValueImpl(i18n.getTranslation(RELATIVE_TO_GREATER_OBJECT_LABEL), (Object)2));
        this.cboAlignRelativeTo.addItem(new LabeledValueImpl(i18n.getTranslation(RELATIVE_TO_MINOR_OBJECT_LABEL), (Object)3));
        this.cboAlignRelativeTo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                listener.setAlignRelativeTo((Integer)((LabeledValue)FAlignDialog.this.cboAlignRelativeTo.getSelectedItem()).getValue());
                FAlignDialog.this.updateComponents();
            }
        });
        Dimension dim = ToolsSwingUtils.ensureRowsCols((JComponent)this, (int)13, (int)32, (int)15, (int)38);
        this.setSize(dim);
    }

    private void translate() {
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        toolsSwingManager.translate((AbstractButton)this.btnLeft);
        toolsSwingManager.translate((AbstractButton)this.btnCenterV);
        toolsSwingManager.translate((AbstractButton)this.btnRight);
        toolsSwingManager.translate((AbstractButton)this.btnUp);
        toolsSwingManager.translate((AbstractButton)this.btnCenterH);
        toolsSwingManager.translate((AbstractButton)this.btnDown);
        toolsSwingManager.translate((AbstractButton)this.btnDistUp);
        toolsSwingManager.translate((AbstractButton)this.btnDistCenterV);
        toolsSwingManager.translate((AbstractButton)this.btnDistDown);
        toolsSwingManager.translate((AbstractButton)this.btnDistLeft);
        toolsSwingManager.translate((AbstractButton)this.btnDistCenterH);
        toolsSwingManager.translate((AbstractButton)this.btnDistRight);
        toolsSwingManager.translate((AbstractButton)this.btnSizeV);
        toolsSwingManager.translate((AbstractButton)this.btnSizeH);
        toolsSwingManager.translate((AbstractButton)this.btnSizeBoth);
        toolsSwingManager.translate((AbstractButton)this.btnSpaceRight);
        toolsSwingManager.translate((AbstractButton)this.btnSpaceDown);
        toolsSwingManager.translate((JComponent)this.cboAlignRelativeTo);
        toolsSwingManager.translate(this.lblAlignRelativeTo);
        toolsSwingManager.translate(this.lblAlign);
        toolsSwingManager.translate(this.lblDistribute);
        toolsSwingManager.translate(this.lblMatchSize);
        toolsSwingManager.translate(this.lblGap);
    }

    private void updateComponents() {
        int relativeTo = (Integer)((LabeledValue)this.cboAlignRelativeTo.getSelectedItem()).getValue();
        switch (relativeTo) {
            case 2: 
            case 3: {
                this.btnDistLeft.setEnabled(false);
                this.btnDistRight.setEnabled(false);
                this.btnDistCenterV.setEnabled(false);
                this.btnDistUp.setEnabled(false);
                this.btnDistDown.setEnabled(false);
                this.btnDistCenterH.setEnabled(false);
                this.btnSpaceDown.setEnabled(false);
                this.btnSpaceRight.setEnabled(false);
                break;
            }
            default: {
                this.btnDistLeft.setEnabled(true);
                this.btnDistRight.setEnabled(true);
                this.btnDistCenterV.setEnabled(true);
                this.btnDistUp.setEnabled(true);
                this.btnDistDown.setEnabled(true);
                this.btnDistCenterH.setEnabled(true);
                this.btnSpaceDown.setEnabled(true);
                this.btnSpaceRight.setEnabled(true);
            }
        }
    }

    public Object getWindowModel() {
        return "AlignDialog";
    }

    public WindowInfo getWindowInfo() {
        WindowInfo m_viewinfo = new WindowInfo(49);
        m_viewinfo.setTitle(PluginServices.getText((Object)this, (String)"alinear"));
        return m_viewinfo;
    }

    public void viewActivated() {
    }

    public Object getWindowProfile() {
        return WindowInfo.PROPERTIES_PROFILE;
    }

    @Override
    public ImageIcon loadImage(String imageName) {
        String name = FilenameUtils.getBaseName((String)imageName);
        IconTheme theme = ToolsSwingLocator.getIconThemeManager().getDefault();
        if (theme.exists(name)) {
            return theme.get(name);
        }
        URL url = FAlignDialog.class.getResource("images/layout/" + name + ".png");
        if (url == null) {
            return null;
        }
        return new ImageIcon(url);
    }
}

