/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.layout.gui.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.andami.ui.mdiManager.WindowInfo;
import org.gvsig.app.project.ProjectManager;
import org.gvsig.app.project.documents.layout.DefaultLayoutNotification;
import org.gvsig.app.project.documents.layout.FLayoutGraphics;
import org.gvsig.app.project.documents.layout.LayoutManager;
import org.gvsig.app.project.documents.layout.fframes.FFrameGraphics;
import org.gvsig.app.project.documents.layout.fframes.IFFrame;
import org.gvsig.app.project.documents.layout.fframes.gui.dialogs.FFrameGraphicsDialog;
import org.gvsig.app.project.documents.layout.geometryadapters.GeometryAdapter;
import org.gvsig.app.project.documents.layout.geometryadapters.RectangleAdapter;
import org.gvsig.app.project.documents.layout.gui.LayoutPanel;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.tools.observer.Observable;
import org.gvsig.tools.observer.ObservableHelper;
import org.gvsig.tools.observer.Observer;

public class FBorderDialog
extends JPanel
implements IWindow,
Observable {
    private static final long serialVersionUID = 8890787517445911425L;
    private JRadioButton rbSeleccionados = null;
    private JRadioButton rbTodos = null;
    private JRadioButton rbMargen = null;
    private JCheckBox chbAgrupar = null;
    private JPanel pPosicion = null;
    private JCheckBox chbIgualLados = null;
    private JLabel lunidades = null;
    private JTextField tTodosLados = null;
    private JLabel lSuperior = null;
    private JLabel lInferior = null;
    private JTextField tSuperior = null;
    private JTextField tInferior = null;
    private JLabel lIzquierda = null;
    private JLabel lDerecha = null;
    private JTextField tIzquierda = null;
    private JTextField tDerecha = null;
    private JLabel lUnidades = null;
    private JButton bAceptar = null;
    private JButton bCancelar = null;
    private LayoutPanel layout = null;
    private IFFrame[] selecList;
    private FFrameGraphics fframegraphics = null;
    private FLayoutGraphics flg = null;
    private String m_NameUnit = null;
    private JButton bConfigurar = null;
    private GeometryAdapter geometry = new RectangleAdapter();
    private boolean isAccepted = false;
    private ISymbol symbol;
    private LayoutManager layoutManager = null;
    private ObservableHelper observers;

    public FBorderDialog(LayoutPanel layoutPanel) {
        this.layout = layoutPanel;
        this.layoutManager = (LayoutManager)ProjectManager.getInstance().getDocumentManager("project.document.layout");
        this.observers = new ObservableHelper();
        this.observers.addObserver((Observer)layoutPanel.getLayoutControl());
        this.flg = new FLayoutGraphics(this.layout);
        LayoutManager layoutManager = (LayoutManager)ProjectManager.getInstance().getDocumentManager("project.document.layout");
        this.fframegraphics = (FFrameGraphics)layoutManager.createFrame("FFrameGraphics");
        this.fframegraphics.setColor(Color.black);
        this.fframegraphics.update(3, this.layout.getLayoutControl().getAT());
        this.initialize();
        this.startFFrameGraphic();
    }

    private void startFFrameGraphic() {
        IFFrame[] fframes = this.layout.getLayoutContext().getFFrames();
        double x = Double.parseDouble(this.getTIzquierda().getText().toString());
        double y = Double.parseDouble(this.getTSuperior().getText().toString());
        double w = Double.parseDouble(this.getTDerecha().getText().toString());
        double h = Double.parseDouble(this.getTInferior().getText().toString());
        Rectangle2D re = new Rectangle2D.Double();
        if (this.getRbSeleccionados().isSelected()) {
            if (this.selecList.length > 0) {
                re = this.getRectangle(this.selecList[0]);
            }
            for (int i = 1; i < this.selecList.length; ++i) {
                Rectangle2D rectaux = this.getRectangle(this.selecList[i]);
                re.add(rectaux);
            }
        } else if (this.getRbTodos().isSelected()) {
            if (fframes.length > 0) {
                re = this.getRectangle(fframes[0]);
            }
            for (int i = 1; i < fframes.length; ++i) {
                Rectangle2D rectaux = this.getRectangle(fframes[i]);
                re.add(rectaux);
            }
        } else if (this.getRbMargen().isSelected()) {
            re.setRect(this.layout.getLayoutContext().getAttributes().getArea());
        }
        re.setRect(re.getX() - x, re.getY() - y, re.getWidth() + x + w, re.getHeight() + y + h);
        this.geometry = new RectangleAdapter();
        this.geometry.addPoint(new Point2D.Double(re.getX(), re.getY()));
        this.geometry.addPoint(new Point2D.Double(re.getMaxX(), re.getMaxY()));
        this.geometry.end();
        this.fframegraphics.setGeometryAdapter(this.geometry);
    }

    private void initialize() {
        this.selecList = this.layout.getLayoutContext().getSelectedFFrames();
        this.setLayout(null);
        this.m_NameUnit = this.layout.getLayoutContext().getAttributes().getNameUnit();
        this.add((Component)this.getRbSeleccionados(), null);
        this.add((Component)this.getRbTodos(), null);
        this.add((Component)this.getRbMargen(), null);
        this.add((Component)this.getChbAgrupar(), null);
        this.add((Component)this.getPPosicion(), null);
        this.add((Component)this.getBAceptar(), null);
        this.add((Component)this.getBCancelar(), null);
        this.add((Component)this.getBConfigurar(), null);
        this.setSize(371, 223);
        ButtonGroup group = new ButtonGroup();
        group.add(this.getRbSeleccionados());
        group.add(this.getRbTodos());
        group.add(this.getRbMargen());
    }

    private JRadioButton getRbSeleccionados() {
        if (this.rbSeleccionados == null) {
            this.rbSeleccionados = new JRadioButton();
            this.rbSeleccionados.setBounds(10, 8, 416, 20);
            this.rbSeleccionados.setText(PluginServices.getText((Object)this, (String)"colocar_alrededor_seleccionados"));
            if (this.selecList.length == 0) {
                this.rbSeleccionados.setEnabled(false);
                this.getRbTodos().setSelected(true);
            } else {
                this.rbSeleccionados.setSelected(true);
            }
        }
        return this.rbSeleccionados;
    }

    private JRadioButton getRbTodos() {
        if (this.rbTodos == null) {
            this.rbTodos = new JRadioButton();
            this.rbTodos.setBounds(10, 29, 332, 20);
            this.rbTodos.setText(PluginServices.getText((Object)this, (String)"colocar_alrededor_todos"));
        }
        return this.rbTodos;
    }

    private JRadioButton getRbMargen() {
        if (this.rbMargen == null) {
            this.rbMargen = new JRadioButton();
            this.rbMargen.setBounds(10, 51, 286, 20);
            this.rbMargen.setText(PluginServices.getText((Object)this, (String)"colocar_a_margenes"));
        }
        return this.rbMargen;
    }

    private JCheckBox getChbAgrupar() {
        if (this.chbAgrupar == null) {
            this.chbAgrupar = new JCheckBox();
            this.chbAgrupar.setBounds(10, 70, 280, 20);
            this.chbAgrupar.setText(PluginServices.getText((Object)this, (String)"agrupar_linea"));
        }
        return this.chbAgrupar;
    }

    private JPanel getPPosicion() {
        if (this.pPosicion == null) {
            this.pPosicion = new JPanel();
            this.pPosicion.setLayout(null);
            this.pPosicion.add((Component)this.getChbIgualLados(), null);
            this.pPosicion.add((Component)this.getLunidades(), null);
            this.pPosicion.add((Component)this.getTTodosLados(), null);
            this.pPosicion.add((Component)this.getLSuperior(), null);
            this.pPosicion.add((Component)this.getLInferior(), null);
            this.pPosicion.add((Component)this.getTSuperior(), null);
            this.pPosicion.add((Component)this.getTInferior(), null);
            this.pPosicion.add((Component)this.getLIzquierda(), null);
            this.pPosicion.add((Component)this.getLDerecha(), null);
            this.pPosicion.add((Component)this.getTIzquierda(), null);
            this.pPosicion.add((Component)this.getTDerecha(), null);
            this.pPosicion.add((Component)this.getLUnidades(), null);
            this.pPosicion.setBounds(12, 92, 350, 97);
            this.pPosicion.setBorder(BorderFactory.createTitledBorder(null, PluginServices.getText((Object)this, (String)"posicion_linea"), 0, 0, null, null));
        }
        return this.pPosicion;
    }

    private JCheckBox getChbIgualLados() {
        if (this.chbIgualLados == null) {
            this.chbIgualLados = new JCheckBox();
            this.chbIgualLados.setBounds(10, 16, 243, 21);
            this.chbIgualLados.setText(PluginServices.getText((Object)this, (String)"igual_todos_lados"));
            this.chbIgualLados.setSelected(true);
            this.chbIgualLados.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!FBorderDialog.this.chbIgualLados.isSelected()) {
                        FBorderDialog.this.getTTodosLados().setEnabled(false);
                        FBorderDialog.this.getTSuperior().setEnabled(true);
                        FBorderDialog.this.getTInferior().setEnabled(true);
                        FBorderDialog.this.getTIzquierda().setEnabled(true);
                        FBorderDialog.this.getTDerecha().setEnabled(true);
                    } else {
                        FBorderDialog.this.getTTodosLados().setEnabled(true);
                        FBorderDialog.this.getTSuperior().setEnabled(false);
                        FBorderDialog.this.getTInferior().setEnabled(false);
                        FBorderDialog.this.getTIzquierda().setEnabled(false);
                        FBorderDialog.this.getTDerecha().setEnabled(false);
                        FBorderDialog.this.getTSuperior().setText(FBorderDialog.this.tTodosLados.getText());
                        FBorderDialog.this.getTInferior().setText(FBorderDialog.this.tTodosLados.getText());
                        FBorderDialog.this.getTIzquierda().setText(FBorderDialog.this.tTodosLados.getText());
                        FBorderDialog.this.getTDerecha().setText(FBorderDialog.this.tTodosLados.getText());
                    }
                }
            });
        }
        return this.chbIgualLados;
    }

    private JLabel getLunidades() {
        if (this.lunidades == null) {
            this.lunidades = new JLabel();
            this.lunidades.setBounds(264, 64, 78, 18);
            this.lunidades.setText(PluginServices.getText((Object)this, (String)this.m_NameUnit));
        }
        return this.lunidades;
    }

    private JTextField getTTodosLados() {
        if (this.tTodosLados == null) {
            this.tTodosLados = new JTextField();
            this.tTodosLados.setBounds(267, 19, 48, 16);
            this.tTodosLados.setText("0.5");
            this.tTodosLados.addCaretListener(new CaretListener(){

                @Override
                public void caretUpdate(CaretEvent e) {
                    if (FBorderDialog.this.getChbIgualLados().isSelected()) {
                        FBorderDialog.this.getTSuperior().setText(FBorderDialog.this.tTodosLados.getText());
                        FBorderDialog.this.getTInferior().setText(FBorderDialog.this.tTodosLados.getText());
                        FBorderDialog.this.getTIzquierda().setText(FBorderDialog.this.tTodosLados.getText());
                        FBorderDialog.this.getTDerecha().setText(FBorderDialog.this.tTodosLados.getText());
                    }
                }
            });
        }
        return this.tTodosLados;
    }

    private JLabel getLSuperior() {
        if (this.lSuperior == null) {
            this.lSuperior = new JLabel();
            this.lSuperior.setBounds(10, 55, 62, 16);
            this.lSuperior.setText(PluginServices.getText((Object)this, (String)"Superior"));
        }
        return this.lSuperior;
    }

    private JLabel getLInferior() {
        if (this.lInferior == null) {
            this.lInferior = new JLabel();
            this.lInferior.setBounds(10, 72, 62, 16);
            this.lInferior.setText(PluginServices.getText((Object)this, (String)"Inferior"));
        }
        return this.lInferior;
    }

    private JTextField getTSuperior() {
        if (this.tSuperior == null) {
            this.tSuperior = new JTextField();
            this.tSuperior.setBounds(78, 55, 48, 16);
            this.tSuperior.setText("0.5");
            this.tSuperior.setEnabled(false);
        }
        return this.tSuperior;
    }

    private JTextField getTInferior() {
        if (this.tInferior == null) {
            this.tInferior = new JTextField();
            this.tInferior.setBounds(78, 72, 48, 16);
            this.tInferior.setText("0.5");
            this.tInferior.setEnabled(false);
        }
        return this.tInferior;
    }

    private JLabel getLIzquierda() {
        if (this.lIzquierda == null) {
            this.lIzquierda = new JLabel();
            this.lIzquierda.setBounds(140, 55, 62, 16);
            this.lIzquierda.setText(PluginServices.getText((Object)this, (String)"Izquierda"));
        }
        return this.lIzquierda;
    }

    private JLabel getLDerecha() {
        if (this.lDerecha == null) {
            this.lDerecha = new JLabel();
            this.lDerecha.setBounds(140, 72, 62, 16);
            this.lDerecha.setText(PluginServices.getText((Object)this, (String)"Derecha"));
        }
        return this.lDerecha;
    }

    private JTextField getTIzquierda() {
        if (this.tIzquierda == null) {
            this.tIzquierda = new JTextField();
            this.tIzquierda.setBounds(207, 55, 48, 16);
            this.tIzquierda.setText("0.5");
            this.tIzquierda.setEnabled(false);
        }
        return this.tIzquierda;
    }

    private JTextField getTDerecha() {
        if (this.tDerecha == null) {
            this.tDerecha = new JTextField();
            this.tDerecha.setBounds(207, 72, 48, 16);
            this.tDerecha.setText("0.5");
            this.tDerecha.setEnabled(false);
        }
        return this.tDerecha;
    }

    private JLabel getLUnidades() {
        if (this.lUnidades == null) {
            this.lUnidades = new JLabel();
            this.lUnidades.setBounds(207, 36, 134, 18);
            this.lUnidades.setText(PluginServices.getText((Object)this, (String)"map_units"));
        }
        return this.lUnidades;
    }

    public WindowInfo getWindowInfo() {
        WindowInfo m_viewinfo = new WindowInfo(8);
        m_viewinfo.setTitle(PluginServices.getText((Object)this, (String)"ajustes_linea_grafica"));
        return m_viewinfo;
    }

    private JButton getBAceptar() {
        if (this.bAceptar == null) {
            this.bAceptar = new JButton();
            this.bAceptar.setBounds(134, 193, 100, 20);
            this.bAceptar.setText(PluginServices.getText((Object)this, (String)"Aceptar"));
            this.bAceptar.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    IFFrame[] fframes = FBorderDialog.this.layout.getLayoutContext().getFFrames();
                    double x = Double.parseDouble(FBorderDialog.this.getTIzquierda().getText().toString());
                    double y = Double.parseDouble(FBorderDialog.this.getTSuperior().getText().toString());
                    double w = Double.parseDouble(FBorderDialog.this.getTDerecha().getText().toString());
                    double h = Double.parseDouble(FBorderDialog.this.getTInferior().getText().toString());
                    if (!FBorderDialog.this.getChbAgrupar().isSelected()) {
                        Rectangle2D re = new Rectangle2D.Double();
                        if (FBorderDialog.this.getRbSeleccionados().isSelected()) {
                            if (FBorderDialog.this.selecList.length > 0) {
                                re = FBorderDialog.this.getRectangle(FBorderDialog.this.selecList[0]);
                            }
                            for (int i = 1; i < FBorderDialog.this.selecList.length; ++i) {
                                Rectangle2D rectaux = FBorderDialog.this.getRectangle(FBorderDialog.this.selecList[i]);
                                re.add(rectaux);
                            }
                        } else if (FBorderDialog.this.getRbTodos().isSelected()) {
                            if (fframes.length > 0) {
                                re = FBorderDialog.this.getRectangle(fframes[0]);
                            }
                            for (int i = 1; i < fframes.length; ++i) {
                                Rectangle2D rectaux = FBorderDialog.this.getRectangle(fframes[i]);
                                re.add(rectaux);
                            }
                        } else if (FBorderDialog.this.getRbMargen().isSelected()) {
                            re.setRect(FBorderDialog.this.layout.getLayoutContext().getAttributes().getArea());
                        }
                        re.setRect(re.getX() - x, re.getY() - y, re.getWidth() + x + w, re.getHeight() + y + h);
                        FBorderDialog.this.geometry = new RectangleAdapter();
                        FBorderDialog.this.geometry.addPoint(new Point2D.Double(re.getX(), re.getY()));
                        FBorderDialog.this.geometry.addPoint(new Point2D.Double(re.getMaxX(), re.getMaxY()));
                        FBorderDialog.this.geometry.end();
                        FBorderDialog.this.fframegraphics.setGeometryAdapter(FBorderDialog.this.geometry);
                        FBorderDialog.this.fframegraphics.setBoundBox(re);
                        if (FBorderDialog.this.symbol != null) {
                            FBorderDialog.this.fframegraphics.setSymbol(FBorderDialog.this.symbol);
                        }
                        FBorderDialog.this.layout.getLayoutContext().addFFrame(FBorderDialog.this.fframegraphics, true, true);
                    } else {
                        Rectangle2D re = new Rectangle2D.Double();
                        if (FBorderDialog.this.getRbSeleccionados().isSelected()) {
                            if (FBorderDialog.this.selecList.length > 0) {
                                re = FBorderDialog.this.getRectangle(FBorderDialog.this.selecList[0]);
                            }
                            for (int i = 1; i < FBorderDialog.this.selecList.length; ++i) {
                                Rectangle2D rectaux = FBorderDialog.this.getRectangle(FBorderDialog.this.selecList[i]);
                                re.add(rectaux);
                            }
                        } else if (FBorderDialog.this.getRbTodos().isSelected()) {
                            if (fframes.length > 0) {
                                re = FBorderDialog.this.getRectangle(fframes[0]);
                            }
                            for (int i = 1; i < fframes.length; ++i) {
                                Rectangle2D rectaux = FBorderDialog.this.getRectangle(fframes[i]);
                                fframes[i].setSelected(true);
                                re.add(rectaux);
                            }
                        } else if (FBorderDialog.this.getRbMargen().isSelected()) {
                            re.setRect(FBorderDialog.this.layout.getLayoutContext().getAttributes().getArea());
                        }
                        re.setRect(re.getX() - x, re.getY() - y, re.getWidth() + x + w, re.getHeight() + y + h);
                        FBorderDialog.this.geometry = new RectangleAdapter();
                        FBorderDialog.this.geometry.addPoint(new Point2D.Double(re.getX(), re.getY()));
                        FBorderDialog.this.geometry.addPoint(new Point2D.Double(re.getMaxX(), re.getMaxY()));
                        FBorderDialog.this.geometry.end();
                        FBorderDialog.this.fframegraphics.setGeometryAdapter(FBorderDialog.this.geometry);
                        FBorderDialog.this.fframegraphics.setBoundBox(re);
                        if (FBorderDialog.this.symbol != null) {
                            FBorderDialog.this.fframegraphics.setSymbol(FBorderDialog.this.symbol);
                        }
                        FBorderDialog.this.layout.getLayoutContext().getFrameCommandsRecord().startComplex(PluginServices.getText((Object)this, (String)"group_graphic_line"));
                        FBorderDialog.this.layout.getLayoutContext().addFFrame(FBorderDialog.this.fframegraphics, false, true);
                        FBorderDialog.this.flg.grouping();
                        FBorderDialog.this.layout.getLayoutContext().getFrameCommandsRecord().endComplex();
                    }
                    PluginServices.getMDIManager().closeWindow((IWindow)FBorderDialog.this);
                    FBorderDialog.this.observers.notifyObservers((Observable)FBorderDialog.this, (Object)new DefaultLayoutNotification("layout_invalidated"));
                    FBorderDialog.this.layout.getLayoutControl().repaint();
                    FBorderDialog.this.isAccepted = true;
                }
            });
        }
        return this.bAceptar;
    }

    private JButton getBCancelar() {
        if (this.bCancelar == null) {
            this.bCancelar = new JButton();
            this.bCancelar.setBounds(251, 193, 100, 20);
            this.bCancelar.setText(PluginServices.getText((Object)this, (String)"Cancelar"));
            this.bCancelar.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PluginServices.getMDIManager().closeWindow((IWindow)FBorderDialog.this);
                    FBorderDialog.this.isAccepted = false;
                }
            });
        }
        return this.bCancelar;
    }

    public void viewActivated() {
    }

    private JButton getBConfigurar() {
        if (this.bConfigurar == null) {
            this.bConfigurar = new JButton();
            this.bConfigurar.setBounds(17, 193, 100, 20);
            this.bConfigurar.setText(PluginServices.getText((Object)this, (String)"configurar"));
            this.bConfigurar.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FFrameGraphicsDialog graphicsdialog = (FFrameGraphicsDialog)FBorderDialog.this.layoutManager.createFFrameDialog(FBorderDialog.this.fframegraphics, FBorderDialog.this.layout);
                    PluginServices.getMDIManager().addWindow((IWindow)graphicsdialog);
                    FBorderDialog.this.symbol = (ISymbol)graphicsdialog.getSelectedObject();
                }
            });
        }
        return this.bConfigurar;
    }

    private Rectangle2D getRectangle(IFFrame f) {
        Rectangle2D.Double re = new Rectangle2D.Double();
        re.setRect(f.getBoundBox());
        Point2D.Double p1 = new Point2D.Double();
        Point2D.Double p2 = new Point2D.Double();
        Point2D.Double p3 = new Point2D.Double();
        Point2D.Double p4 = new Point2D.Double();
        double rotation = f.getRotation();
        AffineTransform at = new AffineTransform();
        at.rotate(Math.toRadians(rotation), re.x + re.width / 2.0, re.y + re.height / 2.0);
        at.transform(new Point2D.Double(re.getX(), re.getY()), p1);
        at.transform(new Point2D.Double(re.getMaxX(), re.getY()), p2);
        at.transform(new Point2D.Double(re.getMaxX(), re.getMaxY()), p3);
        at.transform(new Point2D.Double(re.getX(), re.getMaxY()), p4);
        re.x = ((Point2D)p1).getX() < ((Point2D)p4).getX() ? ((Point2D)p1).getX() : ((Point2D)p4).getX();
        re.y = ((Point2D)p1).getY() < ((Point2D)p2).getY() ? ((Point2D)p1).getY() : ((Point2D)p2).getY();
        re.width = ((Point2D)p2).getX() > ((Point2D)p3).getX() ? ((Point2D)p2).getX() - re.x : ((Point2D)p3).getX() - re.x;
        re.height = ((Point2D)p4).getY() > ((Point2D)p3).getY() ? ((Point2D)p4).getY() - re.y : ((Point2D)p3).getY() - re.y;
        return re;
    }

    public boolean isAccepted() {
        return this.isAccepted;
    }

    public Object getWindowProfile() {
        return WindowInfo.DIALOG_PROFILE;
    }

    public void addObserver(Observer o) {
        this.observers.addObserver(o);
    }

    public void deleteObserver(Observer o) {
        this.observers.deleteObserver(o);
    }

    public void deleteObservers() {
        this.observers.deleteObservers();
    }
}

