/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.layout.tools.behavior;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import org.gvsig.app.project.documents.layout.fframes.IFFrame;
import org.gvsig.app.project.documents.layout.fframes.IFFrameEditableVertex;
import org.gvsig.app.project.documents.layout.tools.behavior.LayoutBehavior;
import org.gvsig.app.project.documents.layout.tools.listener.LayoutMoveListener;
import org.gvsig.app.project.documents.layout.tools.listener.LayoutToolListener;
import org.gvsig.fmap.mapcontrol.tools.BehaviorException;
import org.gvsig.fmap.mapcontrol.tools.Events.PointEvent;

public class LayoutEditBehavior
extends LayoutBehavior {
    private LayoutMoveListener listener;
    private boolean dragged = false;

    public LayoutEditBehavior(LayoutMoveListener lpl) {
        this.listener = lpl;
    }

    @Override
    public void paintComponent(Graphics g) {
        this.getLayoutControl().getLayoutDraw().drawRectangle((Graphics2D)g);
        g.drawImage(this.getLayoutControl().getImage(), 0, 0, this.getLayoutControl().getComponent());
        this.getLayoutControl().getLayoutDraw().drawHandlers((Graphics2D)g, Color.black);
        IFFrame[] fframeSelect = this.getLayoutControl().getLayoutContext().getSelectedFFrames();
        for (int i = 0; i < fframeSelect.length; ++i) {
            if (!(fframeSelect[i] instanceof IFFrameEditableVertex) || !this.dragged) continue;
            ((IFFrameEditableVertex)((Object)fframeSelect[i])).paint((Graphics2D)g, this.getLayoutControl().getAT());
        }
        g.drawImage(this.getLayoutControl().getImgRuler(), 0, 0, this.getLayoutControl().getComponent());
    }

    @Override
    public void mousePressed(MouseEvent e) throws BehaviorException {
        super.mousePressed(e);
        PointEvent event = new PointEvent((Point2D)e.getPoint(), e);
        this.listener.press(event);
    }

    @Override
    public void mouseReleased(MouseEvent e) throws BehaviorException {
        super.mouseReleased(e);
        PointEvent event = new PointEvent((Point2D)e.getPoint(), e);
        this.listener.release(event);
        this.dragged = false;
    }

    @Override
    public void mouseDragged(MouseEvent e) throws BehaviorException {
        super.mouseDragged(e);
        PointEvent event = new PointEvent((Point2D)e.getPoint(), e);
        this.listener.drag(event);
        this.dragged = true;
    }

    public void setListener(LayoutToolListener listener) {
        this.listener = (LayoutMoveListener)listener;
    }

    @Override
    public LayoutToolListener getListener() {
        return this.listener;
    }

    @Override
    public boolean isAdjustable() {
        return true;
    }
}

