/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.layout.mapbox.panel.menu;

import java.util.List;
import org.gvsig.andami.PluginServices;
import org.gvsig.app.project.documents.layout.LayoutContext;
import org.gvsig.app.project.documents.layout.contextmenu.gui.AbstractLayoutContextMenuAction;
import org.gvsig.app.project.documents.layout.fframes.IFFrame;
import org.gvsig.layout.mapbox.fframe.FFrameMapBox;
import org.gvsig.layout.mapbox.model.Cell;
import org.gvsig.tools.lang.Cloneable;
import org.gvsig.tools.lang.CloneableUtils;

public class AddColumnMapBoxMenuEntry
extends AbstractLayoutContextMenuAction {
    public String getGroup() {
        return "mapbox";
    }

    public int getGroupOrder() {
        return 5;
    }

    public int getOrder() {
        return 5;
    }

    public String getText() {
        return PluginServices.getText((Object)((Object)this), (String)"_Add_column");
    }

    @Override
    public boolean isEnabled(LayoutContext layoutContext, IFFrame[] selectedFrames) {
        if (selectedFrames.length != 1) {
            return false;
        }
        for (IFFrame selectedFrame : selectedFrames) {
            if (!(selectedFrame instanceof FFrameMapBox)) continue;
            FFrameMapBox frame = (FFrameMapBox)selectedFrame;
            List<Cell> selectedCells = frame.getSelectedCells();
            return selectedCells.size() == 1;
        }
        return false;
    }

    @Override
    public boolean isVisible(LayoutContext layoutContext, IFFrame[] selectedFrames) {
        for (IFFrame selectedFrame : selectedFrames) {
            if (!(selectedFrame instanceof FFrameMapBox)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void execute(LayoutContext layoutContext, IFFrame[] selectedFrames) {
        if (selectedFrames.length != 1) {
            return;
        }
        IFFrame selectedFrame = selectedFrames[0];
        if (selectedFrame instanceof FFrameMapBox) {
            FFrameMapBox frame = (FFrameMapBox)selectedFrame;
            if (frame.getSelectedCells().size() != 1) {
                return;
            }
            FFrameMapBox newFrame = (FFrameMapBox)CloneableUtils.cloneQuietly((Cloneable)frame);
            List<Cell> selectedCells = newFrame.getSelectedCells();
            if (selectedCells.size() == 1) {
                newFrame.getModel().addColumn(selectedCells.get(0));
                newFrame.getSelection().clear();
                layoutContext.fullRefresh();
                layoutContext.getFrameCommandsRecord().update(frame, newFrame);
                layoutContext.updateFFrames();
            }
        }
    }
}

