/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.persistence.text;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.AbstractMultiPersistenceFactory;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;

public class JavaTextFactory
extends AbstractMultiPersistenceFactory {
    private static JavaTextFactory instance = null;
    private static final String DYNCLASS_DECIMAL_FORMAT_NAME = "DecimalFormat";
    private static final String DYNCLASS_DECIMAL_FORMAT_DESCRIPTION = "DecimalFormat";
    private static final String PATTERN_FIELD = "pattern";
    private static final String DECIMAL_SEP_FIELD = "decimalSep";
    private static final String GROUPING_SEP_FIELD = "groupingSep";

    protected void makeDefinitions() {
        DynStruct decimalFromatDef = this.addDefinition(DecimalFormat.class, "DecimalFormat", "DecimalFormat");
        decimalFromatDef.addDynFieldString(PATTERN_FIELD).setMandatory(true);
        decimalFromatDef.addDynFieldString(DECIMAL_SEP_FIELD).setMandatory(true);
        decimalFromatDef.addDynFieldString(GROUPING_SEP_FIELD).setMandatory(true);
    }

    public Object createFromState(PersistentState state) throws PersistenceException {
        if (this.getManagedClass(state).isAssignableFrom(DecimalFormat.class)) {
            String pattern = state.getString(PATTERN_FIELD);
            String decimalSep = state.getString(DECIMAL_SEP_FIELD);
            String groupingSep = state.getString(GROUPING_SEP_FIELD);
            DecimalFormatSymbols sym = DecimalFormatSymbols.getInstance();
            if (decimalSep != null && decimalSep.length() > 0) {
                sym.setDecimalSeparator(decimalSep.charAt(0));
            }
            if (groupingSep != null && groupingSep.length() > 0) {
                sym.setGroupingSeparator(groupingSep.charAt(0));
            }
            return new DecimalFormat(pattern, sym);
        }
        throw new RuntimeException();
    }

    public void saveToState(PersistentState state, Object obj) throws PersistenceException {
        if (obj instanceof DecimalFormat) {
            DecimalFormat format = (DecimalFormat)obj;
            state.set(PATTERN_FIELD, format.toPattern());
            state.set(DECIMAL_SEP_FIELD, String.valueOf(format.getDecimalFormatSymbols().getDecimalSeparator()));
            state.set(GROUPING_SEP_FIELD, String.valueOf(format.getDecimalFormatSymbols().getGroupingSeparator()));
            return;
        }
        throw new RuntimeException();
    }
}

