/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geoprocess.algorithm.difference;

import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import javax.swing.JOptionPane;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.geoprocess.algorithm.base.core.ScalableUnionOperation;
import org.gvsig.geoprocess.algorithm.difference.DifferenceOperation;
import org.gvsig.geoprocess.lib.sextante.AbstractSextanteGeoProcess;
import org.gvsig.geoprocess.lib.sextante.dataObjects.FlyrVectIVectorLayer;
import org.gvsig.tools.task.SimpleTaskStatus;

public class DifferenceAlgorithm
extends AbstractSextanteGeoProcess {
    public static final String RESULT_POL = "RESULT_POL";
    public static final String RESULT_POINT = "RESULT_POINT";
    public static final String RESULT_LINE = "RESULT_LINE";
    public static final String LAYER = "LAYER";
    public static final String DIF = "DIF";
    public static final String SELECTGEOM_INPUT = "SELECTGEOM_INPUT";
    public static final String SELECTGEOM_OVERLAY = "SELECTGEOM_OVERLAY";

    public void defineCharacteristics() {
        this.setName(this.getTranslation("Difference"));
        this.setGroup(this.getTranslation("basic_vect_algorithms"));
        try {
            this.m_Parameters.addInputVectorLayer(LAYER, this.getTranslation("Input_layer"), -1, true);
            this.m_Parameters.addInputVectorLayer(DIF, this.getTranslation("Overlays_layer"), -1, true);
            this.m_Parameters.addBoolean(SELECTGEOM_INPUT, this.getTranslation("Selected_geometries_input_layer_dif"), false);
            this.m_Parameters.addBoolean(SELECTGEOM_OVERLAY, this.getTranslation("Selected_geometries_overlay_layer_dif"), false);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        this.addOutputVectorLayer(RESULT_POL, this.getTranslation("Difference_polygon"), 2);
        this.addOutputVectorLayer(RESULT_LINE, this.getTranslation("Difference_line"), 1);
        this.addOutputVectorLayer(RESULT_POINT, this.getTranslation("Difference_point"), 0);
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        if (this.existsOutPutFile(RESULT_POL, 0) || this.existsOutPutFile(RESULT_LINE, 0) || this.existsOutPutFile(RESULT_POINT, 0)) {
            throw new GeoAlgorithmExecutionException(this.getTranslation("file_exists"));
        }
        Geometry overlayGeometry = null;
        IVectorLayer dif = this.m_Parameters.getParameterValueAsVectorLayer(DIF);
        IVectorLayer layer = this.m_Parameters.getParameterValueAsVectorLayer(LAYER);
        boolean selectedGeomInput = this.m_Parameters.getParameter(SELECTGEOM_INPUT).getParameterValueAsBoolean();
        boolean selectedGeomOutput = this.m_Parameters.getParameter(SELECTGEOM_OVERLAY).getParameterValueAsBoolean();
        try {
            overlayGeometry = ScalableUnionOperation.joinLayerGeometries((IVectorLayer)dif, (boolean)selectedGeomOutput);
        }
        catch (Exception e) {
            Sextante.addErrorToLog((Throwable)e);
            return false;
        }
        FeatureStore storeLayer = null;
        if (!(layer instanceof FlyrVectIVectorLayer)) {
            return false;
        }
        storeLayer = ((FlyrVectIVectorLayer)layer).getFeatureStore();
        DifferenceOperation operation = null;
        try {
            FeatureStore outFeatStore;
            FeatureType featureType = storeLayer.getDefaultFeatureType();
            operation = new DifferenceOperation(overlayGeometry, this);
            operation.setTaskStatus((SimpleTaskStatus)this.getStatus());
            if (this.isPolygon(storeLayer) || this.isUndefined(storeLayer)) {
                outFeatStore = this.buildOutPutStore(featureType, 6, this.getTranslation("Difference_polygon"), RESULT_POL);
                operation.computesGeometryOperation(storeLayer, outFeatStore, this.attrNames, selectedGeomInput, selectedGeomOutput, true);
            } else {
                this.buildOutPutStore(featureType, 6, this.getTranslation("Null_polygon"), RESULT_POL);
            }
            if (this.isLine(storeLayer) || this.isUndefined(storeLayer)) {
                outFeatStore = this.buildOutPutStore(featureType, 5, this.getTranslation("Difference_line"), RESULT_LINE);
                operation.computesGeometryOperation(storeLayer, outFeatStore, this.attrNames, selectedGeomInput, selectedGeomOutput, true);
            } else {
                this.buildOutPutStore(featureType.getCopy(), 5, this.getTranslation("Null_line"), RESULT_LINE);
            }
            if (this.isPoint(storeLayer) || this.isUndefined(storeLayer)) {
                outFeatStore = this.buildOutPutStore(featureType.getCopy(), 0, this.getTranslation("Difference_point"), RESULT_POINT);
                operation.computesGeometryOperation(storeLayer, outFeatStore, this.attrNames, selectedGeomInput, selectedGeomOutput, true);
            } else {
                this.buildOutPutStore(featureType.getCopy(), 0, this.getTranslation("Null_point"), RESULT_POINT);
            }
        }
        catch (DataException e) {
            Sextante.addErrorToLog((Throwable)e);
            return false;
        }
        if (this.getTaskMonitor().isCanceled()) {
            return false;
        }
        if (operation != null && operation.getErrorInfo()) {
            JOptionPane.showMessageDialog(null, this.getTranslation("problems_with_some_geometries"), "Error", 2);
        }
        return true;
    }
}

