/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.annotations.processors.properties;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.QualifiedNameable;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import net.sf.jasperreports.annotations.documentation.PropertiesDocReader;
import net.sf.jasperreports.annotations.properties.Property;
import net.sf.jasperreports.annotations.properties.PropertyScope;
import net.sf.jasperreports.metadata.properties.CompiledPropertiesMetadata;
import net.sf.jasperreports.metadata.properties.CompiledPropertyMetadata;
import net.sf.jasperreports.metadata.properties.StandardPropertiesMetadataSerialization;

@SupportedAnnotationTypes(value={"net.sf.jasperreports.annotations.properties.Property"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
@SupportedOptions(value={"metadataMessagesName", "propertiesDoc", "configReferenceOut"})
public class PropertyProcessor
extends AbstractProcessor {
    public static final String OPTION_MESSAGES_NAME = "metadataMessagesName";
    public static final String OPTION_PROPERTIES_DOC = "propertiesDoc";
    public static final String OPTION_CONFIG_REFERENCE_OUT = "configReferenceOut";

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        CompiledPropertiesMetadata props = new CompiledPropertiesMetadata();
        String messagesName = this.processingEnv.getOptions().get(OPTION_MESSAGES_NAME);
        props.setMessagesName(messagesName);
        for (TypeElement typeElement : annotations) {
            Set<? extends Element> elements = roundEnv.getElementsAnnotatedWith(typeElement);
            for (Element element : elements) {
                CompiledPropertyMetadata property;
                if (element.getKind() != ElementKind.FIELD) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Annotation " + typeElement + " can only be applied to static fields", element);
                    continue;
                }
                VariableElement varElement = (VariableElement)element;
                Set<Modifier> modifiers = varElement.getModifiers();
                if (!(modifiers.contains((Object)Modifier.STATIC) && modifiers.contains((Object)Modifier.PUBLIC) && modifiers.contains((Object)Modifier.FINAL))) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Annotation " + typeElement + " can only be applied to public static final fields", element);
                    continue;
                }
                TypeMirror varType = varElement.asType();
                if (!varType.toString().equals(String.class.getCanonicalName())) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Annotation " + typeElement + " can only be applied to String fields", element);
                    continue;
                }
                AnnotationMirror propertyAnnotation = this.findPropertyAnnotation(varElement);
                if (propertyAnnotation == null || (property = this.toPropertyMetadata(varElement, propertyAnnotation)) == null) continue;
                props.addProperty(property);
            }
        }
        if (!props.getProperties().isEmpty()) {
            this.writePropertiesMetadata(props);
            String propertiesDoc = this.processingEnv.getOptions().get(OPTION_PROPERTIES_DOC);
            if (propertiesDoc != null) {
                PropertiesDocReader propertiesDocReader = new PropertiesDocReader(this.processingEnv, props);
                propertiesDocReader.readPropertiesDoc(propertiesDoc);
                propertiesDocReader.writeDefaultMessages();
                String referenceOut = this.processingEnv.getOptions().get(OPTION_CONFIG_REFERENCE_OUT);
                if (referenceOut != null) {
                    propertiesDocReader.writeConfigReference(referenceOut);
                }
            }
        }
        return true;
    }

    protected AnnotationMirror findPropertyAnnotation(VariableElement element) {
        AnnotationMirror propertyAnnotation = null;
        List<? extends AnnotationMirror> annotationMirrors = element.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            if (!annotationMirror.getAnnotationType().toString().equals(Property.class.getCanonicalName())) continue;
            propertyAnnotation = annotationMirror;
            break;
        }
        return propertyAnnotation;
    }

    protected CompiledPropertyMetadata toPropertyMetadata(VariableElement element, AnnotationMirror propertyAnnotation) {
        int datasetIndex;
        Map<? extends ExecutableElement, ? extends AnnotationValue> annotationValues = this.processingEnv.getElementUtils().getElementValuesWithDefaults(propertyAnnotation);
        CompiledPropertyMetadata property = new CompiledPropertyMetadata();
        String propName = (String)this.annotationValue(annotationValues, "name").getValue();
        if ((propName == null || propName.isEmpty()) && (propName = (String)element.getConstantValue()) == null) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Failed to read constant value for " + element, element);
            return null;
        }
        property.setName(propName);
        boolean deprecated = this.processingEnv.getElementUtils().isDeprecated(element);
        property.setDeprecated(deprecated);
        QualifiedNameable enclosingElement = (QualifiedNameable)element.getEnclosingElement();
        property.setConstantDeclarationClass(enclosingElement.getQualifiedName().toString());
        property.setConstantFieldName(element.getSimpleName().toString());
        property.setCategory((String)this.annotationValue(annotationValues, "category").getValue());
        property.setDefaultValue((String)this.annotationValue(annotationValues, "defaultValue").getValue());
        property.setSinceVersion((String)this.annotationValue(annotationValues, "sinceVersion").getValue());
        property.setValueType(((TypeMirror)this.annotationValue(annotationValues, "valueType").getValue()).toString());
        List scopeValues = (List)this.annotationValue(annotationValues, "scopes").getValue();
        ArrayList<PropertyScope> propertyScopes = new ArrayList<PropertyScope>(scopeValues.size());
        for (AnnotationValue scopeValue : scopeValues) {
            PropertyScope scope = Enum.valueOf(PropertyScope.class, ((VariableElement)scopeValue.getValue()).getSimpleName().toString());
            propertyScopes.add(scope);
        }
        int contextIndex = propertyScopes.indexOf(PropertyScope.CONTEXT);
        if (contextIndex >= 0 && !propertyScopes.contains(PropertyScope.GLOBAL)) {
            propertyScopes.add(contextIndex, PropertyScope.GLOBAL);
        }
        if ((datasetIndex = propertyScopes.indexOf(PropertyScope.DATASET)) >= 0 && !propertyScopes.contains(PropertyScope.REPORT)) {
            propertyScopes.add(datasetIndex, PropertyScope.REPORT);
        }
        property.setScopes(propertyScopes);
        List scopeQualificationValues = (List)this.annotationValue(annotationValues, "scopeQualifications").getValue();
        ArrayList<String> scopeQualifications = new ArrayList<String>(scopeValues.size());
        for (AnnotationValue qualificationValue : scopeQualificationValues) {
            String qualification = (String)qualificationValue.getValue();
            scopeQualifications.add(qualification);
        }
        property.setScopeQualifications(scopeQualifications);
        return property;
    }

    protected AnnotationValue annotationValue(Map<? extends ExecutableElement, ? extends AnnotationValue> annotationValues, String name) {
        AnnotationValue value = null;
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> valueEntry : annotationValues.entrySet()) {
            ExecutableElement element = valueEntry.getKey();
            if (!element.getSimpleName().contentEquals(name)) continue;
            value = valueEntry.getValue();
            break;
        }
        return value;
    }

    protected void writePropertiesMetadata(CompiledPropertiesMetadata props) {
        StandardPropertiesMetadataSerialization propertiesSerialization = StandardPropertiesMetadataSerialization.instance();
        OutputStream out = null;
        try {
            FileObject propertiesMetadataResource = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", "properties-metadata.json", null);
            out = propertiesMetadataResource.openOutputStream();
            propertiesSerialization.writeProperties(props, out);
            out.close();
            out = null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    System.err.println("Error closing output stream");
                    e.printStackTrace();
                }
            }
        }
    }
}

