/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontext.raster.swing.impl.bands;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.ProviderNotRegisteredException;
import org.gvsig.fmap.dal.exception.ValidateDataParametersException;
import org.gvsig.fmap.dal.raster.BandDescriptor;
import org.gvsig.fmap.dal.raster.RasterStore;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemFileFilter;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemServerExplorer;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemServerExplorerParameters;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.raster.api.RasterLayer;
import org.gvsig.fmap.mapcontext.raster.swing.bands.BandsPanel;
import org.gvsig.fmap.mapcontext.raster.swing.impl.bands.BandsPanelView;
import org.gvsig.fmap.mapcontext.raster.swing.impl.bands.BandsTableModel;
import org.gvsig.fmap.mapcontext.raster.swing.impl.bands.ColorInterpretationCellEditor;
import org.gvsig.fmap.mapcontext.raster.swing.impl.bands.ColorInterpretationCellRenderer;
import org.gvsig.fmap.mapcontext.raster.swing.impl.bands.DataTypeCellRenderer;
import org.gvsig.fmap.mapcontext.raster.swing.impl.bands.NoDataCellRenderer;
import org.gvsig.fmap.mapcontext.raster.swing.impl.bands.RasterStoreBand;
import org.gvsig.fmap.mapcontext.rendering.legend.ILegend;
import org.gvsig.raster.lib.buffer.api.BufferLocator;
import org.gvsig.raster.lib.buffer.api.BufferManager;
import org.gvsig.raster.lib.buffer.api.NoData;
import org.gvsig.raster.lib.legend.api.RasterLegend;
import org.gvsig.raster.lib.legend.api.RasterLegendLocator;
import org.gvsig.raster.lib.legend.api.RasterLegendManager;
import org.gvsig.raster.lib.legend.api.colorinterpretation.ColorInterpretation;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BandsPanelController
extends BandsPanelView
implements BandsPanel,
ActionListener,
ListSelectionListener {
    private static final long serialVersionUID = 8255630092178065352L;
    private static final Logger LOG = LoggerFactory.getLogger(BandsPanelController.class);
    private RasterLayer layer;
    private static final String RASTER_FILTER = "All_raster_supported";

    public BandsPanelController() {
        DisposeUtils.bind((Disposable)this);
        this.translate();
        this.initializeComponents();
    }

    private void initializeComponents() {
        this.btnAdd.addActionListener(this);
        this.btnRemove.addActionListener(this);
        this.tblBands.setRowSelectionAllowed(true);
        this.tblBands.setColumnSelectionAllowed(false);
        this.tblBands.setSelectionMode(0);
        this.tblBands.getSelectionModel().addListSelectionListener(this);
        BandsTableModel model = new BandsTableModel();
        this.tblBands.setModel(model);
        this.tblBands.setColumnModel(new DefaultTableColumnModel());
        TableColumnModel columnModel = this.tblBands.getColumnModel();
        columnModel.setColumnSelectionAllowed(false);
        for (int i = 0; i < model.getColumnCount(); ++i) {
            TableColumn tableColumn = new TableColumn(i);
            tableColumn.setIdentifier(model.getColumnName(i));
            tableColumn.setHeaderValue(model.getColumnName(i));
            columnModel.addColumn(tableColumn);
        }
        this.cboColorSpaces.addItem("RGB");
        this.cboColorSpaces.addItem("CMYK");
        this.cboColorSpaces.addItem("HSL");
        this.cboColorSpaces.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                BandsPanelController.this.doChangeColorColumnCellEditor();
            }
        });
        columnModel.getColumn(0).setCellRenderer(new ColorInterpretationCellRenderer());
        columnModel.getColumn(1).setCellRenderer(new NoDataCellRenderer());
        columnModel.getColumn(2).setCellRenderer(new DataTypeCellRenderer());
    }

    private void translate() {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        this.lblBands.setText(i18nManager.getTranslation(this.lblBands.getText()));
        this.lblColorSpace.setText(i18nManager.getTranslation(this.lblColorSpace.getText()));
        this.cboColorSpaces.setToolTipText(i18nManager.getTranslation(this.cboColorSpaces.getToolTipText()));
        this.btnAdd.setText(i18nManager.getTranslation(this.btnAdd.getText()));
        this.btnAdd.setToolTipText(i18nManager.getTranslation(this.btnAdd.getToolTipText()));
        this.btnRemove.setText(i18nManager.getTranslation(this.btnRemove.getText()));
        this.btnRemove.setToolTipText(i18nManager.getTranslation(this.btnRemove.getToolTipText()));
    }

    public void setLocate(Locale locale) {
        Locale l = super.getLocale();
        if (!l.equals(locale)) {
            this.translate();
        }
        super.setLocale(locale);
    }

    public void set(FLayer layer) {
        if (this.layer != null) {
            DisposeUtils.dispose((Disposable)this.layer);
        }
        this.layer = (RasterLayer)layer;
        DisposeUtils.bind((Disposable)layer);
        RasterLegend legend = this.layer.getLegend();
        ColorInterpretation colorInterpretation = null;
        if (legend != null) {
            colorInterpretation = legend.getColorInterpretation();
        }
        RasterStore store = this.layer.getRasterStore();
        this.addBands(store, colorInterpretation);
    }

    private void addBands(RasterStore store, ColorInterpretation colorInterpretation) {
        String colorSpace = "";
        colorSpace = colorInterpretation.hasAnyCMYKBand() ? "CMYK" : (colorInterpretation.hasAnyHSLBand() ? "HSL" : (colorInterpretation.hasAnyHSLBand() ? "YCBCR" : "RGB"));
        this.cboColorSpaces.setSelectedItem(colorSpace);
        this.doChangeColorColumnCellEditor();
        BandsTableModel model = (BandsTableModel)this.tblBands.getModel();
        for (int i = 0; i < store.getBands(); ++i) {
            BandDescriptor bandDescriptor = store.getBandDescriptor(i);
            RasterStoreBand rasterStoreBand = new RasterStoreBand(bandDescriptor.getStore(), bandDescriptor.getBand());
            NoData noData = bandDescriptor.getNoData();
            if (noData != null) {
                rasterStoreBand.setNoDataNumber(noData.getValue());
            }
            rasterStoreBand.setBandName(bandDescriptor.getName());
            rasterStoreBand.setDataType(bandDescriptor.getDataType());
            if (colorInterpretation != null) {
                rasterStoreBand.setBandColorInterpretation(colorInterpretation.get(i));
            } else {
                rasterStoreBand.setBandColorInterpretation("Undefined");
            }
            model.add(rasterStoreBand);
            DisposeUtils.disposeQuietly((Disposable)rasterStoreBand);
            model.fireTableDataChanged();
        }
    }

    public boolean fetch(FLayer layer) {
        RasterLayer rasterLayer = (RasterLayer)layer;
        RasterStore store = rasterLayer.getRasterStore();
        RasterLegendManager rasterLegendManager = RasterLegendLocator.getRasterLegendManager();
        if (this.willBeChangedBands(store)) {
            ColorInterpretation oldColorInterpretation;
            store.clearAdditionalBands();
            BandsTableModel model = (BandsTableModel)this.tblBands.getModel();
            BufferManager bufferManager = BufferLocator.getBufferManager();
            for (int index = 0; index < model.getRowCount(); ++index) {
                RasterStoreBand rasterStoreBand = model.getElementAt(index);
                RasterStore subStore = rasterStoreBand.getStore();
                int band = rasterStoreBand.getBand();
                if (subStore != store) {
                    try {
                        store.addBand(subStore, band);
                    }
                    catch (DataException e) {
                        ThreadSafeDialogsManager dlgManager = ToolsSwingLocator.getThreadSafeDialogsManager();
                        String message = "_cant_add_band_XbandX_from_store_XsourceX_to_store_XtargetX";
                        String title = "_error_adding_bands";
                        dlgManager.messageDialog(message, new String[]{String.valueOf(band), subStore.getName(), store.getName()}, title, 2);
                        LOG.warn(message, (Throwable)e);
                        return false;
                    }
                }
                BandDescriptor bandDescriptor = store.getBandDescriptor(index);
                NoData noData = bandDescriptor.getNoData();
                Number value = null;
                value = rasterStoreBand.getNoDataNumber();
                if (noData == null) {
                    noData = bufferManager.createNoData(value, null);
                } else {
                    noData.setValue(value);
                }
                bandDescriptor.setNoData(noData);
            }
            rasterLayer.recalculateStatistics();
            List<String> colorInterpretations = this.getColorInterpretations();
            boolean createNewLegend = true;
            RasterLegend oldLegend = rasterLayer.getLegend();
            if (oldLegend != null && (oldColorInterpretation = oldLegend.getColorInterpretation()).length() == colorInterpretations.size()) {
                for (int band = 0; band < oldColorInterpretation.length(); ++band) {
                    oldColorInterpretation.setColorInterpValue(band, colorInterpretations.get(band));
                }
                createNewLegend = false;
            }
            if (createNewLegend) {
                ColorInterpretation colorInterpretation = rasterLegendManager.createColorInterpretation(colorInterpretations.toArray(new String[0]));
                RasterLegend legend = rasterLegendManager.createLegend(colorInterpretation);
                rasterLayer.setLegend((ILegend)legend);
            }
            rasterLayer.getMapContext().invalidate();
        }
        return true;
    }

    private List<String> getColorInterpretations() {
        ArrayList<String> colorInterpretations = new ArrayList<String>();
        BandsTableModel model = (BandsTableModel)this.tblBands.getModel();
        for (int index = 0; index < model.getRowCount(); ++index) {
            RasterStoreBand rasterStoreBand = model.getElementAt(index);
            RasterStore subStore = rasterStoreBand.getStore();
            int band = rasterStoreBand.getBand();
            colorInterpretations.add(rasterStoreBand.getBandColorInterpretation());
        }
        return colorInterpretations;
    }

    private boolean willBeChangedBands(RasterStore store) {
        BandsTableModel model = (BandsTableModel)this.tblBands.getModel();
        if (store.getBands() != model.getRowCount()) {
            return true;
        }
        ColorInterpretation colorInterpretation = this.layer.getLegend().getColorInterpretation();
        for (int index = 0; index < model.getRowCount(); ++index) {
            RasterStoreBand rasterStoreBand = model.getElementAt(index);
            RasterStore subStore = rasterStoreBand.getStore();
            int band = rasterStoreBand.getBand();
            BandDescriptor bandDescriptor = store.getBandDescriptor(index);
            if (bandDescriptor.getStore() == subStore && bandDescriptor.getBand() == band && !this.isChangedNoData(bandDescriptor.getNoData(), rasterStoreBand.getNoDataNumber()) && rasterStoreBand.getBandColorInterpretation().equals(colorInterpretation.get(index))) continue;
            return true;
        }
        return false;
    }

    private boolean isChangedNoData(NoData noData, Number number) {
        if (noData != null) {
            return noData.getValue() != number;
        }
        return number != null;
    }

    public JComponent asJComponent() {
        return this;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.btnRemove) {
            BandsTableModel model = (BandsTableModel)this.tblBands.getModel();
            model.removeElementAt(this.tblBands.getSelectedRow());
            model.fireTableDataChanged();
        } else if (e.getSource() == this.btnAdd) {
            DataManager manager = DALLocator.getDataManager();
            JFileChooser fileChooser = this.createJFileChooser();
            int result = fileChooser.showOpenDialog(this);
            if (result == 0) {
                File[] files;
                for (File file : files = fileChooser.getSelectedFiles()) {
                    try {
                        DataServerExplorerParameters fileExplorerParams = manager.createServerExplorerParameters("FilesystemExplorer");
                        FilesystemServerExplorer explorer = (FilesystemServerExplorer)manager.openServerExplorer("FilesystemExplorer", fileExplorerParams);
                        String type = explorer.getProviderName(file);
                        DataStoreParameters params = manager.createStoreParameters(type);
                        if (params.getDynClass().getDynField("file") != null) {
                            params.setDynValue("file", (Object)file);
                        }
                        if (params.getDynClass().getDynField("crs") != null) {
                            params.setDynValue("crs", (Object)this.layer.getProjection());
                        }
                        RasterStore store = (RasterStore)manager.openStore(type, (DynObject)params);
                        DisposeUtils.disposeQuietly((Disposable)explorer);
                        this.addBands(store, null);
                        DisposeUtils.disposeQuietly((Disposable)store);
                    }
                    catch (InitializeException | ProviderNotRegisteredException | ValidateDataParametersException e1) {
                        LOG.warn("Can't add bands from the file '" + file.getName() + "'", e1);
                    }
                }
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource() == this.tblBands.getSelectionModel()) {
            if (this.tblBands.getSelectedRow() >= 0) {
                if (this.layer.getRasterStore() != ((BandsTableModel)this.tblBands.getModel()).getElementAt(this.tblBands.getSelectedRow()).getStore()) {
                    this.btnRemove.setEnabled(true);
                } else {
                    this.btnRemove.setEnabled(false);
                }
            } else {
                this.btnRemove.setEnabled(false);
            }
        }
    }

    private JFileChooser createJFileChooser() {
        FilesystemServerExplorer explorer;
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        JFileChooser fileChooser = new JFileChooser();
        int mode = 4;
        DataManager dm = DALLocator.getDataManager();
        try {
            FilesystemServerExplorerParameters param = (FilesystemServerExplorerParameters)dm.createServerExplorerParameters("FilesystemExplorer");
            explorer = (FilesystemServerExplorer)dm.openServerExplorer("FilesystemExplorer", (DataServerExplorerParameters)param);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        FilesystemFileFilter filter = explorer.getFilter(mode, i18nManager.getTranslation(RASTER_FILTER));
        fileChooser.setMultiSelectionEnabled(true);
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setFileFilter(new MyFileFilter(filter));
        DisposeUtils.dispose((Disposable)explorer);
        return fileChooser;
    }

    public void dispose() {
        if (!ToolsLocator.getDisposableManager().release((Disposable)this)) {
            return;
        }
        DisposeUtils.dispose((Disposable)this.layer);
        this.layer = null;
        BandsTableModel model = (BandsTableModel)this.tblBands.getModel();
        for (int index = 0; index < model.getRowCount(); ++index) {
            RasterStoreBand rasterStoreBand = model.getElementAt(index);
            DisposeUtils.disposeQuietly((Disposable)rasterStoreBand);
        }
    }

    private void doChangeColorColumnCellEditor() {
        TableColumnModel columnModel = this.tblBands.getColumnModel();
        String selectedItem = (String)this.cboColorSpaces.getSelectedItem();
        if (selectedItem.equalsIgnoreCase("RGB")) {
            columnModel.getColumn(0).setCellEditor(new ColorInterpretationCellEditor(BandsTableModel.RGBColorSpace));
        }
        if (selectedItem.equalsIgnoreCase("CMYK")) {
            columnModel.getColumn(0).setCellEditor(new ColorInterpretationCellEditor(BandsTableModel.CMYKColorSpace));
        }
        if (selectedItem.equalsIgnoreCase("HSL")) {
            columnModel.getColumn(0).setCellEditor(new ColorInterpretationCellEditor(BandsTableModel.HSLColorSpace));
        }
        if (selectedItem.equalsIgnoreCase("YCBCR")) {
            columnModel.getColumn(0).setCellEditor(new ColorInterpretationCellEditor(BandsTableModel.YCBCRColorSpace));
        }
        TableModel bandModel = this.tblBands.getModel();
        for (int i = 0; i < this.tblBands.getRowCount(); ++i) {
            bandModel.setValueAt("Undefined", i, 0);
        }
    }

    public class MyFileFilter
    extends FileFilter {
        public FilesystemFileFilter filter = null;

        public MyFileFilter(FilesystemFileFilter params) {
            this.filter = params;
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            return this.filter.accept(f);
        }

        @Override
        public String getDescription() {
            return this.filter.getDescription();
        }

        public String getName() {
            return this.filter.getDataStoreProviderName();
        }
    }
}

