/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontext.raster.swing.impl.operations;

import javax.swing.table.AbstractTableModel;
import org.gvsig.raster.lib.buffer.api.BufferLocator;
import org.gvsig.raster.lib.buffer.api.OperationManager;
import org.gvsig.raster.lib.buffer.api.operations.OperationList;
import org.gvsig.raster.lib.buffer.api.operations.OperationListEntry;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationListTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 5993288441174158255L;
    private static final Logger LOG = LoggerFactory.getLogger(OperationListTableModel.class);
    private static final int COLUMNS = 2;
    private static final int COLUMN_OPERATION = 0;
    private static final int COLUMN_IS_ACTIVE = 1;
    private OperationList operationList = ((OperationManager)BufferLocator.getBufferManager()).createOperationList();

    @Override
    public int getRowCount() {
        return this.operationList.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        OperationListEntry entry = (OperationListEntry)this.operationList.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return entry.getOperation();
            }
            case 1: {
                return entry.isActive();
            }
        }
        return null;
    }

    @Override
    public String getColumnName(int column) {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        switch (column) {
            case 0: {
                return i18nManager.getTranslation("_operation");
            }
            case 1: {
                return i18nManager.getTranslation("_active");
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 1;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (rowIndex < this.operationList.size()) {
            if (columnIndex < 2) {
                switch (columnIndex) {
                    case 1: {
                        if (aValue == null) {
                            ((OperationListEntry)this.operationList.get(rowIndex)).setActive(false);
                            break;
                        }
                        if (!(aValue instanceof Boolean)) {
                            throw new IllegalArgumentException("The object '" + aValue.toString() + "' must be a Boolean.");
                        }
                        ((OperationListEntry)this.operationList.get(rowIndex)).setActive(((Boolean)aValue).booleanValue());
                        this.fireTableDataChanged();
                        break;
                    }
                    default: {
                        super.setValueAt(aValue, rowIndex, columnIndex);
                    }
                }
            }
            this.fireTableDataChanged();
        }
    }

    public void add(OperationListEntry operationListEntry) {
        this.operationList.add((Object)operationListEntry);
        this.fireTableDataChanged();
    }

    public void removeElementAt(int selectedRow) {
        this.operationList.remove(selectedRow);
        this.fireTableDataChanged();
    }

    public OperationListEntry getElementAt(int selectedRow) {
        return (OperationListEntry)this.operationList.get(selectedRow);
    }

    public void up(int selectedRow) {
        if (selectedRow > 0) {
            OperationListEntry operationListEntry = (OperationListEntry)this.operationList.remove(selectedRow);
            this.operationList.add(selectedRow - 1, (Object)operationListEntry);
            this.fireTableDataChanged();
        }
    }

    public void down(int selectedRow) {
        if (selectedRow < this.operationList.size()) {
            OperationListEntry operationListEntry = (OperationListEntry)this.operationList.remove(selectedRow);
            this.operationList.add(selectedRow + 1, (Object)operationListEntry);
            this.fireTableDataChanged();
        }
    }

    @Override
    public Class<?> getColumnClass(int col) {
        if (col == 1) {
            return Boolean.class;
        }
        return super.getColumnClass(col);
    }
}

