/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.remoteclient.wms.wms_1_3_0.request;

import java.util.Vector;
import org.gvsig.remoteclient.epsg.CrsAxisOrder;
import org.gvsig.remoteclient.utils.Utilities;
import org.gvsig.remoteclient.wms.WMSProtocolHandler;
import org.gvsig.remoteclient.wms.WMSStatus;
import org.gvsig.remoteclient.wms.wms_1_1_0.request.WMSGetMapRequest1_1_0;

public class WMSGetMapRequest1_1_3
extends WMSGetMapRequest1_1_0 {
    public WMSGetMapRequest1_1_3(WMSStatus status, WMSProtocolHandler protocolHandler) {
        super(status, protocolHandler);
    }

    @Override
    protected String getPartialQuery(WMSStatus status) {
        double coord4;
        double coord3;
        double coord2;
        double coord1;
        String epsgCode = status.getSrs();
        if (status.isXyAxisOrder() || CrsAxisOrder.isXyAxisOrder(epsgCode)) {
            coord1 = status.getExtent().getMinX();
            coord2 = status.getExtent().getMinY();
            coord3 = status.getExtent().getMaxX();
            coord4 = status.getExtent().getMaxY();
        } else {
            coord1 = status.getExtent().getMinY();
            coord2 = status.getExtent().getMinX();
            coord3 = status.getExtent().getMaxY();
            coord4 = status.getExtent().getMaxX();
        }
        StringBuffer req = new StringBuffer();
        req.append("LAYERS=" + Utilities.Vector2CS((Vector)status.getLayerNames())).append("&CRS=" + status.getSrs()).append("&BBOX=" + coord1 + ",").append(coord2 + ",").append(coord3 + ",").append(coord4).append("&WIDTH=" + status.getWidth()).append("&HEIGHT=" + status.getHeight()).append("&FORMAT=" + status.getFormat()).append("&STYLES=");
        Vector v = status.getStyles();
        if (v != null && v.size() > 0) {
            req.append(Utilities.Vector2CS((Vector)v));
        }
        if ((v = status.getDimensions()) != null && v.size() > 0) {
            req.append("&" + Utilities.Vector2URLParamString((Vector)v));
        }
        if (status.getTransparency()) {
            req.append("&TRANSPARENT=TRUE");
        }
        return req.toString();
    }

    @Override
    protected String getExceptionsFormat() {
        return "XML";
    }
}

