/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.parsing;

import java.util.Enumeration;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.exolab.castor.mapping.FieldHandler;
import org.exolab.castor.mapping.MapItem;
import org.exolab.castor.xml.NamespacesStack;
import org.exolab.castor.xml.NodeType;
import org.exolab.castor.xml.XMLClassDescriptor;
import org.exolab.castor.xml.XMLFieldDescriptor;
import org.xml.sax.SAXException;

public class NamespaceHandling {
    private NamespacesStack namespacesStack = new NamespacesStack();
    private HashMap<String, String> _namespaceToPackage = new HashMap();
    private boolean _createNamespaceScope = true;
    private static final String XML_PREFIX = "xml";

    public void addNamespaceToPackageMapping(String nsURI, String packageName) {
        this._namespaceToPackage.put(StringUtils.defaultString((String)nsURI), StringUtils.defaultString((String)packageName));
    }

    public String getMappedPackage(String namespace) {
        return this._namespaceToPackage.get(StringUtils.defaultString((String)namespace));
    }

    public void processNamespaces(XMLClassDescriptor classDesc, Object object) {
        FieldHandler handler;
        if (classDesc == null) {
            return;
        }
        XMLFieldDescriptor nsDescriptor = classDesc.getFieldDescriptor(null, null, NodeType.Namespace);
        if (nsDescriptor != null && (handler = nsDescriptor.getHandler()) != null) {
            Enumeration<String> enumeration = this.namespacesStack.getLocalNamespacePrefixes();
            while (enumeration.hasMoreElements()) {
                String nsPrefix = StringUtils.defaultString((String)enumeration.nextElement());
                String nsURI = StringUtils.defaultString((String)this.namespacesStack.getNamespaceURI(nsPrefix));
                MapItem<String, String> mapItem = new MapItem<String, String>(nsPrefix, nsURI);
                handler.setValue(object, mapItem);
            }
        }
    }

    public Object resolveNamespace(Object value) throws SAXException {
        String namespace;
        if (value == null || !(value instanceof String)) {
            return value;
        }
        String result = (String)value;
        int idx = result.indexOf(58);
        String prefix = null;
        if (idx > 0) {
            prefix = result.substring(0, idx);
            if (XML_PREFIX.equals(prefix)) {
                return value;
            }
            result = result.substring(idx + 1);
        }
        if (StringUtils.isNotEmpty((String)(namespace = this.getNamespaceURI(prefix)))) {
            result = '{' + namespace + '}' + result;
            return result;
        }
        if (namespace == null && prefix != null) {
            throw new SAXException("The namespace associated with the prefix: '" + prefix + "' is null.");
        }
        return result;
    }

    public void removeCurrentNamespaceInstance() {
        this.namespacesStack.removeNamespaceScope();
    }

    public void addDefaultNamespace(String namespaceURI) {
        this.namespacesStack.addDefaultNamespace(namespaceURI);
    }

    public void addNamespace(String prefix, String namespaceURI) {
        this.namespacesStack.addNamespace(prefix, namespaceURI);
    }

    public String getNamespacePrefix(String namespaceURI) {
        return this.namespacesStack.getNamespacePrefix(namespaceURI);
    }

    public String getNamespaceURI(String prefix) {
        return this.namespacesStack.getNamespaceURI(prefix);
    }

    public String getDefaultNamespaceURI() {
        return this.namespacesStack.getDefaultNamespaceURI();
    }

    public void createNamespace() {
        this.namespacesStack.addNewNamespaceScope();
    }

    public NamespacesStack getNamespaceStack() {
        return this.namespacesStack;
    }

    public boolean isNewNamespaceScopeNecessary() {
        return this._createNamespaceScope;
    }

    public void startNamespaceScope() {
        this.createNamespace();
        this._createNamespaceScope = true;
    }

    public void stopNamespaceScope() {
        this.createNamespace();
        this._createNamespaceScope = false;
    }

    public void setNewNamespaceScopeNecessary(boolean value) {
        this._createNamespaceScope = value;
    }
}

