/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.projection;

import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.List;
import javax.units.NonSI;
import javax.units.Unit;
import org.geotools.metadata.iso.citation.CitationImpl;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.referencing.operation.projection.ProjectionException;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.CylindricalProjection;
import org.opengis.referencing.operation.MathTransform;

public class IdrBonne
extends MapProjection {
    private final double standardParallel;

    protected IdrBonne(ParameterValueGroup parameters) throws ParameterNotFoundException {
        super(parameters);
        List expected = this.getParameterDescriptors().descriptors();
        if (expected.contains(Provider.STANDARD_PARALLEL)) {
            this.standardParallel = Math.abs(IdrBonne.doubleValue((Collection)expected, (ParameterDescriptor)Provider.STANDARD_PARALLEL, (ParameterValueGroup)parameters));
            IdrBonne.ensureLatitudeInRange((ParameterDescriptor)Provider.STANDARD_PARALLEL, (double)this.standardParallel, (boolean)false);
        } else {
            this.standardParallel = Double.NaN;
        }
    }

    public ParameterDescriptorGroup getParameterDescriptors() {
        return Provider.PARAMETERS;
    }

    public ParameterValueGroup getParameterValues() {
        ParameterValueGroup values = super.getParameterValues();
        if (!Double.isNaN(this.standardParallel)) {
            List expected = this.getParameterDescriptors().descriptors();
            IdrBonne.set((Collection)expected, (ParameterDescriptor)Provider.STANDARD_PARALLEL, (ParameterValueGroup)values, (double)this.standardParallel);
        }
        return values;
    }

    protected Point2D inverseTransformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        return null;
    }

    protected Point2D transformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        return null;
    }

    public static class Provider_SouthOrientated
    extends Provider {
        public static final ParameterDescriptor STANDARD_PARALLEL = Provider_SouthOrientated.createDescriptor((Identifier[])new NamedIdentifier[]{new NamedIdentifier(CitationImpl.OGC, "standard_parallel_1"), new NamedIdentifier(CitationImpl.EPSG, "Latitude of 1st standard parallel"), new NamedIdentifier(CitationImpl.EPSG, "Latitude of natural origin"), new NamedIdentifier(CitationImpl.GEOTIFF, "StdParallel1")}, (double)0.0, (double)-90.0, (double)90.0, (Unit)NonSI.DEGREE_ANGLE);
        static final ParameterDescriptorGroup PARAMETERS = Provider_SouthOrientated.createDescriptorGroup((Identifier[])new NamedIdentifier[]{new NamedIdentifier(CitationImpl.OGC, "Bonne_(South_Orientated)"), new NamedIdentifier(CitationImpl.EPSG, "Bonne (South Orientated)"), new NamedIdentifier((Citation)new CitationImpl((CharSequence)"IDR"), "IDR")}, (GeneralParameterDescriptor[])new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, CENTRAL_MERIDIAN, STANDARD_PARALLEL, FALSE_EASTING, FALSE_NORTHING});

        public Provider_SouthOrientated() {
            super(PARAMETERS);
        }

        protected Class getOperationType() {
            return CylindricalProjection.class;
        }

        public MathTransform createMathTransform(ParameterValueGroup parameters) throws ParameterNotFoundException {
            return new IdrBonne(parameters);
        }
    }

    public static class Provider
    extends MapProjection.AbstractProvider {
        public static final ParameterDescriptor STANDARD_PARALLEL = Provider.createDescriptor((Identifier[])new NamedIdentifier[]{new NamedIdentifier(CitationImpl.OGC, "standard_parallel_1"), new NamedIdentifier(CitationImpl.EPSG, "Latitude of 1st standard parallel"), new NamedIdentifier(CitationImpl.EPSG, "Latitude of natural origin"), new NamedIdentifier(CitationImpl.GEOTIFF, "StdParallel1")}, (double)0.0, (double)-90.0, (double)90.0, (Unit)NonSI.DEGREE_ANGLE);
        static final ParameterDescriptorGroup PARAMETERS = Provider.createDescriptorGroup((Identifier[])new NamedIdentifier[]{new NamedIdentifier(CitationImpl.OGC, "Bonne"), new NamedIdentifier(CitationImpl.EPSG, "Bonne"), new NamedIdentifier((Citation)new CitationImpl((CharSequence)"IDR"), "IDR")}, (GeneralParameterDescriptor[])new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, CENTRAL_MERIDIAN, STANDARD_PARALLEL, FALSE_EASTING, FALSE_NORTHING});

        public Provider() {
            super(PARAMETERS);
        }

        protected Provider(ParameterDescriptorGroup params) {
            super(params);
        }

        protected Class getOperationType() {
            return CylindricalProjection.class;
        }

        public MathTransform createMathTransform(ParameterValueGroup parameters) throws ParameterNotFoundException {
            return new IdrBonne(parameters);
        }
    }
}

