/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.projection;

import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.List;
import javax.units.NonSI;
import javax.units.Unit;
import org.geotools.metadata.iso.citation.CitationImpl;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.referencing.operation.projection.ProjectionException;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.ConicProjection;
import org.opengis.referencing.operation.MathTransform;

public class IdrEquidistantConic
extends MapProjection {
    protected final double latitudeOfCenter;
    protected final double longitudeOfCenter;
    private final double standardParallel1;
    private final double standardParallel2;

    protected IdrEquidistantConic(ParameterValueGroup parameters) throws ParameterNotFoundException {
        super(parameters);
        List expected = this.getParameterDescriptors().descriptors();
        if (expected.contains(Provider.STANDARD_PARALLEL_1)) {
            this.standardParallel1 = Math.abs(IdrEquidistantConic.doubleValue((Collection)expected, (ParameterDescriptor)Provider.STANDARD_PARALLEL_1, (ParameterValueGroup)parameters));
            IdrEquidistantConic.ensureLatitudeInRange((ParameterDescriptor)Provider.STANDARD_PARALLEL_1, (double)this.standardParallel1, (boolean)false);
        } else {
            this.standardParallel1 = Double.NaN;
        }
        if (expected.contains(Provider.STANDARD_PARALLEL_2)) {
            this.standardParallel2 = Math.abs(IdrEquidistantConic.doubleValue((Collection)expected, (ParameterDescriptor)Provider.STANDARD_PARALLEL_2, (ParameterValueGroup)parameters));
            IdrEquidistantConic.ensureLatitudeInRange((ParameterDescriptor)Provider.STANDARD_PARALLEL_2, (double)this.standardParallel2, (boolean)false);
        } else {
            this.standardParallel2 = Double.NaN;
        }
        if (expected.contains(Provider.LATITUDE_OF_CENTER)) {
            this.latitudeOfCenter = Math.abs(IdrEquidistantConic.doubleValue((Collection)expected, (ParameterDescriptor)Provider.LATITUDE_OF_CENTER, (ParameterValueGroup)parameters));
            IdrEquidistantConic.ensureLatitudeInRange((ParameterDescriptor)Provider.LATITUDE_OF_CENTER, (double)this.latitudeOfCenter, (boolean)false);
        } else {
            this.latitudeOfCenter = Double.NaN;
        }
        if (expected.contains(Provider.LONGITUDE_OF_CENTER)) {
            this.longitudeOfCenter = Math.abs(IdrEquidistantConic.doubleValue((Collection)expected, (ParameterDescriptor)Provider.LONGITUDE_OF_CENTER, (ParameterValueGroup)parameters));
            IdrEquidistantConic.ensureLongitudeInRange((ParameterDescriptor)Provider.LONGITUDE_OF_CENTER, (double)this.longitudeOfCenter, (boolean)false);
        } else {
            this.longitudeOfCenter = Double.NaN;
        }
    }

    public ParameterDescriptorGroup getParameterDescriptors() {
        return Provider.PARAMETERS;
    }

    public ParameterValueGroup getParameterValues() {
        List expected = this.getParameterDescriptors().descriptors();
        ParameterValueGroup values = super.getParameterValues();
        IdrEquidistantConic.set((Collection)expected, (ParameterDescriptor)Provider.STANDARD_PARALLEL_1, (ParameterValueGroup)values, (double)this.standardParallel1);
        IdrEquidistantConic.set((Collection)expected, (ParameterDescriptor)Provider.STANDARD_PARALLEL_2, (ParameterValueGroup)values, (double)this.standardParallel2);
        IdrEquidistantConic.set((Collection)expected, (ParameterDescriptor)Provider.LATITUDE_OF_CENTER, (ParameterValueGroup)values, (double)this.latitudeOfCenter);
        IdrEquidistantConic.set((Collection)expected, (ParameterDescriptor)Provider.LONGITUDE_OF_CENTER, (ParameterValueGroup)values, (double)this.longitudeOfCenter);
        return values;
    }

    protected Point2D transformNormalized(double lambda, double phi, Point2D ptDst) throws ProjectionException {
        return null;
    }

    protected Point2D inverseTransformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        return null;
    }

    public static class Provider
    extends MapProjection.AbstractProvider {
        public static final ParameterDescriptor LATITUDE_OF_CENTER = Provider.createDescriptor((Identifier[])new NamedIdentifier[]{new NamedIdentifier(CitationImpl.OGC, "latitude_of_center"), new NamedIdentifier(CitationImpl.EPSG, "Latitude of projection center"), new NamedIdentifier(CitationImpl.EPSG, "Latitude of projection centre"), new NamedIdentifier(CitationImpl.EPSG, "Spherical latitude of origin"), new NamedIdentifier(CitationImpl.EPSG, "Latitude of natural origin"), new NamedIdentifier(CitationImpl.GEOTIFF, "CenterLat")}, (double)0.0, (double)-90.0, (double)90.0, (Unit)NonSI.DEGREE_ANGLE);
        public static final ParameterDescriptor LONGITUDE_OF_CENTER = Provider.createDescriptor((Identifier[])new NamedIdentifier[]{new NamedIdentifier(CitationImpl.OGC, "longitude_of_center"), new NamedIdentifier(CitationImpl.EPSG, "Longitude of projection center"), new NamedIdentifier(CitationImpl.EPSG, "Longitude of projection centre"), new NamedIdentifier(CitationImpl.EPSG, "Spherical longitude of origin"), new NamedIdentifier(CitationImpl.EPSG, "Longitude of natural origin"), new NamedIdentifier(CitationImpl.GEOTIFF, "CenterLong")}, (double)0.0, (double)-180.0, (double)180.0, (Unit)NonSI.DEGREE_ANGLE);
        public static final ParameterDescriptor STANDARD_PARALLEL_1 = Provider.createDescriptor((Identifier[])new NamedIdentifier[]{new NamedIdentifier(CitationImpl.OGC, "standard_parallel_1"), new NamedIdentifier(CitationImpl.EPSG, "Latitude of 1st standard parallel"), new NamedIdentifier(CitationImpl.EPSG, "Latitude of natural origin"), new NamedIdentifier(CitationImpl.GEOTIFF, "StdParallel1")}, (double)0.0, (double)-90.0, (double)90.0, (Unit)NonSI.DEGREE_ANGLE);
        public static final ParameterDescriptor STANDARD_PARALLEL_2 = Provider.createDescriptor((Identifier[])new NamedIdentifier[]{new NamedIdentifier(CitationImpl.OGC, "standard_parallel_2"), new NamedIdentifier(CitationImpl.EPSG, "Latitude of 2nd standard parallel"), new NamedIdentifier(CitationImpl.EPSG, "Latitude of natural origin"), new NamedIdentifier(CitationImpl.GEOTIFF, "StdParallel2")}, (double)0.0, (double)-90.0, (double)90.0, (Unit)NonSI.DEGREE_ANGLE);
        static final ParameterDescriptorGroup PARAMETERS = Provider.createDescriptorGroup((Identifier[])new NamedIdentifier[]{new NamedIdentifier(CitationImpl.OGC, "Equidistant_Conic "), new NamedIdentifier(CitationImpl.GEOTIFF, "EquidistantConic"), new NamedIdentifier(CitationImpl.EPSG, "\tEquidistant Conic"), new NamedIdentifier((Citation)new CitationImpl((CharSequence)"IDR"), "IDR")}, (GeneralParameterDescriptor[])new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, STANDARD_PARALLEL_1, STANDARD_PARALLEL_2, LATITUDE_OF_CENTER, LONGITUDE_OF_CENTER, FALSE_EASTING, FALSE_NORTHING});

        public Provider() {
            super(PARAMETERS);
        }

        protected Class getOperationType() {
            return ConicProjection.class;
        }

        public MathTransform createMathTransform(ParameterValueGroup parameters) throws ParameterNotFoundException {
            return new IdrEquidistantConic(parameters);
        }
    }
}

