/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.crs;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.apache.commons.lang3.StringUtils;
import org.cresques.cts.ICoordTrans;
import org.cresques.cts.IDatum;
import org.cresques.cts.IProjection;
import org.cresques.geo.ViewPortData;
import org.gdal.osr.SpatialReference;
import org.gvsig.crs.COperation;
import org.gvsig.crs.CRSDatum;
import org.gvsig.crs.CrsException;
import org.gvsig.crs.CrsWkt;
import org.gvsig.crs.ICrs;
import org.gvsig.crs.Proj4;
import org.gvsig.crs.proj.CrsProj;
import org.gvsig.crs.proj.OperationCrsException;
import org.gvsig.fmap.crs.CRSFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Crs
implements ICrs {
    private static final Logger logger = LoggerFactory.getLogger(Crs.class);
    private static final int UNKNOWN_EPSG_CODE = 0;
    private static final Color basicGridColor = new Color(64, 64, 64, 128);
    private Proj4 proj4;
    private String proj4String;
    private String trans;
    private String abrev;
    private String name = "";
    private CrsProj crsProj;
    private CrsProj crsBase = null;
    private CrsWkt crsWkt;
    private int epsg_code = 0;
    String sourceTrParams = null;
    String targetTrParams = null;
    String wkt = null;
    Color gridColor = basicGridColor;
    CRSDatum datum = null;
    private SpatialReference spatialReference = null;

    public Crs(SpatialReference spatialReference) {
        this.initFromSpatialReference(spatialReference);
    }

    private void initFromSpatialReference(SpatialReference spatialReference) {
        this.spatialReference = spatialReference;
        String authorityCode = this.spatialReference.GetAuthorityCode(null);
        String authorityName = this.spatialReference.GetAuthorityName(null);
        this.spatialReference.Fixup();
        if (authorityCode == null || authorityName == null) {
            try {
                this.spatialReference.AutoIdentifyEPSG();
                authorityCode = this.spatialReference.GetAuthorityCode(null);
                authorityName = this.spatialReference.GetAuthorityName(null);
            }
            catch (Exception e) {
                logger.warn("Can't autoidentify EPSG from SpatialReference (" + this.toString(spatialReference) + ").", (Throwable)e);
            }
        }
        if (!StringUtils.isEmpty((CharSequence)authorityCode) && !StringUtils.isEmpty((CharSequence)authorityName)) {
            this.name = authorityName + ":" + authorityCode;
            this.epsg_code = Integer.parseInt(authorityCode);
        }
        this.abrev = this.name;
        this.datum = new CRSDatum(this.spatialReference.GetSemiMajor(), this.spatialReference.GetInvFlattening());
        if (this.epsg_code == 0) {
            try {
                this.proj4String = this.spatialReference.ExportToProj4();
            }
            catch (Exception e) {
                logger.warn("Can't get proj4 string from SpatialReference (" + this.toString(spatialReference) + ").", (Throwable)e);
            }
        } else {
            try {
                SpatialReference sr2 = new SpatialReference();
                sr2.ImportFromEPSG(this.epsg_code);
                this.proj4String = sr2.ExportToProj4();
            }
            catch (Exception e) {
                logger.warn("Can't get proj4 string from EPSG '" + this.name + "'.", (Throwable)e);
            }
        }
        this.crsWkt = new CrsWkt(this.spatialReference);
        this.setWKT(this.spatialReference.ExportToWkt());
    }

    private String toString(SpatialReference sr) {
        try {
            return sr.ExportToWkt();
        }
        catch (Exception exception) {
            try {
                return sr.toString();
            }
            catch (Exception exception2) {
                try {
                    return "SpatialReference" + sr.hashCode();
                }
                catch (Exception exception3) {
                    return "SpatialReference\u00bf?";
                }
            }
        }
    }

    public Crs(int epsgCode, int aut) throws CrsException {
        String strEpsgCode = "";
        if (aut == 1) {
            strEpsgCode = "EPSG:" + epsgCode;
        } else if (aut == 2) {
            strEpsgCode = "ESRI:" + epsgCode;
        } else if (aut == 3) {
            strEpsgCode = "IAU2000:" + epsgCode;
        } else if (aut == 4) {
            strEpsgCode = "USR:" + epsgCode;
        } else {
            logger.warn("Error, invalid authority");
        }
        this.crsWkt = new CrsWkt(strEpsgCode);
        this.setWKT(this.crsWkt.getWkt());
    }

    public Crs(String code) throws CrsException {
        this.setWKT(code);
        String fullCode = code.charAt(0) == 'E' || code.charAt(0) == 'G' || code.charAt(0) == 'P' ? code : "EPSG:" + code;
        if (code.length() < 15) {
            code = code.substring(code.indexOf(":") + 1);
            try {
                this.crsWkt = new CrsWkt(fullCode);
                this.setName(fullCode);
                this.setAbrev(fullCode);
            }
            catch (NumberFormatException e) {
                logger.error("Can't Wkt.", (Throwable)e);
            }
        } else {
            String code2 = "";
            for (int i = 0; i < code.length(); ++i) {
                String aux = "" + code.charAt(i);
                code2 = !aux.equals(" ") ? code2 + aux : code2 + "";
            }
            this.crsWkt = new CrsWkt(code2);
            this.setName(fullCode);
            this.setAbrev(this.crsWkt.getAuthority()[0] + ":" + this.crsWkt.getAuthority()[1]);
        }
        if (!this.crsWkt.getSpheroid()[1].equals("") && !this.crsWkt.getSpheroid()[2].equals("")) {
            double eSemiMajorAxis = Double.valueOf(this.crsWkt.getSpheroid()[1]);
            double eIFlattening = Double.valueOf(this.crsWkt.getSpheroid()[2]);
            this.datum = new CRSDatum(eSemiMajorAxis, eIFlattening);
        }
    }

    public Crs(int epsg_cod, String code) throws CrsException {
        this.setWKT(code);
        this.setCode(epsg_cod);
        SpatialReference sr = new SpatialReference();
        sr.ImportFromWkt(code);
        this.initFromSpatialReference(sr);
    }

    public Crs(int epsg_cod, String code, String params) throws CrsException {
        this.setCode(epsg_cod);
        this.setWKT(code);
        String fullCode = code.charAt(0) == 'E' || code.charAt(0) == 'G' || code.charAt(0) == 'P' ? code : "EPSG:" + code;
        if (code.length() < 15) {
            code = code.substring(code.indexOf(":") + 1);
            try {
                this.crsWkt = new CrsWkt(fullCode);
                this.setName(fullCode);
                this.setAbrev(fullCode);
            }
            catch (NumberFormatException e) {
                logger.error("Can't get Wkt.", (Throwable)e);
            }
        } else {
            String code2 = "";
            for (int i = 0; i < code.length(); ++i) {
                String aux = "" + code.charAt(i);
                code2 = !aux.equals(" ") ? code2 + aux : code2 + "";
            }
            this.crsWkt = new CrsWkt(code2);
            this.setName(fullCode);
            this.setAbrev(this.crsWkt.getAuthority()[0] + ":" + this.crsWkt.getAuthority()[1]);
        }
        if (!this.crsWkt.getSpheroid()[1].equals("") && !this.crsWkt.getSpheroid()[2].equals("")) {
            double eSemiMajorAxis = Double.valueOf(this.crsWkt.getSpheroid()[1]);
            double eIFlattening = Double.valueOf(this.crsWkt.getSpheroid()[2]);
            this.datum = new CRSDatum(eSemiMajorAxis, eIFlattening);
        }
    }

    public void setTrans(String code) {
        this.trans = code;
        this.changeTrans(this.trans);
    }

    public void changeTrans(String code) {
        this.getCrsProj().changeStrCrs(code);
    }

    public String getAbrev() {
        return this.abrev;
    }

    protected void setAbrev(String code) {
        this.abrev = code;
    }

    public void setName(String nom) {
        this.name = nom;
    }

    public IDatum getDatum() {
        return this.datum;
    }

    public CrsWkt getCrsWkt() {
        return this.crsWkt;
    }

    public void setWKT(String wkt) {
        this.wkt = wkt;
    }

    public String getWKT() {
        return this.wkt;
    }

    public void setTransformationParams(String sourceParams, String targetParams) {
        this.sourceTrParams = sourceParams;
        this.targetTrParams = targetParams;
    }

    public String getSourceTransformationParams() {
        return this.sourceTrParams;
    }

    public String getTargetTransformationParams() {
        return this.targetTrParams;
    }

    public String getTransformationParams() {
        return this.sourceTrParams;
    }

    public CrsProj getCrsProj() {
        if (this.crsProj == null) {
            try {
                this.crsProj = new CrsProj(this.getProj4String());
            }
            catch (CrsException e) {
                logger.error("Can't get proj4 string.", (Throwable)e);
            }
        }
        return this.crsProj;
    }

    public Point2D createPoint(double x, double y) {
        return new Point2D.Double(x, y);
    }

    public void drawGrid(Graphics2D g, ViewPortData vp) {
    }

    public void setGridColor(Color c) {
        this.gridColor = c;
    }

    public Color getGridColor() {
        return this.gridColor;
    }

    public ICoordTrans getCT(IProjection dest) {
        try {
            if (dest == this) {
                return null;
            }
            COperation operation = null;
            operation = ((ICrs)dest).getSourceTransformationParams() != null ? new COperation(this, (ICrs)dest, this.getSourceTransformationParams(), ((ICrs)dest).getSourceTransformationParams()) : new COperation(this, (ICrs)dest, this.getSourceTransformationParams(), this.getTargetTransformationParams());
            return operation;
        }
        catch (CrsException e) {
            logger.error("Can't get CoordTrans.", (Throwable)e);
            return null;
        }
    }

    public Point2D toGeo(Point2D pt) {
        if (this.isProjected()) {
            double[] x = new double[]{pt.getX()};
            double[] y = new double[]{pt.getY()};
            double[] z = new double[]{0.0};
            try {
                CrsProj.operate(x, y, z, this.getCrsProj(), this.crsBase);
            }
            catch (OperationCrsException e) {
                logger.error("Can't convert point to geo.", (Throwable)e);
            }
            return new Point2D.Double(x[0], y[0]);
        }
        return pt;
    }

    public Point2D fromGeo(Point2D gPt, Point2D mPt) {
        return null;
    }

    public boolean isProjected() {
        return !this.getCrsProj().isLatlong();
    }

    public double getScale(double minX, double maxX, double width, double dpi) {
        double scale = 0.0;
        scale = (maxX - minX) * (dpi / 2.54 * 100.0) / width;
        return scale;
    }

    public double getScale(double minX, double maxX, double minY, double maxY, double width, double dpi) {
        double scale = 0.0;
        double incX = maxX - minX;
        if (!this.isProjected()) {
            double a = this.getDatum().getESemiMajorAxis();
            double invF = this.getDatum().getEIFlattening();
            double meanY = (minY + maxY) / 2.0;
            double radius = 0.0;
            if (invF == Double.POSITIVE_INFINITY) {
                radius = a;
            } else {
                double e2 = 2.0 / invF - Math.pow(1.0 / invF, 2.0);
                radius = a / Math.sqrt(1.0 - e2 * Math.pow(Math.sin(meanY * Math.PI / 180.0), 2.0)) * Math.cos(meanY * Math.PI / 180.0);
            }
            incX *= Math.PI / 180 * radius;
        }
        scale = incX * (dpi / 2.54 * 100.0) / width;
        return scale;
    }

    public void setCode(int epsg_cod) {
        this.epsg_code = epsg_cod;
    }

    public int getCode() {
        return this.epsg_code;
    }

    public String getFullCode() {
        if (this.sourceTrParams == null && this.targetTrParams == null) {
            return this.getAbrev();
        }
        String sourceParams = "";
        String targetParams = "";
        if (this.sourceTrParams != null) {
            sourceParams = this.sourceTrParams;
        }
        if (this.targetTrParams != null) {
            targetParams = this.targetTrParams;
        }
        return this.getAbrev() + ":proj@" + sourceParams + "@" + targetParams;
    }

    public Rectangle2D getExtent(Rectangle2D extent, double scale, double wImage, double hImage, double mapUnits, double distanceUnits, double dpi) {
        double w = 0.0;
        double h = 0.0;
        double wExtent = 0.0;
        double hExtent = 0.0;
        w = wImage / dpi * 2.54;
        h = hImage / dpi * 2.54;
        wExtent = w * scale * distanceUnits / mapUnits;
        hExtent = h * scale * distanceUnits / mapUnits;
        double xExtent = extent.getCenterX() - wExtent / 2.0;
        double yExtent = extent.getCenterY() - hExtent / 2.0;
        Rectangle2D.Double rec = new Rectangle2D.Double(xExtent, yExtent, wExtent, hExtent);
        return rec;
    }

    private Proj4 getProj4() {
        if (this.proj4 == null) {
            try {
                this.proj4 = new Proj4();
            }
            catch (CrsException e) {
                logger.error("Can't create Proj4 instance.", (Throwable)e);
            }
        }
        return this.proj4;
    }

    public String getProj4String() throws CrsException {
        if (this.proj4String == null) {
            this.proj4String = this.getProj4().exportToProj4(this);
        }
        return this.proj4String;
    }

    public Object clone() throws CloneNotSupportedException {
        return CRSFactory.getCRS((String)this.getFullCode());
    }

    public String toString() {
        return this.getFullCode();
    }

    public String export(String format) {
        if (this.spatialReference != null) {
            if (format.equalsIgnoreCase("proj4")) {
                return this.spatialReference.ExportToProj4();
            }
            if (format.equalsIgnoreCase("wkt_esri")) {
                SpatialReference srESRI = this.spatialReference.Clone();
                return srESRI.ExportToWkt();
            }
            if (format.equalsIgnoreCase("wkt")) {
                return this.spatialReference.ExportToWkt();
            }
            return null;
        }
        SpatialReference spatialReference = this.getCrsProj().getSpatialReference();
        SpatialReference auxSpatialReference = new SpatialReference();
        if (format.equalsIgnoreCase("proj4")) {
            String proj4 = spatialReference.ExportToProj4();
            auxSpatialReference.ImportFromProj4(proj4);
            if (auxSpatialReference.GetAuthorityName(null) != null) {
                return proj4;
            }
            return null;
        }
        if (format.equalsIgnoreCase("wkt_esri")) {
            return spatialReference.ExportToWkt();
        }
        if (format.equalsIgnoreCase("wkt")) {
            String wkt = spatialReference.ExportToWkt();
            auxSpatialReference.ImportFromWkt(wkt);
            if (auxSpatialReference.GetAuthorityName(null) != null) {
                return wkt;
            }
            return null;
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Crs)) {
            return false;
        }
        return this.getFullCode().equalsIgnoreCase(((Crs)obj).getFullCode());
    }

    public int hashCode() {
        return this.getFullCode().hashCode();
    }
}

