/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.crs;

import java.util.ArrayList;
import javax.units.ConversionException;
import javax.units.Unit;
import org.apache.commons.lang3.StringUtils;
import org.gdal.osr.SpatialReference;
import org.gdal.osr.osr;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.AbstractSingleCRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.crs.DefaultProjectedCRS;
import org.geotools.referencing.datum.DefaultEllipsoid;
import org.geotools.referencing.datum.DefaultGeodeticDatum;
import org.geotools.referencing.datum.DefaultPrimeMeridian;
import org.gvsig.crs.CRSDatum;
import org.gvsig.crs.CrsFactory;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PrimeMeridian;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrsWkt {
    private static final Logger logger = LoggerFactory.getLogger(CrsWkt.class);
    private String wkt;
    private String projcs = "";
    private String geogcs = "";
    private String datum = "";
    private String[] spheroid = new String[]{"", "", ""};
    private String[] primem = new String[]{"", ""};
    private String[] unit = new String[]{"", ""};
    private String[] unit_p = new String[]{"", ""};
    private String projection = "";
    private String[] param_name;
    private String[] param_value;
    private int contador = 0;
    private String[] authority = new String[]{"", ""};
    int divider = 10000;
    private static final String USERNAME = "";
    private static final double EPS = 1.0E-8;

    public CrsWkt(SpatialReference spatialReference) {
        this.fromSpatialReference(spatialReference);
    }

    private void fromSpatialReference(SpatialReference spatialReference) {
        this.wkt = spatialReference.ExportToWkt();
        this.projcs = spatialReference.GetAttrValue("PROJCS", 0);
        if (StringUtils.isEmpty((CharSequence)this.projcs)) {
            this.projcs = USERNAME;
        } else {
            this.unit_p[0] = spatialReference.GetAttrValue("UNIT", 0);
            this.unit_p[1] = spatialReference.GetAttrValue("UNIT", 1);
            this.projection = spatialReference.GetAttrValue("PROJECTION");
            try {
                String[] username = new String[]{USERNAME};
                this.param_name = osr.GetProjectionMethodParameterList((String)this.projection, (String[])username);
                this.param_value = new String[this.param_name.length];
                for (int i = 0; i < this.param_name.length; ++i) {
                    this.param_value[i] = String.valueOf(spatialReference.GetProjParm(this.param_name[i]));
                }
            }
            catch (Exception e) {
                logger.warn("Error obtaining projection params");
            }
        }
        this.geogcs = spatialReference.GetAttrValue("GEOGCS", 0);
        this.datum = spatialReference.GetAttrValue("DATUM", 0);
        CRSDatum crsDatum = new CRSDatum(spatialReference.GetSemiMajor(), spatialReference.GetInvFlattening());
        this.spheroid[0] = spatialReference.GetAttrValue("SPHEROID", 0);
        this.spheroid[1] = String.valueOf(spatialReference.GetSemiMajor());
        this.spheroid[2] = String.valueOf(spatialReference.GetInvFlattening());
        this.primem[0] = spatialReference.GetAttrValue("PRIMEM", 0);
        this.primem[1] = spatialReference.GetAttrValue("PRIMEM", 1);
        double toRadians = spatialReference.GetAngularUnits();
        this.unit[1] = String.valueOf(toRadians);
        this.unit[0] = toRadians == 1.0 ? "radian" : "degree";
        this.authority[0] = spatialReference.GetAuthorityName(null);
        this.authority[1] = spatialReference.GetAuthorityCode(null);
    }

    public CrsWkt(String wkt_spaces) {
        String wkt = USERNAME;
        for (int i = 0; i < wkt_spaces.length(); ++i) {
            String aux = USERNAME + wkt_spaces.charAt(i);
            wkt = !aux.equals(" ") ? wkt + aux : wkt + USERNAME;
        }
        if (wkt.length() > 15) {
            this.fromWKT(wkt, false);
        } else {
            this.fromCode(wkt);
        }
    }

    public CrsWkt(CoordinateReferenceSystem crsGT) {
        DefaultGeodeticDatum d;
        String[] val;
        DefaultProjectedCRS sour;
        AbstractSingleCRS crs = (AbstractSingleCRS)crsGT;
        String authority = crs.getName().toString().split(":")[0];
        this.setAuthority(((AbstractSingleCRS)crsGT).getIdentifiers().iterator().next().toString());
        this.setWkt(crsGT.toWKT());
        if (crsGT instanceof DefaultProjectedCRS) {
            sour = (DefaultProjectedCRS)crsGT;
            this.setProjcs(sour.getName().toString().split(":")[1]);
            val = sour.getBaseCRS().getName().toString().split(":");
            if (val.length < 2) {
                this.setGeogcs(sour.getBaseCRS().getName().toString().split(":")[0]);
            } else {
                this.setGeogcs(sour.getBaseCRS().getName().toString().split(":")[1]);
            }
            d = (DefaultGeodeticDatum)sour.getDatum();
            val = d.getName().toString().split(":");
            if (val.length < 2) {
                this.setDatumName(d.getName().toString().split(":")[0]);
            } else {
                this.setDatumName(d.getName().toString().split(":")[1]);
            }
            this.setSpheroid((DefaultEllipsoid)d.getEllipsoid());
            this.setPrimen(d.getPrimeMeridian());
            val = sour.getConversionFromBase().getMethod().getName().toString().split(":");
            if (val.length < 2) {
                this.setProjection(sour.getConversionFromBase().getMethod().getName().toString().split(":")[0]);
            } else {
                this.setProjection(sour.getConversionFromBase().getMethod().getName().toString().split(":")[1]);
            }
            this.param_name = new String[sour.getConversionFromBase().getParameterValues().values().size()];
            this.param_value = new String[sour.getConversionFromBase().getParameterValues().values().size()];
            for (int i = 0; i < sour.getConversionFromBase().getParameterValues().values().size(); ++i) {
                String str = sour.getConversionFromBase().getParameterValues().values().get(i).toString();
                Unit u = sour.getConversionFromBase().getParameterValues().parameter(str.split("=")[0]).getUnit();
                double value = sour.getConversionFromBase().getParameterValues().parameter(str.split("=")[0]).doubleValue();
                value = this.convert(value, u.toString());
                this.param_name[i] = str.split("=")[0];
                this.param_value[i] = String.valueOf(value);
            }
        }
        if (crsGT instanceof DefaultGeographicCRS) {
            sour = (DefaultGeographicCRS)crsGT;
            val = sour.getName().toString().split(":");
            if (val.length < 2) {
                this.setGeogcs(sour.getName().toString().split(":")[0]);
            } else {
                this.setGeogcs(sour.getName().toString().split(":")[1]);
            }
            d = (DefaultGeodeticDatum)sour.getDatum();
            val = d.getName().toString().split(":");
            if (val.length < 2) {
                this.setDatumName(d.getName().toString().split(":")[0]);
            } else {
                this.setDatumName(d.getName().toString().split(":")[1]);
            }
            this.setSpheroid((DefaultEllipsoid)d.getEllipsoid());
            this.setPrimen(d.getPrimeMeridian());
        }
    }

    private void fromWKT(String wkt, boolean isProj) {
        SpatialReference sr = CrsFactory.getSpatialReferenceFromWKT(wkt);
        this.fromSpatialReference(sr);
    }

    public String getProjection() {
        return this.projection;
    }

    public String getProjcs() {
        return this.projcs;
    }

    public String getGeogcs() {
        return this.geogcs;
    }

    public String getDatumName() {
        return this.datum;
    }

    public String[] getSpheroid() {
        return this.spheroid;
    }

    public String[] getPrimen() {
        return this.primem;
    }

    public String getName() {
        if (this.projcs == USERNAME) {
            return this.geogcs;
        }
        return this.projcs;
    }

    public String[] getUnit() {
        return this.unit;
    }

    public String[] getUnit_p() {
        return this.unit_p;
    }

    public String[] getParam_name() {
        return this.param_name;
    }

    public String[] getParam_value() {
        return this.param_value;
    }

    public String[] getAuthority() {
        return this.authority;
    }

    private void fromCode(String code) {
        this.setAuthority(code);
        try {
            DefaultGeodeticDatum d;
            String[] val;
            DefaultProjectedCRS sour;
            CoordinateReferenceSystem source = CRS.decode((String)code);
            this.setWkt(source.toWKT());
            if (source instanceof DefaultProjectedCRS) {
                sour = (DefaultProjectedCRS)source;
                this.setProjcs(sour.getName().toString().split(":")[1]);
                val = sour.getBaseCRS().getName().toString().split(":");
                if (val.length < 2) {
                    this.setGeogcs(sour.getBaseCRS().getName().toString().split(":")[0]);
                } else {
                    this.setGeogcs(sour.getBaseCRS().getName().toString().split(":")[1]);
                }
                d = (DefaultGeodeticDatum)sour.getDatum();
                val = d.getName().toString().split(":");
                if (val.length < 2) {
                    this.setDatumName(d.getName().toString().split(":")[0]);
                } else {
                    this.setDatumName(d.getName().toString().split(":")[1]);
                }
                this.setSpheroid((DefaultEllipsoid)d.getEllipsoid());
                this.setPrimen(d.getPrimeMeridian());
                val = sour.getConversionFromBase().getMethod().getName().toString().split(":");
                if (val.length < 2) {
                    this.setProjection(sour.getConversionFromBase().getMethod().getName().toString().split(":")[0]);
                } else {
                    this.setProjection(sour.getConversionFromBase().getMethod().getName().toString().split(":")[1]);
                }
                this.param_name = new String[sour.getConversionFromBase().getParameterValues().values().size()];
                this.param_value = new String[sour.getConversionFromBase().getParameterValues().values().size()];
                for (int i = 0; i < sour.getConversionFromBase().getParameterValues().values().size(); ++i) {
                    String str = sour.getConversionFromBase().getParameterValues().values().get(i).toString();
                    Unit u = sour.getConversionFromBase().getParameterValues().parameter(str.split("=")[0]).getUnit();
                    double value = sour.getConversionFromBase().getParameterValues().parameter(str.split("=")[0]).doubleValue();
                    value = this.convert(value, u.toString());
                    this.param_name[i] = str.split("=")[0];
                    this.param_value[i] = String.valueOf(value);
                }
            }
            if (source instanceof DefaultGeographicCRS) {
                sour = (DefaultGeographicCRS)source;
                val = sour.getName().toString().split(":");
                if (val.length < 2) {
                    this.setGeogcs(sour.getName().toString().split(":")[0]);
                } else {
                    this.setGeogcs(sour.getName().toString().split(":")[1]);
                }
                d = (DefaultGeodeticDatum)sour.getDatum();
                val = d.getName().toString().split(":");
                if (val.length < 2) {
                    this.setDatumName(d.getName().toString().split(":")[0]);
                } else {
                    this.setDatumName(d.getName().toString().split(":")[1]);
                }
                this.setSpheroid((DefaultEllipsoid)d.getEllipsoid());
                this.setPrimen(d.getPrimeMeridian());
            }
        }
        catch (NoSuchAuthorityCodeException e) {
            logger.error("Can't create CRS from code '" + code + "'.", (Throwable)e);
        }
        catch (FactoryException e) {
            logger.error("Can't create CRS from code '" + code + "'.", (Throwable)e);
        }
    }

    public void setProjcs(String proj) {
        this.projcs = proj;
    }

    public void setProjection(String projection) {
        this.projection = projection;
    }

    public void setGeogcs(String geo) {
        this.geogcs = geo;
    }

    public void setDatumName(String dat) {
        this.datum = dat;
    }

    public void setSpheroid(DefaultEllipsoid ellips) {
        Unit u = ellips.getAxisUnit();
        double semi_major = this.convert(ellips.getSemiMajorAxis(), u.toString());
        double inv_f = this.convert(ellips.getInverseFlattening(), u.toString());
        String[] val = ellips.getName().toString().split(":");
        this.spheroid[0] = val.length < 2 ? ellips.getName().toString().split(":")[0] : ellips.getName().toString().split(":")[1];
        this.spheroid[1] = String.valueOf(semi_major);
        this.spheroid[2] = String.valueOf(inv_f);
    }

    public void setPrimen(PrimeMeridian prim) {
        DefaultPrimeMeridian pm = (DefaultPrimeMeridian)prim;
        Unit u = pm.getAngularUnit();
        double value = this.convert(pm.getGreenwichLongitude(), u.toString());
        String[] val = pm.getName().toString().split(":");
        this.primem[0] = val.length < 2 ? pm.getName().toString().split(":")[0] : pm.getName().toString().split(":")[1];
        this.primem[1] = String.valueOf(value);
    }

    public void setAuthority(String aut) {
        this.authority = aut.split(":");
    }

    public void setWkt(String wkt) {
        this.wkt = wkt;
    }

    public String getWkt() {
        return this.wkt;
    }

    public double convert(double value, String measure) throws ConversionException {
        if (measure.equals("D.MS")) {
            int deg = (int)((value *= (double)this.divider) / 10000.0);
            int min = (int)((value -= (double)(10000 * deg)) / 100.0);
            value -= (double)(100 * min);
            if (min <= -60 || min >= 60) {
                if ((double)Math.abs(Math.abs(min) - 100) <= 1.0E-8) {
                    deg = min >= 0 ? ++deg : --deg;
                    min = 0;
                } else {
                    throw new ConversionException("Invalid minutes: " + min);
                }
            }
            if (value <= -60.0 || value >= 60.0) {
                if (Math.abs(Math.abs(value) - 100.0) <= 1.0E-8) {
                    min = value >= 0.0 ? ++min : --min;
                    value = 0.0;
                } else {
                    throw new ConversionException("Invalid secondes: " + value);
                }
            }
            value = (value / 60.0 + (double)min) / 60.0 + (double)deg;
            return value;
        }
        if (measure.equals("grad") || measure.equals("grade")) {
            return value * 180.0 / 200.0;
        }
        if (measure.equals("\u00b0")) {
            return value;
        }
        if (measure.equals("DMS")) {
            return value;
        }
        if (measure.equals("m")) {
            return value;
        }
        if (measure.startsWith("[m*")) {
            return value * Double.parseDouble(measure.substring(3, measure.length() - 1));
        }
        if (measure.equals(USERNAME)) {
            return value;
        }
        if (measure.equalsIgnoreCase("ft") || measure.equalsIgnoreCase("foot") || measure.equalsIgnoreCase("feet")) {
            return value * 0.3048 / 1.0;
        }
        throw new ConversionException("Conversion no contemplada: " + measure);
    }

    public static class WKT {
        String data;
        static int cnt = 0;

        public WKT(String data) {
            this.data = data;
            Param param = this.parseParam(0);
        }

        private Param parseParam(int pos) {
            Param param = null;
            int l = this.data.length();
            int i = pos;
            while (i < l) {
                String name;
                int abre;
                int cierra;
                int nextParam = this.data.indexOf(",", i);
                if (nextParam == i) {
                    nextParam = this.data.indexOf(",", ++i);
                }
                if ((cierra = this.data.indexOf("]", i)) < (abre = this.data.indexOf("[", i))) {
                    WKT.pinta(" =>");
                    param.pos = cierra;
                    return param;
                }
                if (param == null) {
                    if (abre <= 0) continue;
                    String key = this.data.substring(i, this.data.indexOf("[", i));
                    WKT.pinta(key + " <= ");
                    i = abre + 1;
                    param = new Param(key);
                    continue;
                }
                if (this.data.substring(i).startsWith("\"")) {
                    name = this.data.substring(i + 1, this.data.indexOf("\"", i + 1));
                    i += name.length() + 2;
                    WKT.pinta("|" + name + "|,");
                    param.addValue(name);
                    continue;
                }
                if (nextParam < abre) {
                    name = this.data.substring(i, this.data.indexOf(",", i));
                    i += name.length();
                    WKT.pinta(name + ",");
                    param.addValue(name);
                    continue;
                }
                Param p = this.parseParam(i);
                i = p.pos + 1;
            }
            return param;
        }

        public static void pinta(String str) {
            if (++cnt > 60) {
                System.exit(1);
            }
            System.out.println(str);
        }

        public class Param {
            String key;
            ArrayList values = new ArrayList();
            ArrayList params = new ArrayList();
            public int pos = 0;

            public Param(String key) {
                this.key = key;
            }

            public void addValue(String name) {
                this.values.add(name);
            }

            public void addParam(Param p) {
                this.params.add(p);
            }
        }
    }
}

