/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.prov.converttopolyline;

import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.primitive.Curve;
import org.gvsig.fmap.geom.primitive.Line;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposableIterator;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.service.spi.ProviderServices;
import org.gvsig.vectorediting.lib.api.DrawingStatus;
import org.gvsig.vectorediting.lib.api.EditingServiceParameter;
import org.gvsig.vectorediting.lib.api.exceptions.DrawServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.FinishServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.InvalidEntryException;
import org.gvsig.vectorediting.lib.api.exceptions.StartServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.StopServiceException;
import org.gvsig.vectorediting.lib.spi.AbstractEditingProvider;
import org.gvsig.vectorediting.lib.spi.DefaultEditingServiceParameter;
import org.gvsig.vectorediting.lib.spi.EditingProvider;
import org.gvsig.vectorediting.lib.spi.EditingProviderServices;

public class ConvertToPolylineEditingProvider
extends AbstractEditingProvider
implements EditingProvider {
    private final EditingServiceParameter selectionParameter;
    private FeatureSelection featureSelection;
    private final FeatureStore featureStore;

    public ConvertToPolylineEditingProvider(ProviderServices providerServices, DynObject parameters) {
        super(providerServices);
        this.featureStore = (FeatureStore)parameters.getDynValue("featureStore");
        this.selectionParameter = new DefaultEditingServiceParameter("selection", "selection", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.SELECTION});
    }

    public EditingServiceParameter next() {
        if (this.featureSelection == null) {
            return this.selectionParameter;
        }
        return null;
    }

    public boolean mustRestartAtFinish() {
        return false;
    }

    public DrawingStatus getDrawingStatus(Point mousePosition) throws DrawServiceException {
        return null;
    }

    public void stop() throws StopServiceException {
        DisposeUtils.disposeQuietly((Disposable)this.featureSelection);
        this.featureSelection = null;
    }

    public List<EditingServiceParameter> getParameters() {
        ArrayList<EditingServiceParameter> parameters = new ArrayList<EditingServiceParameter>();
        parameters.add(this.selectionParameter);
        return parameters;
    }

    public void setValue(EditingServiceParameter parameter, Object value) throws InvalidEntryException {
        this.validateAndInsertValue(parameter, value);
    }

    public void setValue(Object value) throws InvalidEntryException {
        EditingServiceParameter parameter = this.next();
        this.validateAndInsertValue(parameter, value);
    }

    private void validateAndInsertValue(EditingServiceParameter parameter, Object value) throws InvalidEntryException {
        FeatureSelection fSelection;
        if (parameter == this.selectionParameter && value instanceof FeatureSelection && (fSelection = (FeatureSelection)value).getSelectedCount() >= 1L) {
            DisposableIterator it = null;
            try {
                it = fSelection.fastIterator();
                while (it.hasNext()) {
                    Feature feature = (Feature)it.next();
                    GeometryType geometryType = feature.getDefaultGeometry().getGeometryType();
                    if (geometryType.isTypeOf(2) || geometryType.isTypeOf(8)) continue;
                    throw new InvalidEntryException(null);
                }
                DisposeUtils.disposeQuietly((Disposable)this.featureSelection);
                ToolsLocator.getDisposableManager().bind((Disposable)fSelection);
                this.featureSelection = fSelection;
            }
            catch (DataException e) {
                throw new InvalidEntryException((Throwable)e);
            }
            finally {
                DisposeUtils.disposeQuietly((Disposable)it);
            }
        }
    }

    public Geometry finish() throws FinishServiceException {
        return null;
    }

    public void finishAndStore() throws FinishServiceException {
        if (this.featureSelection != null) {
            GeometryManager geometryManager = GeometryLocator.getGeometryManager();
            EditingProviderServices editingProviderServices = this.getProviderServices();
            DisposableIterator it = null;
            try {
                it = this.featureSelection.fastIterator();
                while (it.hasNext()) {
                    Feature feature = (Feature)it.next();
                    EditableFeature eFeature = feature.getEditable();
                    Geometry geometry = feature.getDefaultGeometry();
                    if (geometry.getGeometryType().isTypeOf(2)) {
                        eFeature.setDefaultGeometry((Geometry)geometry.toLines().getPrimitiveAt(0));
                    } else if (geometry.getGeometryType().isTypeOf(8)) {
                        eFeature.setDefaultGeometry((Geometry)geometry.toLines());
                    }
                    DisposeUtils.disposeQuietly((Disposable)this.featureSelection);
                    editingProviderServices.updateFeatureInFeatureStore((Feature)eFeature, this.featureStore);
                }
                this.featureStore.getFeatureSelection().deselectAll();
            }
            catch (BaseException e) {
                throw new FinishServiceException((Throwable)e);
            }
            finally {
                DisposeUtils.disposeQuietly((Disposable)it);
            }
        }
    }

    private Line convertCurveToLine(Curve curve) throws CreateGeometryException {
        GeometryManager geometryManager = GeometryLocator.getGeometryManager();
        Line newLine = geometryManager.createLine(curve.getGeometryType().getSubType());
        for (int i = 0; i < curve.getNumVertices(); ++i) {
            newLine.addVertex(curve.getVertex(i));
        }
        return newLine;
    }

    public void start() throws StartServiceException, InvalidEntryException {
        FeatureSelection selected = null;
        if (this.featureStore != null) {
            try {
                selected = this.featureStore.getFeatureSelection();
            }
            catch (DataException e) {
                throw new StartServiceException((Throwable)e);
            }
            if (selected.getSelectedCount() >= 1L) {
                try {
                    this.setValue(selected);
                }
                catch (InvalidEntryException e) {
                    throw new InvalidEntryException((Throwable)e);
                }
            }
        }
    }

    public String getName() {
        return "modify-convert-to-polyline";
    }

    public Object getValue(EditingServiceParameter parameter) {
        if (parameter == this.selectionParameter) {
            return this.featureSelection;
        }
        return null;
    }
}

