/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.wmts.ogc.impl.struct;

import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.cresques.cts.ICoordTrans;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.crs.CRSFactory;
import org.gvsig.raster.wmts.ogc.WMTSStatus;
import org.gvsig.raster.wmts.ogc.impl.base.WMTSServerDescription;
import org.gvsig.raster.wmts.ogc.impl.struct.TemplateSupport;
import org.gvsig.raster.wmts.ogc.impl.struct.WMTSBaseStruct;
import org.gvsig.raster.wmts.ogc.impl.struct.WMTSBoundingBoxImpl;
import org.gvsig.raster.wmts.ogc.impl.struct.WMTSDimensionImpl;
import org.gvsig.raster.wmts.ogc.impl.struct.WMTSTileMatrixImpl;
import org.gvsig.raster.wmts.ogc.impl.struct.WMTSTileMatrixLimitsImpl;
import org.gvsig.raster.wmts.ogc.impl.struct.WMTSTileMatrixSetImpl;
import org.gvsig.raster.wmts.ogc.impl.struct.WMTSTileMatrixSetLinkImpl;
import org.gvsig.raster.wmts.ogc.struct.WMTSBoundingBox;
import org.gvsig.raster.wmts.ogc.struct.WMTSDimension;
import org.gvsig.raster.wmts.ogc.struct.WMTSLayer;
import org.gvsig.raster.wmts.ogc.struct.WMTSResourceURL;
import org.gvsig.raster.wmts.ogc.struct.WMTSStyle;
import org.gvsig.raster.wmts.ogc.struct.WMTSTileMatrix;
import org.gvsig.raster.wmts.ogc.struct.WMTSTileMatrixLimits;
import org.gvsig.raster.wmts.ogc.struct.WMTSTileMatrixSet;
import org.gvsig.raster.wmts.ogc.struct.WMTSTileMatrixSetLink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WMTSLayerImpl
extends WMTSBaseStruct
implements WMTSLayer {
    protected WMTSBoundingBox wgs84bbox = null;
    protected WMTSBoundingBox bbox = null;
    private List<WMTSStyle> style = null;
    private List<String> imageFormat = null;
    private List<String> infoFormat = null;
    private List<String> keywords = null;
    private List<WMTSDimension> dimension = null;
    private String metadata = null;
    private List<WMTSTileMatrixSetLink> tileMatrixSetLinkList = null;
    private List<WMTSResourceURL> resourceURL = null;
    protected WMTSServerDescription status = null;
    private Logger log = LoggerFactory.getLogger(WMTSLayerImpl.class);
    protected boolean forceChangeAxisOrder = false;
    private HashMap<String, Rectangle2D> transformations = new HashMap();

    public void setForceChangeAxisOrder(boolean force) {
        this.forceChangeAxisOrder = force;
    }

    public WMTSLayerImpl(WMTSServerDescription status) {
        this.status = status;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    public List<String> getFormat() {
        if (this.imageFormat == null) {
            this.imageFormat = new ArrayList<String>();
        }
        return this.imageFormat;
    }

    public List<String> getInfoFormat() {
        if (this.infoFormat == null) {
            this.infoFormat = new ArrayList<String>();
        }
        return this.infoFormat;
    }

    public List<String> getKeywords() {
        return this.keywords;
    }

    public void setKeywords(List<String> k) {
        this.keywords = k;
    }

    public WMTSBoundingBox getWGS84BBox() {
        return this.wgs84bbox;
    }

    public Rectangle2D getWGS84BBoxTransformed(String epsg) {
        block6: {
            Rectangle2D r = this.transformations.get(epsg);
            if (r != null) {
                return r;
            }
            IProjection projSrc = CRSFactory.getCRS((String)"EPSG:4326");
            try {
                IProjection projDst = CRSFactory.getCRS((String)epsg);
                if (projDst == null) break block6;
                try {
                    ICoordTrans t = projSrc.getCT(projDst);
                    r = t != null ? t.convert(this.wgs84bbox.toRectangle2D()) : this.wgs84bbox.toRectangle2D();
                    if (this.isBoundingBoxValid(r)) {
                        this.transformations.put(epsg, r);
                        return r;
                    }
                }
                catch (Exception e) {
                    this.log.info("I cannot get the transformation between EPSG:4326 and " + epsg, (Throwable)e);
                }
            }
            catch (Exception e1) {
                this.log.info("I cannot get " + epsg, (Throwable)e1);
            }
        }
        return null;
    }

    private boolean isBoundingBoxValid(Rectangle2D bbox) {
        return !Double.isInfinite(bbox.getX()) && !Double.isNaN(bbox.getX()) && !Double.isInfinite(bbox.getY()) && !Double.isNaN(bbox.getY());
    }

    public WMTSBoundingBox getBBox() {
        return this.bbox;
    }

    public void setWGS84BBox(WMTSBoundingBox wgs84bbox) {
        this.wgs84bbox = wgs84bbox;
    }

    public void setBBox(WMTSBoundingBox bbox) {
        this.bbox = bbox;
    }

    public List<WMTSResourceURL> getResourceURL() {
        if (this.resourceURL == null) {
            this.resourceURL = new ArrayList<WMTSResourceURL>();
        }
        return this.resourceURL;
    }

    public List<WMTSDimension> getDimensions() {
        if (this.dimension == null) {
            this.dimension = new ArrayList<WMTSDimension>();
        }
        return this.dimension;
    }

    public List<WMTSStyle> getStyle() {
        if (this.style == null) {
            this.style = new ArrayList<WMTSStyle>();
        }
        return this.style;
    }

    public List<WMTSTileMatrixSetLink> getTileMatrixSetLink() {
        if (this.tileMatrixSetLinkList == null) {
            this.tileMatrixSetLinkList = new ArrayList<WMTSTileMatrixSetLink>();
        }
        return this.tileMatrixSetLinkList;
    }

    public int getInitialLevel(String tileMatrixSetId) {
        int initialLevel = 0;
        for (int i = 0; i < this.tileMatrixSetLinkList.size(); ++i) {
            List<WMTSTileMatrixLimits> tileMatrixLimits;
            WMTSTileMatrixSetLinkImpl tileMatrixSetLink = (WMTSTileMatrixSetLinkImpl)this.tileMatrixSetLinkList.get(i);
            String id = tileMatrixSetLink.getTileMatrixSetId();
            if (tileMatrixSetId.compareTo(id) != 0 || (tileMatrixLimits = tileMatrixSetLink.getTileMatrixLimits()) == null || tileMatrixLimits.size() <= 0) continue;
            String ref = ((WMTSTileMatrixLimitsImpl)tileMatrixLimits.get(0)).getRefToTileMatrix();
            List<WMTSTileMatrix> tileMatrixList = ((WMTSTileMatrixSetImpl)tileMatrixSetLink.getTileMatrixSet()).getTileMatrix();
            for (int j = 0; j < tileMatrixList.size(); ++j) {
                String idTileMatrix = ((WMTSTileMatrixImpl)tileMatrixList.get(j)).getIdentifier();
                if (idTileMatrix.compareTo(ref) == 0) {
                    return initialLevel;
                }
                ++initialLevel;
            }
        }
        return initialLevel;
    }

    public void linkTileMatrixSets(List<WMTSTileMatrixSet> tileMatrixSetList) {
        if (this.tileMatrixSetLinkList == null) {
            return;
        }
        block0: for (int i = 0; i < this.tileMatrixSetLinkList.size(); ++i) {
            WMTSTileMatrixSetLinkImpl tileMatrixSetLink = (WMTSTileMatrixSetLinkImpl)this.tileMatrixSetLinkList.get(i);
            String id = tileMatrixSetLink.getTileMatrixSetId();
            for (int j = 0; j < tileMatrixSetList.size(); ++j) {
                WMTSTileMatrixSetImpl tileMatrixSet = (WMTSTileMatrixSetImpl)tileMatrixSetList.get(j);
                if (tileMatrixSet.getIdentifier().compareTo(id) != 0) continue;
                tileMatrixSetLink.setTileMatrixSet(tileMatrixSet);
                tileMatrixSetLink.linkTileMatrix(tileMatrixSet);
                continue block0;
            }
        }
    }

    public List<String> getSrsList() {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < this.tileMatrixSetLinkList.size(); ++i) {
            WMTSTileMatrixSetLinkImpl link = (WMTSTileMatrixSetLinkImpl)this.tileMatrixSetLinkList.get(i);
            WMTSTileMatrixSetImpl tileMatrixSet = (WMTSTileMatrixSetImpl)link.getTileMatrixSet();
            list.add(tileMatrixSet.getSupportedCRS());
        }
        return list;
    }

    public void buildResourceURLListFromTemplate(WMTSStatus status) {
        TemplateSupport templateSupport = new TemplateSupport(this.getDimensions(), this.getResourceURL());
        templateSupport.buildResourceURLListFromTemplate(status);
    }

    public void print() {
        int i;
        System.out.println("*****WMTSLayer******");
        System.out.println("Abstract:" + this.getAbstract());
        System.out.println("Identifier:" + this.getIdentifier());
        System.out.println("Keywords:");
        for (i = 0; i < this.keywords.size(); ++i) {
            System.out.println("Keyword:" + this.keywords.get(i));
        }
        System.out.println("Title:" + this.getTitle());
        for (i = 0; i < this.getFormat().size(); ++i) {
            System.out.println("Format:" + this.getFormat().get(i));
        }
        for (i = 0; i < this.getInfoFormat().size(); ++i) {
            System.out.println("InfoFormat:" + this.getInfoFormat().get(i));
        }
        ((WMTSBoundingBoxImpl)this.getBBox()).print();
        ((WMTSBoundingBoxImpl)this.getWGS84BBox()).print();
        for (i = 0; i < this.getDimensions().size(); ++i) {
            ((WMTSDimensionImpl)this.getDimensions().get(i)).print();
        }
        System.out.println("Metadata:" + this.getMetadata());
        for (i = 0; i < this.getTileMatrixSetLink().size(); ++i) {
            ((WMTSTileMatrixSetLinkImpl)this.getTileMatrixSetLink().get(i)).print();
        }
    }
}

