/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.wcs.io.downloader;

import java.awt.geom.Rectangle2D;
import org.gvsig.fmap.dal.coverage.exception.RemoteServiceException;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.raster.cache.tile.Tile;
import org.gvsig.raster.cache.tile.exception.TileGettingException;
import org.gvsig.raster.impl.provider.tile.BaseTileDownloader;
import org.gvsig.raster.wcs.io.WCSConnector;
import org.gvsig.raster.wcs.io.WCSDataParametersImpl;
import org.gvsig.remoteclient.wcs.WCSStatus;

public class TileDownloaderForWCS
extends BaseTileDownloader {
    private WCSConnector connector = null;

    public TileDownloaderForWCS(RasterDataStore store, int tilePxWidth, int tilePxHeight, WCSConnector connector) {
        super(store, tilePxWidth, tilePxHeight);
        this.connector = connector;
    }

    public synchronized Tile downloadTile(Tile tile) throws TileGettingException {
        try {
            Rectangle2D.Double r = new Rectangle2D.Double(tile.getExtent().getMinX(), tile.getExtent().getMinY() - tile.getExtent().getHeight(), tile.getExtent().getWidth(), tile.getExtent().getHeight());
            WCSDataParametersImpl p = (WCSDataParametersImpl)this.store.getParameters();
            WCSStatus wcsStatus = new WCSStatus();
            wcsStatus.setCoveraName(p.getCoverageName());
            wcsStatus.setSrs(p.getSRSCode());
            wcsStatus.setFormat(p.getFormat());
            wcsStatus.setDepth(p.getDepth());
            wcsStatus.setOnlineResource(p.getOnlineResource() != null ? p.getOnlineResource().get("GetCoverage") : null);
            wcsStatus.setExtent((Rectangle2D)r);
            wcsStatus.setHeight(tile.getHeightPx());
            wcsStatus.setWidth(tile.getWidthPx());
            this.connector.getCoverageURL(wcsStatus, tile.getCancelled(), tile.getFile());
        }
        catch (RemoteServiceException e) {
            throw new TileGettingException((Throwable)e);
        }
        this.readTileFromDisk(tile);
        return tile;
    }
}

