/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.installer.lib.impl;

import java.util.ArrayList;
import java.util.List;
import org.gvsig.installer.lib.impl.DefaultInstallerProviderServices;
import org.gvsig.installer.lib.impl.execution.NotInstallerExecutionProviderException;
import org.gvsig.installer.lib.spi.InstallPackageProviderServices;
import org.gvsig.installer.lib.spi.InstallerProviderManager;
import org.gvsig.installer.lib.spi.execution.InstallPackageProvider;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynClass;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.dynobject.DynObjectManager;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.extensionpoint.ExtensionPoint;
import org.gvsig.tools.extensionpoint.ExtensionPointManager;
import org.gvsig.tools.service.Service;
import org.gvsig.tools.service.ServiceException;
import org.gvsig.tools.service.spi.AbstractProviderManager;
import org.gvsig.tools.service.spi.NotRegisteredException;
import org.gvsig.tools.service.spi.Provider;
import org.gvsig.tools.service.spi.ProviderFactory;
import org.gvsig.tools.service.spi.ProviderServices;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultInstallerProviderManager
extends AbstractProviderManager
implements InstallerProviderManager {
    public static final String PROVIDERS_NAMESPACE = "Installer.providers";
    public static final String PROVIDERS_NAME = "Installer.providers";
    public static final String PROVIDERS_DESCRIPTION = "Installer providers";
    private static Logger logger = LoggerFactory.getLogger(DefaultInstallerProviderManager.class);
    private static final String INSTALL_INFO_FILE = "package.info";

    protected String getRegistryDescription() {
        return PROVIDERS_DESCRIPTION;
    }

    protected String getRegistryKey() {
        return "Installer.providers";
    }

    public ProviderServices createProviderServices(Service service) {
        return new DefaultInstallerProviderServices();
    }

    public InstallPackageProvider createExecutionProvider(String providerName) throws ServiceException {
        DynObjectManager dynObjectManager = ToolsLocator.getDynObjectManager();
        DynClass dynClass = dynObjectManager.get(providerName);
        if (dynClass == null) {
            throw new NotRegisteredException(providerName);
        }
        DynObject serviceParameters = dynObjectManager.createDynObject((DynStruct)dynClass);
        Provider provider = this.createProvider(serviceParameters, (ProviderServices)new DefaultInstallerProviderServices());
        if (!(provider instanceof InstallPackageProvider)) {
            throw new NotInstallerExecutionProviderException(providerName);
        }
        return (InstallPackageProvider)provider;
    }

    public InstallPackageProviderServices createInstallerProviderServices() {
        return new DefaultInstallerProviderServices();
    }

    public String getPackageInfoFileName() {
        return INSTALL_INFO_FILE;
    }

    public List<ProviderFactory> getProviderFactories() {
        ExtensionPointManager epm = ToolsLocator.getExtensionPointManager();
        ExtensionPoint ep = epm.get(this.getRegistryKey());
        List names = ep.getNames();
        ArrayList<ProviderFactory> factories = new ArrayList<ProviderFactory>();
        for (int i = 0; i < names.size(); ++i) {
            try {
                factories.add((ProviderFactory)ep.create((String)names.get(i)));
                continue;
            }
            catch (InstantiationException e) {
                logger.info("Cannot retreive the factory provider of " + (String)names.get(i), (Throwable)e);
                continue;
            }
            catch (IllegalAccessException e) {
                logger.info("Cannot retreive the factory provider of " + (String)names.get(i), (Throwable)e);
            }
        }
        return factories;
    }
}

