/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.index.rtree.cachefs;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.util.EmptyStackException;
import org.geotools.index.Data;
import org.geotools.index.DataDefinition;
import org.geotools.index.TreeException;
import org.geotools.index.rtree.Entry;
import org.geotools.index.rtree.Node;
import org.geotools.index.rtree.cachefs.Parameters;

public class FileSystemNode
extends Node {
    static final int ENTRY_SIZE = 40;
    private static int pageLen = 0;
    private Parameters params = null;
    private boolean flushNeeded;
    private long parentOffset = -1L;
    private long offset = -1L;

    private FileSystemNode(Parameters params, boolean getFromFree) {
        super(params.getMaxNodeEntries());
        this.params = params;
        if (pageLen == 0) {
            pageLen = params.getMaxNodeEntries() * 40 + 9;
        }
        Long oOffset = null;
        if (getFromFree) {
            try {
                oOffset = (Long)this.params.getFreePages().pop();
            }
            catch (EmptyStackException emptyStackException) {
                // empty catch block
            }
        }
        this.offset = oOffset == null ? -1L : oOffset;
        this.flushNeeded = false;
    }

    public FileSystemNode(Parameters params) {
        this(params, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileSystemNode(Parameters params, long offset) throws IOException, TreeException {
        this(params, false);
        this.offset = offset;
        FileChannel channel = this.params.getChannel();
        ByteBuffer buf = this.getEmptyByteBuffer();
        ByteBuffer dataBuf = null;
        FileChannel fileChannel = channel;
        synchronized (fileChannel) {
            channel.position(offset);
            channel.read(buf);
            buf.position(0);
            this.setLeaf(buf.get() == 1);
            if (this.isLeaf()) {
                dataBuf = this.getEmptyByteBuffer(this.params.getDataDef());
                channel.read(dataBuf);
                dataBuf.position(0);
            }
        }
        this.parentOffset = buf.getLong();
        Entry entry = null;
        int i = 0;
        while (i < this.params.getMaxNodeEntries()) {
            double x1 = buf.getDouble();
            double x2 = buf.getDouble();
            double y1 = buf.getDouble();
            double y2 = buf.getDouble();
            long p = buf.getLong();
            if (x1 == 0.0 && x2 == 0.0 && y1 == 0.0 && y2 == 0.0 && p == 0L) break;
            entry = this.isLeaf() ? new Entry(new Envelope(x1, x2, y1, y2), this.loadData(dataBuf, this.params.getDataDef())) : new Entry(new Envelope(x1, x2, y1, y2), new Long(p));
            this.addEntry(entry);
            ++i;
        }
    }

    private Data loadData(ByteBuffer buf, DataDefinition def) throws TreeException {
        Data data = new Data(def);
        DataDefinition.Field field = null;
        int i = 0;
        while (i < def.getFieldsCount()) {
            field = def.getField(i);
            if (field.getFieldClass().equals(Short.class)) {
                data.addValue(new Short(buf.getShort()));
            } else if (field.getFieldClass().equals(Integer.class)) {
                data.addValue(new Integer(buf.getInt()));
            } else if (field.getFieldClass().equals(Long.class)) {
                data.addValue(new Long(buf.getLong()));
            } else if (field.getFieldClass().equals(Float.class)) {
                data.addValue(new Float(buf.getFloat()));
            } else if (field.getFieldClass().equals(Double.class)) {
                data.addValue(new Double(buf.getDouble()));
            } else if (field.getFieldClass().equals(String.class)) {
                byte[] bytes = new byte[field.getEncodedLen()];
                buf.get(bytes);
                CharBuffer cb = def.getCharset().decode(ByteBuffer.wrap(bytes));
                cb.position(0);
                data.addValue(cb.toString().trim());
            }
            ++i;
        }
        return data;
    }

    private ByteBuffer getEmptyByteBuffer() {
        return ByteBuffer.allocate(pageLen);
    }

    private ByteBuffer getEmptyByteBuffer(DataDefinition dataDef) {
        int bufLen = dataDef.getEncodedLen() * this.params.getMaxNodeEntries();
        return ByteBuffer.allocate(bufLen);
    }

    long getOffset() {
        return this.offset;
    }

    public Node getParent() throws TreeException {
        FileSystemNode node = null;
        try {
            node = this.params.getFromCache(this.parentOffset);
        }
        catch (IOException e) {
            throw new TreeException(e);
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws TreeException {
        if (!this.flushNeeded) {
            return;
        }
        FileChannel channel = this.params.getChannel();
        try {
            ByteBuffer buf = this.getEmptyByteBuffer();
            ByteBuffer dataBuf = null;
            if (this.isLeaf()) {
                dataBuf = this.getEmptyByteBuffer(this.params.getDataDef());
            }
            buf.put(this.isLeaf() ? (byte)1 : 2);
            buf.putLong(this.parentOffset);
            long pointOffset = 0L;
            if (this.getEntriesCount() > 0) {
                Envelope env = null;
                int i = 0;
                while (i < this.getEntriesCount()) {
                    env = this.entries[i].getBounds();
                    buf.putDouble(env.getMinX());
                    buf.putDouble(env.getMaxX());
                    buf.putDouble(env.getMinY());
                    buf.putDouble(env.getMaxY());
                    Object objData = this.entries[i].getData();
                    if (this.isLeaf()) {
                        this.storeKeyData(dataBuf, (Data)objData);
                        pointOffset = -1L;
                    } else {
                        pointOffset = (Long)objData;
                    }
                    buf.putLong(pointOffset);
                    ++i;
                }
            }
            FileChannel fileChannel = channel;
            synchronized (fileChannel) {
                if (this.offset == -1L) {
                    throw new TreeException("Cannot flush a new node!");
                }
                buf.position(0);
                channel.position(this.offset);
                channel.write(buf);
                if (this.isLeaf()) {
                    dataBuf.position(0);
                    channel.write(dataBuf);
                }
                if (this.params.getForceChannel()) {
                    channel.force(false);
                }
            }
            this.flushNeeded = false;
        }
        catch (IOException e) {
            throw new TreeException(e);
        }
    }

    protected void doSave() throws TreeException {
        FileChannel channel = this.params.getChannel();
        try {
            if (this.offset == -1L) {
                int len = pageLen;
                if (this.isLeaf()) {
                    len += this.params.getDataDef().getEncodedLen() * this.params.getMaxNodeEntries();
                }
                this.offset = this.params.getNewNodeOffset(len);
                this.flushNeeded = true;
            }
            if (this.isChanged && !this.isLeaf()) {
                FileSystemNode child = null;
                int i = 0;
                while (i < this.entriesCount) {
                    child = this.params.getFromCache((Long)this.entries[i].getData());
                    child.setParent(this);
                    ++i;
                }
            }
            this.params.putToCache(this);
        }
        catch (IOException e) {
            throw new TreeException(e);
        }
    }

    protected void finalize() throws Throwable {
        this.flush();
    }

    private void storeKeyData(ByteBuffer buf, Data data) throws IOException {
        Object val = null;
        DataDefinition.Field field = null;
        int i = 0;
        while (i < data.getValuesCount()) {
            val = data.getValue(i);
            field = data.getDefinition().getField(i);
            if (val instanceof Short) {
                buf.putShort((Short)val);
            } else if (val instanceof Integer) {
                buf.putInt((Integer)val);
            } else if (val instanceof Long) {
                buf.putLong((Long)val);
            } else if (val instanceof Float) {
                buf.putFloat(((Float)val).floatValue());
            } else if (val instanceof Double) {
                buf.putDouble((Double)val);
            } else if (val instanceof String) {
                ByteBuffer strBuffer = ByteBuffer.allocate(field.getEncodedLen());
                ByteBuffer enc = data.getDefinition().getCharset().encode(val.toString());
                enc.position(0);
                strBuffer.put(enc);
                strBuffer.position(0);
                buf.put(strBuffer);
            }
            ++i;
        }
    }

    void free() throws IOException {
        if (this.offset < 0L) {
            return;
        }
        this.flushNeeded = false;
        this.params.removeFromCache(this);
        this.params.getFreePages().push(new Long(this.offset));
    }

    protected Entry getEntry(Node node) {
        FileSystemNode fn = (FileSystemNode)node;
        Entry ret = null;
        Long l = null;
        int i = 0;
        while (i < this.getEntriesCount()) {
            l = (Long)this.entries[i].getData();
            if (l.longValue() == fn.getOffset()) {
                ret = this.entries[i];
                break;
            }
            ++i;
        }
        return ret;
    }

    public void setParent(Node node) {
        if (node == null) {
            this.parentOffset = -1L;
        } else {
            FileSystemNode fn = (FileSystemNode)node;
            this.parentOffset = fn.getOffset();
        }
        this.flushNeeded = true;
    }

    public boolean equals(Object obj) {
        FileSystemNode comp = (FileSystemNode)obj;
        return this.getOffset() == comp.getOffset();
    }
}

