/*
 * Decompiled with CFR 0.152.
 */
package org.cresques.coerce;

import org.cresques.cts.IProjection;
import org.gvsig.fmap.crs.CRSFactory;
import org.gvsig.tools.dataTypes.AbstractCoercion;
import org.gvsig.tools.dataTypes.CoercionContext;
import org.gvsig.tools.dataTypes.CoercionException;

public class CoerceToCRS
extends AbstractCoercion {
    public Object coerce(Object value, CoercionContext context) throws CoercionException {
        if (value == null || value instanceof IProjection) {
            return value;
        }
        try {
            IProjection proj = CRSFactory.getCRS(value.toString());
            if (proj == null) {
                throw new CoercionException("Can't convert value '" + this.getValueAsString(value) + "' to IProjection. Probably not a valid format for a projection.");
            }
            return proj;
        }
        catch (Exception e) {
            throw new CoercionException("Can't convert value '" + this.getValueAsString(value) + "' to IProjection. Probably not a valid format for a projection.", (Throwable)e);
        }
    }

    private String getValueAsString(Object value) {
        try {
            return value.toString();
        }
        catch (Exception e) {
            return "(unknow)";
        }
    }
}

