/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gridAnalysis.fuzzify;

import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import java.util.Arrays;

public class FuzzifyAlgorithm
extends GeoAlgorithm {
    public static final String INPUT = "INPUT";
    public static final String FUNCTIONTYPE = "FUNCTIONTYPE";
    public static final String RESULT = "RESULT";
    public static final String A = "A";
    public static final String B = "B";
    public static final String C = "C";
    public static final String D = "D";
    public static final int MEMBER_FUNCTION_LINEAL = 0;
    public static final int MEMBER_FUNCTION_SIGMOIDAL = 1;
    public static final int MEMBER_FUNCTION_J_SHAPED = 2;
    int m_iNX;
    int m_iNY;
    IRasterLayer m_Grid;
    IRasterLayer m_Result;

    public void defineCharacteristics() {
        String[] sOptions = new String[]{Sextante.getText((String)"Linear"), Sextante.getText((String)"Sigmoidal"), Sextante.getText((String)"J-shaped")};
        this.setName(Sextante.getText((String)"Fuzzify"));
        this.setGroup(Sextante.getText((String)"Fuzzy_logic"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputRasterLayer(INPUT, Sextante.getText((String)"Input_Layer"), true);
            this.m_Parameters.addSelection(FUNCTIONTYPE, Sextante.getText((String)"Member_function"), sOptions);
            this.m_Parameters.addNumericalValue(A, Sextante.getText((String)"Control_point_A"), 10.0, 2);
            this.m_Parameters.addNumericalValue(B, Sextante.getText((String)"Control_point_B"), 10.0, 2);
            this.m_Parameters.addNumericalValue(C, Sextante.getText((String)"Control_point_C"), 10.0, 2);
            this.m_Parameters.addNumericalValue(D, Sextante.getText((String)"Control_point_D"), 10.0, 2);
            this.addOutputRasterLayer(RESULT, Sextante.getText((String)"Result"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_Grid = this.m_Parameters.getParameterValueAsRasterLayer(INPUT);
        int iType = this.m_Parameters.getParameterValueAsInt(FUNCTIONTYPE);
        double dA = this.m_Parameters.getParameterValueAsDouble(A);
        double dB = this.m_Parameters.getParameterValueAsDouble(B);
        double dC = this.m_Parameters.getParameterValueAsDouble(C);
        double dD = this.m_Parameters.getParameterValueAsDouble(D);
        double[] dPts = new double[]{dA, dB, dC, dD};
        Arrays.sort(dPts);
        dA = dPts[0];
        dB = dPts[1];
        dC = dPts[2];
        dD = dPts[3];
        this.m_Result = this.getNewRasterLayer(RESULT, this.m_Grid.getName() + "_" + Sextante.getText((String)"[fuzzy]"), 5);
        AnalysisExtent extent = this.m_Result.getWindowGridExtent();
        this.m_Grid.setWindowExtent(extent);
        this.m_Grid.setInterpolationMethod(4);
        int iNX = this.m_Grid.getNX();
        int iNY = this.m_Grid.getNY();
        int y = 0;
        while (y < iNY & this.setProgress(y, iNY)) {
            for (int x = 0; x < iNX; ++x) {
                double dValue = this.m_Grid.getCellValueAsDouble(x, y);
                if (!this.m_Grid.isNoDataValue(dValue)) {
                    double dW;
                    double dX;
                    if (dValue <= dA || dValue >= dD) {
                        this.m_Result.setCellValue(x, y, 0.0);
                        continue;
                    }
                    if (dValue >= dB && dValue <= dC) {
                        this.m_Result.setCellValue(x, y, 1.0);
                        continue;
                    }
                    if (dValue < dB) {
                        dX = dValue - dA;
                        dW = dB - dA;
                    } else {
                        dX = dD - dValue;
                        dW = dD - dC;
                    }
                    switch (iType) {
                        case 0: {
                            this.m_Result.setCellValue(x, y, dX / dW);
                            break;
                        }
                        case 1: {
                            this.m_Result.setCellValue(x, y, Math.pow(Math.sin(dX / dW * Math.PI / 2.0), 2.0));
                            break;
                        }
                        case 2: {
                            this.m_Result.setCellValue(x, y, 1.0 / (1.0 + Math.pow((dW - dX) / dW, 2.0)));
                        }
                    }
                    continue;
                }
                this.m_Result.setNoData(x, y);
            }
            ++y;
        }
        return !this.m_Task.isCanceled();
    }
}

