/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gridAnalysis.polarToRect;

import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;

public class PolarToRectAlgorithm
extends GeoAlgorithm {
    public static final String ANGLE = "ANGLE";
    public static final String DISTANCE = "DISTANCE";
    public static final String X = "X";
    public static final String Y = "Y";
    private int m_iNX;
    private int m_iNY;
    private IRasterLayer m_Distance;
    private IRasterLayer m_Angle;
    private IRasterLayer m_X;
    private IRasterLayer m_Y;

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Polar_to_Cartesian"));
        this.setGroup(Sextante.getText((String)"Cost_distances_and_routes"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputRasterLayer(ANGLE, Sextante.getText((String)"Angle"), true);
            this.m_Parameters.addInputRasterLayer(DISTANCE, Sextante.getText((String)"Distance"), true);
            this.addOutputRasterLayer(X, X);
            this.addOutputRasterLayer(Y, Y);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_Distance = this.m_Parameters.getParameterValueAsRasterLayer(DISTANCE);
        this.m_Angle = this.m_Parameters.getParameterValueAsRasterLayer(ANGLE);
        this.m_X = this.getNewRasterLayer(X, X, 5);
        this.m_Y = this.getNewRasterLayer(Y, Y, 5);
        AnalysisExtent extent = this.m_X.getWindowGridExtent();
        this.m_Distance.setWindowExtent(extent);
        this.m_Angle.setWindowExtent(extent);
        this.m_iNX = extent.getNX();
        this.m_iNY = extent.getNY();
        for (int y = 0; y < this.m_iNY && this.setProgress(y, this.m_iNY); ++y) {
            for (int x = 0; x < this.m_iNX; ++x) {
                double dDist = this.m_Distance.getCellValueAsDouble(x, y);
                double dAngle = this.m_Angle.getCellValueAsDouble(x, y);
                if (!this.m_Distance.isNoDataValue(dDist) && !this.m_Angle.isNoDataValue(dAngle)) {
                    double dX = Math.cos(dAngle) * dDist;
                    double dY = Math.sin(dAngle) * dDist;
                    this.m_X.setCellValue(x, y, dX);
                    this.m_Y.setCellValue(x, y, dY);
                    continue;
                }
                this.m_X.setNoData(x, y);
                this.m_Y.setNoData(x, y);
            }
        }
        return !this.m_Task.isCanceled();
    }
}

