/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gridCalculus.gridCalculator;

import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.gridCalculus.gridCalculator.FormulaParser;
import es.unex.sextante.gui.modeler.ModelAlgorithm;
import es.unex.sextante.modeler.elements.ModelElementNumericalValue;
import es.unex.sextante.parameters.RasterLayerAndBand;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.nfunk.jep.JEP;

public class GridCalculatorAlgorithm
extends GeoAlgorithm {
    public static final String LAYERS = "LAYERS";
    public static final String FORMULA = "FORMULA";
    public static final String RESULT = "RESULT";

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        int i;
        ArrayList<String> names = new ArrayList<String>();
        ArrayList layers = this.m_Parameters.getParameterValueAsArrayList(LAYERS);
        String sFormula = this.m_Parameters.getParameterValueAsString(FORMULA).toLowerCase();
        List<RasterLayerAndBand> bands = FormulaParser.getBandsFromFormula(sFormula, layers);
        if (bands == null) {
            throw new GeoAlgorithmExecutionException(Sextante.getText((String)"Syntax_error"));
        }
        IRasterLayer m_Result = this.getNewRasterLayer(RESULT, Sextante.getText((String)"Result"), 5);
        IRasterLayer[] window = new IRasterLayer[bands.size()];
        String[] sVariable = new String[bands.size()];
        int[] iBands = new int[bands.size()];
        AnalysisExtent extent = m_Result.getWindowGridExtent();
        int iNX = m_Result.getWindowGridExtent().getNX();
        int iNY = m_Result.getWindowGridExtent().getNY();
        JEP jep = new JEP();
        jep.addStandardConstants();
        jep.addStandardFunctions();
        for (i = 0; i < bands.size(); ++i) {
            RasterLayerAndBand layerAndBand = bands.get(i);
            IRasterLayer layer = layerAndBand.getRasterLayer();
            iBands[i] = layerAndBand.getBand();
            String layerName = layer.getName();
            String normalizedName = FormulaParser.getNormalizedName(layerName);
            sFormula = FormulaParser.replaceVariables(sFormula, layerName, normalizedName);
            names.add(normalizedName);
            window[i] = layer;
            window[i].setWindowExtent(extent);
            if (layer.getDataType() == 4 || layer.getDataType() == 5) {
                window[i].setInterpolationMethod(4);
            } else {
                window[i].setInterpolationMethod(0);
            }
            sVariable[i] = layer.getName() + " Band " + Integer.toString(iBands[i] + 1);
            sVariable[i] = sVariable[i].toLowerCase();
            sVariable[i] = sVariable[i].replaceAll(" ", "");
            sVariable[i] = sVariable[i].replaceAll("\\[", "_");
            sVariable[i] = sVariable[i].replaceAll("\\]", "_");
            sVariable[i] = FormulaParser.replaceDots(sVariable[i]);
            sVariable[i] = FormulaParser.getNormalizedName(sVariable[i]);
            jep.addVariable(sVariable[i], 0.0);
        }
        sFormula = FormulaParser.prepareFormula(sFormula, names);
        sFormula = sFormula.toLowerCase().replaceAll(" ", "");
        sFormula = sFormula.replaceAll("\\[", "_");
        sFormula = sFormula.replaceAll("\\]", "_");
        sFormula = FormulaParser.replaceDots(sFormula);
        jep.parseExpression(sFormula);
        if (!jep.hasError()) {
            for (int y = 0; y < iNY && this.setProgress(y, iNY); ++y) {
                for (int x = 0; x < iNX; ++x) {
                    double dValue;
                    for (i = 0; i < bands.size(); ++i) {
                        dValue = window[i].getCellValueAsDouble(x, y, iBands[i]);
                        if (window[i].isNoDataValue(dValue)) {
                            m_Result.setNoData(x, y);
                            break;
                        }
                        jep.addVariable(sVariable[i], dValue);
                    }
                    if (i != bands.size()) continue;
                    dValue = jep.getValue();
                    if (!Double.isNaN(dValue)) {
                        m_Result.setCellValue(x, y, dValue);
                        continue;
                    }
                    m_Result.setNoData(x, y);
                }
            }
        } else {
            throw new GeoAlgorithmExecutionException(jep.getErrorInfo());
        }
        return !this.m_Task.isCanceled();
    }

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Raster_calculator"));
        this.setGroup(Sextante.getText((String)"Calculus_tools_for_raster_layer"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addMultipleInput(LAYERS, Sextante.getText((String)"Layers"), 1, true);
            this.m_Parameters.addString(FORMULA, Sextante.getText((String)"Formula"));
            this.addOutputRasterLayer(RESULT, Sextante.getText((String)"Result"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean preprocessForModeller(Object obj) throws GeoAlgorithmExecutionException {
        ModelAlgorithm model = (ModelAlgorithm)obj;
        try {
            String sFormula = this.m_Parameters.getParameterValueAsString(FORMULA).toLowerCase();
            String sKey = model.getInputAsignment(LAYERS, (GeoAlgorithm)this);
            HashMap inputs = model.getInputs();
            ArrayList array = (ArrayList)inputs.get(sKey);
            ArrayList<String> variables = new ArrayList<String>();
            for (int i = 0; i < array.size(); ++i) {
                sKey = (String)array.get(i);
                IRasterLayer layer = (IRasterLayer)inputs.get(sKey);
                String sVariableName = layer.getName();
                if (variables.contains(sVariableName)) {
                    char c = (char)(97 + i);
                    sVariableName = Character.toString(c) + "_" + sVariableName;
                    layer.setName(sVariableName);
                }
                variables.add(sVariableName);
                sFormula = sFormula.replace(sKey.toLowerCase(), sVariableName);
            }
            Set set = inputs.keySet();
            for (Object key : set) {
                Object input = inputs.get(key);
                if (input instanceof Double && sFormula.contains(((String)key).toLowerCase())) {
                    sFormula = sFormula.replace(((String)key).toLowerCase(), input.toString());
                }
                if (!(input instanceof ModelElementNumericalValue) || !sFormula.contains(((String)key).toLowerCase())) continue;
                return false;
            }
            this.m_Parameters.getParameter(FORMULA).setParameterValue((Object)sFormula);
        }
        catch (Exception e) {
            throw new GeoAlgorithmExecutionException(Sextante.getText((String)"Syntax_error"));
        }
        return true;
    }
}

