/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gridTools.clipGrid;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.IteratorException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.exceptions.UnsupportedOutputChannelException;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;

public class ClipGridAlgorithm
extends GeoAlgorithm {
    public static final String INPUT = "INPUT";
    public static final String POLYGONS = "POLYGONS";
    public static final String RESULT = "RESULT";
    private AnalysisExtent m_Extent;
    private int m_iMinX;
    private int m_iMinY;
    private IRasterLayer m_Output;
    private IRasterLayer m_Raster;
    private IVectorLayer m_Polygons;
    private int m_iNX;
    private int m_iNY;

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Crop_grid_with_polygon_layer"));
        this.setGroup(Sextante.getText((String)"Basic_tools_for_raster_layers"));
        this.setUserCanDefineAnalysisExtent(false);
        try {
            this.m_Parameters.addInputRasterLayer(INPUT, Sextante.getText((String)"Layer_to_crop"), true);
            this.m_Parameters.addInputVectorLayer(POLYGONS, Sextante.getText((String)"Polygons"), 2, true);
            this.addOutputRasterLayer(RESULT, Sextante.getText((String)"Cropped_layer"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_Raster = this.m_Parameters.getParameterValueAsRasterLayer(INPUT);
        this.m_Polygons = this.m_Parameters.getParameterValueAsVectorLayer(POLYGONS);
        this.clip();
        return !this.m_Task.isCanceled();
    }

    private void clip() throws UnsupportedOutputChannelException, IteratorException {
        this.m_Extent = this.getAdjustedGridExtent();
        if (this.m_Extent != null) {
            this.m_Raster.setWindowExtent(this.m_Extent);
            this.m_Output = this.getNewRasterLayer(RESULT, Sextante.getText((String)"Result"), this.m_Raster.getDataType(), this.m_Extent, this.m_Raster.getBandsCount());
            this.m_Output.setNoDataValue(this.m_Raster.getNoDataValue());
            this.m_Output.assignNoData();
            this.m_iNX = this.m_Extent.getNX();
            this.m_iNY = this.m_Extent.getNY();
            int i = 1;
            IFeatureIterator iter = this.m_Polygons.iterator();
            int iShapeCount = this.m_Polygons.getShapesCount();
            while (iter.hasNext() && !this.m_Task.isCanceled()) {
                this.setProgressText(Integer.toString(i) + "/" + Integer.toString(iShapeCount));
                IFeature feature = iter.next();
                Geometry geom = feature.getGeometry();
                this.doPolygon(geom);
                if (this.m_Task.isCanceled()) {
                    return;
                }
                ++i;
            }
            iter.close();
        }
    }

    private void doPolygon(Geometry geom) {
        for (int i = 0; i < geom.getNumGeometries(); ++i) {
            Geometry part = geom.getGeometryN(i);
            this.doPolygonPart(part);
        }
    }

    private void doPolygonPart(Geometry geom) {
        int xStop;
        Coordinate p = new Coordinate();
        boolean[] bCrossing = new boolean[this.m_iNX];
        int iBands = this.m_Raster.getBandsCount();
        Envelope extent = geom.getEnvelopeInternal();
        int xStart = (int)((extent.getMinX() - this.m_Extent.getXMin()) / this.m_Extent.getCellSize()) - 1;
        if (xStart < 0) {
            xStart = 0;
        }
        if ((xStop = (int)((extent.getMaxX() - this.m_Extent.getXMin()) / this.m_Extent.getCellSize()) + 1) >= this.m_iNX) {
            xStop = this.m_iNX - 1;
        }
        Coordinate[] points = geom.getCoordinates();
        int y = 0;
        double yPos = this.m_Extent.getYMax();
        while (y < this.m_iNY && this.setProgress(y, this.m_iNY)) {
            if (yPos >= extent.getMinY() && yPos <= extent.getMaxY()) {
                Arrays.fill(bCrossing, false);
                Coordinate pLeft = new Coordinate(this.m_Extent.getXMin() - 1.0, yPos);
                Coordinate pRight = new Coordinate(this.m_Extent.getXMax() + 1.0, yPos);
                Coordinate pb = points[points.length - 1];
                for (int iPoint = 0; iPoint < points.length; ++iPoint) {
                    Coordinate pa = pb;
                    pb = points[iPoint];
                    if (!(pa.y <= yPos && yPos < pb.y) && (!(pa.y > yPos) || !(yPos >= pb.y))) continue;
                    this.getCrossing(p, pa, pb, pLeft, pRight);
                    int ix = (int)((p.x - this.m_Extent.getXMin()) / this.m_Extent.getCellSize() + 1.0);
                    if (ix < 0) {
                        ix = 0;
                    } else if (ix >= this.m_iNX) {
                        ix = this.m_iNX - 1;
                    }
                    bCrossing[ix] = !bCrossing[ix];
                }
                boolean bFill = false;
                for (int x = xStart; x <= xStop; ++x) {
                    if (bCrossing[x]) {
                        boolean bl = bFill = !bFill;
                    }
                    if (!bFill) continue;
                    for (int i = 0; i < iBands; ++i) {
                        double dValue = this.m_Raster.getCellValueAsDouble(x, y, i);
                        this.m_Output.setCellValue(x, y, i, dValue);
                    }
                }
            }
            ++y;
            yPos -= this.m_Extent.getCellSize();
        }
    }

    private boolean getCrossing(Coordinate crossing, Coordinate a1, Coordinate a2, Coordinate b1, Coordinate b2) {
        double a_dx = a2.x - a1.x;
        double b_dy = b2.y - b1.y;
        double b_dx = b2.x - b1.x;
        double a_dy = a2.y - a1.y;
        double div = a_dx * b_dy - b_dx * a_dy;
        if (div != 0.0) {
            double lambda = ((b1.x - a1.x) * b_dy - b_dx * (b1.y - a1.y)) / div;
            crossing.x = a1.x + lambda * a_dx;
            crossing.y = a1.y + lambda * a_dy;
            return true;
        }
        return false;
    }

    private AnalysisExtent getAdjustedGridExtent() {
        AnalysisExtent ge = new AnalysisExtent();
        Rectangle2D rect = this.m_Polygons.getFullExtent();
        double dMinX = this.m_Raster.getLayerGridExtent().getXMin();
        double dMinY = this.m_Raster.getLayerGridExtent().getYMin();
        double dCellSize = this.m_Raster.getLayerGridExtent().getCellSize();
        this.m_iMinX = (int)Math.floor((rect.getMinX() - dMinX) / dCellSize);
        double iMaxX = Math.ceil((rect.getMaxX() - dMinX) / dCellSize);
        this.m_iMinY = (int)Math.floor((rect.getMinY() - dMinY) / dCellSize);
        double iMaxY = Math.ceil((rect.getMaxY() - dMinY) / dCellSize);
        double dMinX2 = dMinX + (double)this.m_iMinX * dCellSize;
        double dMinY2 = dMinY + (double)this.m_iMinY * dCellSize;
        double dMaxX2 = dMinX + iMaxX * dCellSize;
        double dMaxY2 = dMinY + iMaxY * dCellSize;
        ge.setCellSize(dCellSize);
        ge.setXRange(dMinX2, dMaxX2, true);
        ge.setYRange(dMinY2, dMaxY2, true);
        return ge;
    }
}

