/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gridTools.closeGaps;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;

public class CloseGapsAlgorithm
extends GeoAlgorithm {
    public static final String INPUT = "INPUT";
    public static final String THRESHOLD = "THRESHOLD";
    public static final String RESULT = "RESULT";
    private final int[] m_iOffsetX = new int[]{0, 1, 1, 1, 0, -1, -1, -1};
    private final int[] m_iOffsetY = new int[]{1, 1, 0, -1, -1, -1, 0, 1};
    private double[] m_dDistToNeighbour;
    private IRasterLayer m_Window;
    private IRasterLayer m_Result;
    private IRasterLayer m_TensionKeep;
    private IRasterLayer m_TensionTemp;
    private int m_iNX;
    private int m_iNY;
    double m_dThreshold;

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Void_filling"));
        this.setGroup(Sextante.getText((String)"Basic_tools_for_raster_layers"));
        this.setUserCanDefineAnalysisExtent(false);
        this.setIsDeterminatedProcess(false);
        try {
            this.m_Parameters.addInputRasterLayer(INPUT, Sextante.getText((String)"Layer"), true);
            this.m_Parameters.addNumericalValue(THRESHOLD, Sextante.getText((String)"Tension_threshold"), 0.1, 2);
            this.addOutputRasterLayer(RESULT, Sextante.getText((String)"Filled_layer"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_dDistToNeighbour = new double[8];
        for (int i = 0; i < this.m_dDistToNeighbour.length; ++i) {
            this.m_dDistToNeighbour[i] = i % 2 != 0 ? Math.sqrt(2.0) : 1.0;
        }
        this.m_dThreshold = this.m_Parameters.getParameterValueAsDouble(THRESHOLD);
        this.m_Window = this.m_Parameters.getParameterValueAsRasterLayer(INPUT);
        this.m_Window.setFullExtent();
        this.m_Result = this.getNewRasterLayer(RESULT, this.m_Window.getName() + Sextante.getText((String)"[filled]"), this.m_Window.getDataType(), this.m_Window.getWindowGridExtent());
        this.m_TensionTemp = this.getTempRasterLayer(this.m_Window.getDataType(), this.m_Window.getWindowGridExtent());
        this.m_TensionKeep = this.getTempRasterLayer(0, this.m_Window.getWindowGridExtent());
        this.m_iNX = this.m_Window.getNX();
        this.m_iNY = this.m_Window.getNY();
        this.tensionMain();
        return !this.m_Task.isCanceled();
    }

    private void tensionMain() {
        int n = this.m_iNX > this.m_iNY ? this.m_iNX : this.m_iNY;
        int iStep = 0;
        while (Math.pow(2.0, ++iStep + 1) < (double)n) {
        }
        int iStart = (int)Math.pow(2.0, iStep);
        this.m_Result.assignNoData();
        for (iStep = iStart; iStep >= 1; iStep /= 2) {
            double max;
            this.tensionInit(iStep);
            while ((max = this.tensionStep(iStep)) > this.m_dThreshold) {
            }
            if (!this.m_Task.isCanceled()) continue;
            return;
        }
    }

    private void tensionInit(int iStep) {
        double z2;
        int ix;
        int iy;
        int nz;
        double z;
        int x;
        int y;
        this.m_TensionTemp.assignNoData();
        this.m_TensionKeep.assign(0.0);
        for (y = 0; y < this.m_iNY; y += iStep) {
            int ny = y + iStep < this.m_iNY ? y + iStep : this.m_iNY;
            for (x = 0; x < this.m_iNX; x += iStep) {
                z = this.m_Window.getCellValueAsDouble(x, y);
                if (!this.m_Window.isNoDataValue(z)) {
                    this.m_TensionTemp.setCellValue(x, y, z);
                    this.m_TensionKeep.setCellValue(x, y, 1.0);
                    continue;
                }
                int nx = x + iStep < this.m_iNX ? x + iStep : this.m_iNX;
                nz = 0;
                z = 0.0;
                for (iy = y; iy < ny; ++iy) {
                    for (ix = x; ix < nx; ++ix) {
                        z2 = this.m_Window.getCellValueAsDouble(ix, iy);
                        if (this.m_Window.isNoDataValue(z2)) continue;
                        z += z2;
                        ++nz;
                    }
                }
                if (nz <= 0) continue;
                this.m_TensionTemp.setCellValue(x, y, z / (double)nz);
                this.m_TensionKeep.setCellValue(x, y, 1.0);
            }
        }
        for (y = 0; y < this.m_iNY; y += iStep) {
            for (x = 0; x < this.m_iNX; x += iStep) {
                if ((double)this.m_TensionKeep.getCellValueAsByte(x, y) != 0.0) continue;
                z = this.m_Result.getCellValueAsDouble(x, y);
                if (!this.m_Result.isNoDataValue(z)) {
                    this.m_TensionTemp.setCellValue(x, y, z);
                    continue;
                }
                nz = 0;
                z = 0.0;
                for (int i = 0; i < 8; ++i) {
                    ix = x + iStep * this.m_iOffsetX[i];
                    iy = y + iStep * this.m_iOffsetY[i];
                    z2 = this.m_Result.getCellValueAsDouble(ix, iy);
                    if (this.m_Result.isNoDataValue(z2)) continue;
                    z += z2;
                    ++nz;
                }
                if ((double)nz > 0.0) {
                    this.m_TensionTemp.setCellValue(x, y, z / (double)nz);
                    continue;
                }
                this.m_TensionTemp.setCellValue(x, y, this.m_Window.getCellValueAsDouble(x, y));
            }
        }
        this.m_Result.assign(this.m_TensionTemp);
    }

    private double tensionStep(int iStep) {
        int x;
        int y;
        double dMax = 0.0;
        for (y = 0; y < this.m_iNY; y += iStep) {
            for (x = 0; x < this.m_iNX; x += iStep) {
                if ((double)this.m_TensionKeep.getCellValueAsByte(x, y) != 0.0) continue;
                double d = this.tensionChange(x, y, iStep);
                this.m_TensionTemp.setCellValue(x, y, d);
                d = Math.abs(d - this.m_Result.getCellValueAsDouble(x, y));
                if (!(d > dMax)) continue;
                dMax = d;
            }
        }
        for (y = 0; y < this.m_iNY; y += iStep) {
            for (x = 0; x < this.m_iNX; x += iStep) {
                if ((double)this.m_TensionKeep.getCellValueAsByte(x, y) != 0.0) continue;
                this.m_Result.setCellValue(x, y, this.m_TensionTemp.getCellValueAsDouble(x, y));
            }
        }
        return dMax;
    }

    private double tensionChange(int x, int y, int iStep) {
        double d = 0.0;
        double n = 0.0;
        for (int i = 0; i < 8; ++i) {
            int ix = x + iStep * this.m_iOffsetX[i];
            int iy = y + iStep * this.m_iOffsetY[i];
            double z = this.m_Result.getCellValueAsDouble(ix, iy);
            if (this.m_Result.isNoDataValue(z)) continue;
            double dz = 1.0 / this.m_dDistToNeighbour[i];
            d += dz * z;
            n += dz;
        }
        if (n > 0.0) {
            return d /= n;
        }
        return this.m_Result.getCellValueAsDouble(x, y);
    }
}

