/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gridTools.rasterBuffer;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;

public class RasterBufferAlgorithm
extends GeoAlgorithm {
    private static final int BUFFER = 1;
    private static final int FEATURE = 2;
    public static final String INPUT = "INPUT";
    public static final String METHOD = "METHOD";
    public static final String DIST = "DIST";
    public static final String BUFFER_LAYER = "BUFFER_LAYER";
    public static final int FIXED_DISTANCE = 0;
    public static final int USE_CELL_VALUE_AS_BUFFER_DISTANCE = 0;

    public void defineCharacteristics() {
        String[] sMethod = new String[]{Sextante.getText((String)"Fixed_distance"), Sextante.getText((String)"Use_cell_value_as_distance")};
        this.setName(Sextante.getText((String)"Raster_buffer"));
        this.setGroup(Sextante.getText((String)"Buffers"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputRasterLayer(INPUT, Sextante.getText((String)"Layer"), true);
            this.m_Parameters.addSelection(METHOD, Sextante.getText((String)"Method"), sMethod);
            this.m_Parameters.addNumericalValue(DIST, Sextante.getText((String)"Distance"), 2, 100.0, 0.0, Double.MAX_VALUE);
            this.addOutputRasterLayer(BUFFER_LAYER, Sextante.getText((String)"Buffer"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        double dDist = 0.0;
        double dValue = 0.0;
        int iBufferType = this.m_Parameters.getParameterValueAsInt(METHOD);
        IRasterLayer layer = this.m_Parameters.getParameterValueAsRasterLayer(INPUT);
        IRasterLayer result = this.getNewRasterLayer(BUFFER_LAYER, Sextante.getText((String)"Buffer") + "[" + layer.getName() + "]", 0);
        layer.setWindowExtent(result.getWindowGridExtent());
        double dBufDist = this.m_Parameters.getParameterValueAsDouble(DIST) / layer.getWindowCellSize();
        int iBufFixedDist = (int)(dBufDist + 2.0);
        result.assign(0.0);
        int iNX = layer.getNX();
        int iNY = layer.getNY();
        for (int y = 0; y < iNY && this.setProgress(y, iNY); ++y) {
            for (int x = 0; x < iNX; ++x) {
                int iBufDist;
                dValue = layer.getCellValueAsDouble(x, y);
                if (dValue == 0.0 || layer.isNoDataValue(dValue)) continue;
                if (iBufferType == 1) {
                    dBufDist = dValue / layer.getWindowCellSize();
                    iBufDist = (int)(dBufDist + 2.0);
                } else {
                    iBufDist = iBufFixedDist;
                }
                for (int i = -iBufDist; i < iBufDist + 1; ++i) {
                    for (int j = -iBufDist; j < iBufDist + 1; ++j) {
                        int y2;
                        int x2 = Math.max(Math.min(iNX - 1, x + i), 0);
                        dDist = this.getDist(x, y, x2, y2 = Math.max(Math.min(iNY - 1, y + j), 0));
                        if (!(dDist < dBufDist)) continue;
                        dValue = layer.getCellValueAsDouble(x2, y2);
                        if (dValue != 0.0 && !layer.isNoDataValue(dValue)) {
                            result.setCellValue(x2, y2, 2.0);
                            continue;
                        }
                        result.setCellValue(x2, y2, 1.0);
                    }
                }
            }
        }
        return !this.m_Task.isCanceled();
    }

    private double getDist(int x1, int y1, int x2, int y2) {
        return Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
    }
}

