/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gridTools.thresholdBuffer;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import java.awt.Point;
import java.util.ArrayList;

public class ThresholdBufferAlgorithm
extends GeoAlgorithm {
    private static final int BUFFER = 1;
    private static final int FEATURE = 2;
    private static final int[] m_iOffsetX = new int[]{0, 1, 1, 1, 0, -1, -1, -1};
    private static final int[] m_iOffsetY = new int[]{1, 1, 0, -1, -1, -1, 0, 1};
    public static final String FEATURES = "FEATURES";
    public static final String VALUES = "VALUES";
    public static final String THRESHOLD = "THRESHOLD";
    public static final String METHOD = "METHOD";
    public static final String GLOBAL_THRESHOLD = "GLOBAL_THRESHOLD";
    public static final String BUFFER_LAYER = "BUFFER_LAYER";
    public static final int THRESHOLD_TYPE_ABSOLUTE = 0;
    public static final int THRESHOLD_TYPE_RELATIVE_TO_CELL_VALUE = 0;
    int m_iNX;
    int m_iNY;
    int m_iThresholdType;
    double m_dThreshold;
    boolean m_bThresholdGridDefined;
    IRasterLayer m_Features;
    IRasterLayer m_Threshold;
    IRasterLayer m_Values;
    IRasterLayer m_Buffer;

    public void defineCharacteristics() {
        String[] sMethod = new String[]{Sextante.getText((String)"Absolute"), Sextante.getText((String)"Relative_to_cell_value")};
        this.setName(Sextante.getText((String)"Threshold_buffer"));
        this.setGroup(Sextante.getText((String)"Buffers"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputRasterLayer(FEATURES, Sextante.getText((String)"Layer"), true);
            this.m_Parameters.addInputRasterLayer(VALUES, Sextante.getText((String)"Threshold_parameter"), true);
            this.m_Parameters.addInputRasterLayer(THRESHOLD, Sextante.getText((String)"Threshold_values"), false);
            this.m_Parameters.addSelection(METHOD, Sextante.getText((String)"Threshold"), sMethod);
            this.m_Parameters.addNumericalValue(GLOBAL_THRESHOLD, Sextante.getText((String)"global_threshold"), 2, 100.0, Double.NEGATIVE_INFINITY, Double.MAX_VALUE);
            this.addOutputRasterLayer(BUFFER_LAYER, Sextante.getText((String)"Buffer"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_iThresholdType = this.m_Parameters.getParameterValueAsInt(METHOD);
        this.m_dThreshold = this.m_Parameters.getParameterValueAsDouble(GLOBAL_THRESHOLD);
        this.m_Features = this.m_Parameters.getParameterValueAsRasterLayer(FEATURES);
        this.m_Values = this.m_Parameters.getParameterValueAsRasterLayer(VALUES);
        this.m_Threshold = this.m_Parameters.getParameterValueAsRasterLayer(THRESHOLD);
        this.m_Buffer = this.getNewRasterLayer(BUFFER_LAYER, Sextante.getText((String)"Buffer") + "[" + this.m_Features.getName() + "]", 0);
        this.m_Features.setWindowExtent(this.m_Buffer.getWindowGridExtent());
        this.m_Features.setInterpolationMethod(0);
        this.m_Values.setWindowExtent(this.m_Buffer.getWindowGridExtent());
        if (this.m_Threshold != null) {
            this.m_Threshold.setWindowExtent(this.m_Buffer.getWindowGridExtent());
            this.m_bThresholdGridDefined = true;
        } else {
            this.m_bThresholdGridDefined = false;
        }
        this.m_Buffer.assign(0.0);
        this.m_iNX = this.m_Features.getNX();
        this.m_iNY = this.m_Features.getNY();
        for (int y = 0; y < this.m_iNY && this.setProgress(y, this.m_iNY); ++y) {
            for (int x = 0; x < this.m_iNX; ++x) {
                double dValue = this.m_Features.getCellValueAsDouble(x, y);
                if (dValue == 0.0 || this.m_Features.isNoDataValue(dValue)) continue;
                this.bufferPoint(x, y);
            }
        }
        return !this.m_Task.isCanceled();
    }

    private void bufferPoint(int x, int y) {
        ArrayList<Point> centralPoints = new ArrayList<Point>();
        ArrayList<Point> adjPoints = new ArrayList<Point>();
        double dBaseValue = this.m_Values.getCellValueAsDouble(x, y);
        double dThreshold = this.m_bThresholdGridDefined ? this.m_Threshold.getCellValueAsDouble(x, y) : this.m_dThreshold;
        centralPoints.add(new Point(x, y));
        this.m_Buffer.setCellValue(x, y, 2.0);
        while (centralPoints.size() != 0) {
            Point point;
            int iPt;
            for (iPt = 0; iPt < centralPoints.size(); ++iPt) {
                point = (Point)centralPoints.get(iPt);
                x = point.x;
                y = point.y;
                double dValue = this.m_Values.getCellValueAsDouble(x, y);
                if (this.m_Values.isNoDataValue(dValue)) continue;
                for (int n = 0; n < 8; ++n) {
                    int iValue;
                    int x2 = x + m_iOffsetX[n];
                    int y2 = y + m_iOffsetY[n];
                    dValue = this.m_Values.getCellValueAsDouble(x2, y2);
                    if (this.m_Values.isNoDataValue(dValue) || (iValue = this.m_Buffer.getCellValueAsInt(x2, y2)) != 0) continue;
                    if (this.m_iThresholdType == 0) {
                        dValue = Math.abs(dValue - dBaseValue);
                    }
                    if (!(dValue < dThreshold)) continue;
                    this.m_Buffer.setCellValue(x2, y2, 1.0);
                    adjPoints.add(new Point(x2, y2));
                }
            }
            centralPoints.clear();
            for (iPt = 0; iPt < adjPoints.size(); ++iPt) {
                point = (Point)adjPoints.get(iPt);
                centralPoints.add(new Point(point.x, point.y));
            }
            adjPoints.clear();
        }
    }
}

