/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.hydrology.accFlow;

import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;

public class AccFlowAlgorithm
extends GeoAlgorithm {
    private static final double NOT_VISITED = -1.0;
    public static final String FLOWACC = "FLOWACC";
    public static final String CONVERGENCE = "CONVERGENCE";
    public static final String METHOD = "METHOD";
    public static final String DEM = "DEM";
    public static final String WEIGHTS = "WEIGHTS";
    public static final int D8 = 0;
    public static final int RHO8 = 1;
    public static final int DINF = 2;
    public static final int MFD = 3;
    private static final int[] m_iOffsetX = new int[]{0, 1, 1, 1, 0, -1, -1, -1};
    private static final int[] m_iOffsetY = new int[]{1, 1, 0, -1, -1, -1, 0, 1};
    private int m_iMethod;
    private int m_iNX;
    private int m_iNY;
    private IRasterLayer[] m_Flow;
    private double m_dConvergence;
    private IRasterLayer m_DEM = null;
    private IRasterLayer m_Weights = null;
    private IRasterLayer m_AccFlow;

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_iMethod = this.m_Parameters.getParameterValueAsInt(METHOD);
        this.m_DEM = this.m_Parameters.getParameterValueAsRasterLayer(DEM);
        this.m_Weights = this.m_Parameters.getParameterValueAsRasterLayer(WEIGHTS);
        this.m_dConvergence = this.m_Parameters.getParameterValueAsDouble(CONVERGENCE);
        this.m_AccFlow = this.getNewRasterLayer(FLOWACC, Sextante.getText((String)"Flow_accumulation"), 4);
        this.m_AccFlow.assign(-1.0);
        AnalysisExtent extent = this.m_AccFlow.getWindowGridExtent();
        this.m_DEM.setWindowExtent(extent);
        if (this.m_Weights != null) {
            this.m_Weights.setWindowExtent(extent);
        }
        this.m_iNX = this.m_DEM.getNX();
        this.m_iNY = this.m_DEM.getNY();
        this.m_Flow = new IRasterLayer[8];
        for (int i = 0; i < this.m_Flow.length; ++i) {
            this.m_Flow[i] = this.getTempRasterLayer(4, extent);
        }
        this.calculateFlows();
        this.calculateAccFlows();
        if (this.m_Task.isCanceled()) {
            return false;
        }
        this.m_AccFlow.multiply(this.m_AccFlow.getWindowCellSize() * this.m_AccFlow.getWindowCellSize());
        return true;
    }

    public void defineCharacteristics() {
        String[] sMethod = new String[]{Sextante.getText((String)"D8"), Sextante.getText((String)"Rho8"), Sextante.getText((String)"DInfinity"), Sextante.getText((String)"MFD__Multiple_Flow_Directions")};
        this.setName(Sextante.getText((String)"Flow_accumulation"));
        this.setUserCanDefineAnalysisExtent(true);
        this.setGroup(Sextante.getText((String)"Basic_hydrological_analysis"));
        try {
            this.m_Parameters.addInputRasterLayer(DEM, Sextante.getText((String)"Elevation"), true);
            this.m_Parameters.addInputRasterLayer(WEIGHTS, Sextante.getText((String)"Weight"), false);
            this.m_Parameters.addSelection(METHOD, Sextante.getText((String)"Method"), sMethod);
            this.m_Parameters.addNumericalValue(CONVERGENCE, Sextante.getText((String)"Convergence_factor__MFD"), 1.1, 2);
            this.addOutputRasterLayer(FLOWACC, Sextante.getText((String)"Flow_accumulation"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    private void calculateFlows() {
        for (int y = 0; y < this.m_iNY && this.setProgress(y, this.m_iNY); ++y) {
            block7: for (int x = 0; x < this.m_iNX; ++x) {
                switch (this.m_iMethod) {
                    case 0: {
                        this.doD8(x, y);
                        continue block7;
                    }
                    case 1: {
                        this.doRho8(x, y);
                        continue block7;
                    }
                    case 2: {
                        this.doDInf(x, y);
                        continue block7;
                    }
                    case 3: {
                        this.doMFD(x, y);
                    }
                }
            }
        }
    }

    private void calculateAccFlows() {
        for (int y = 0; y < this.m_iNY && this.setProgress(y, this.m_iNY); ++y) {
            for (int x = 0; x < this.m_iNX; ++x) {
                this.getFlow(x, y);
            }
        }
    }

    private void getFlow(int x, int y) {
        if (this.m_AccFlow.getCellValueAsDouble(x, y) != -1.0 || this.m_Task.isCanceled()) {
            return;
        }
        double dWeight = this.m_Weights != null ? this.m_Weights.getCellValueAsDouble(x, y) : 1.0;
        double dValue = this.m_DEM.getCellValueAsDouble(x, y);
        if (!this.m_DEM.isNoDataValue(dValue)) {
            this.m_AccFlow.setCellValue(x, y, dWeight);
            int j = 4;
            for (int i = 0; i < 8; ++i) {
                double dFlow;
                int ix = x + m_iOffsetX[i];
                int iy = y + m_iOffsetY[i];
                dValue = this.m_DEM.getCellValueAsDouble(ix, iy);
                if (!this.m_DEM.isNoDataValue(dValue) && (dFlow = this.m_Flow[j].getCellValueAsDouble(ix, iy)) > 0.0) {
                    this.getFlow(ix, iy);
                    dValue = this.m_AccFlow.getCellValueAsDouble(ix, iy) * dFlow;
                    double dValue2 = this.m_AccFlow.getCellValueAsDouble(x, y);
                    this.m_AccFlow.setCellValue(x, y, dValue + dValue2);
                }
                j = (j + 1) % 8;
            }
        }
    }

    private void doD8(int x, int y) {
        int iDirection = this.m_DEM.getDirToNextDownslopeCell(x, y);
        if (iDirection >= 0) {
            this.m_Flow[iDirection % 8].setCellValue(x, y, 1.0);
        }
    }

    private void doRho8(int x, int y) {
        double dAspect = Math.toDegrees(this.m_DEM.getAspect(x, y));
        if (dAspect >= 0.0) {
            int iDirection = (int)(dAspect / 45.0);
            if (dAspect % 45.0 / 45.0 > Math.random()) {
                ++iDirection;
            }
            this.m_Flow[iDirection %= 8].setCellValue(x, y, 1.0);
        }
    }

    private void doDInf(int x, int y) {
        double dAspect = Math.toDegrees(this.m_DEM.getAspect(x, y));
        if (dAspect >= 0.0) {
            int iDirection = (int)(dAspect / 45.0);
            dAspect = dAspect % 45.0 / 45.0;
            this.m_Flow[iDirection % 8].setCellValue(x, y, 1.0 - dAspect);
            this.m_Flow[(iDirection + 1) % 8].setCellValue(x, y, dAspect);
        }
    }

    private void doMFD(int x, int y) {
        double dFlow;
        int i;
        double z = this.m_DEM.getCellValueAsDouble(x, y);
        double dzSum = 0.0;
        for (i = 0; i < 8; ++i) {
            double dDifZ;
            int ix = x + m_iOffsetX[i];
            int iy = y + m_iOffsetY[i];
            double z2 = this.m_DEM.getCellValueAsDouble(ix, iy);
            if (this.m_DEM.isNoDataValue(z2) || !((dDifZ = z - z2) > 0.0)) continue;
            dFlow = Math.pow(dDifZ / this.m_DEM.getDistToNeighborInDir(i), this.m_dConvergence);
            dzSum += dFlow;
            this.m_Flow[i].setCellValue(x, y, dFlow);
        }
        if (dzSum > 0.0) {
            for (i = 0; i < 8; ++i) {
                dFlow = this.m_Flow[i].getCellValueAsDouble(x, y);
                if (!(dFlow > 0.0)) continue;
                this.m_Flow[i].setCellValue(x, y, dFlow / dzSum);
            }
        }
    }
}

