/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.lighting.los;

import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.ILayer;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.rasterWrappers.GridCell;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.geom.Point2D;
import javax.swing.BorderFactory;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class LOSAlgorithm
extends GeoAlgorithm {
    public static final String DEM = "DEM";
    public static final String POINT = "POINT";
    public static final String POINT2 = "POINT2";
    public static final String HEIGHT = "HEIGHT";
    public static final String HEIGHT2 = "HEIGHT2";
    public static final String GRAPH = "GRAPH";
    private IRasterLayer m_DEM = null;
    private GridCell m_Point;
    private GridCell m_Point2;
    private double m_dHeight;
    private double m_dHeight2;
    private final XYSeriesCollection m_Dataset = new XYSeriesCollection();
    private double m_dMin = Double.MAX_VALUE;

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_DEM = this.m_Parameters.getParameterValueAsRasterLayer(DEM);
        Point2D pt = this.m_Parameters.getParameterValueAsPoint(POINT);
        Point2D pt2 = this.m_Parameters.getParameterValueAsPoint(POINT2);
        this.m_dHeight = this.m_Parameters.getParameterValueAsDouble(HEIGHT);
        this.m_dHeight2 = this.m_Parameters.getParameterValueAsDouble(HEIGHT2);
        AnalysisExtent ge = new AnalysisExtent((ILayer)this.m_DEM);
        this.m_Point = ge.getGridCoordsFromWorldCoords(pt);
        this.m_Point2 = ge.getGridCoordsFromWorldCoords(pt2);
        double x = ge.getXMin() + (double)this.m_Point.getX() * ge.getCellSize();
        double y = ge.getYMax() - (double)this.m_Point.getY() * ge.getCellSize();
        double x2 = ge.getXMin() + (double)this.m_Point2.getX() * ge.getCellSize();
        double y2 = ge.getYMax() - (double)this.m_Point2.getY() * ge.getCellSize();
        ge.setXRange(x, x2, true);
        ge.setYRange(y, y2, true);
        ge.enlargeOneCell();
        this.m_Point = ge.getGridCoordsFromWorldCoords(pt);
        this.m_Point2 = ge.getGridCoordsFromWorldCoords(pt2);
        this.m_DEM.setWindowExtent(ge);
        this.calculateLOS(this.m_Point.getX(), this.m_Point.getY(), this.m_Point2.getX(), this.m_Point2.getY());
        this.createChart();
        return !this.m_Task.isCanceled();
    }

    public void defineCharacteristics() {
        try {
            this.m_Parameters.addInputRasterLayer(DEM, Sextante.getText((String)"Elevation"), true);
            this.m_Parameters.addPoint(POINT, Sextante.getText((String)"point") + " 1");
            this.m_Parameters.addPoint(POINT2, Sextante.getText((String)"point") + " 2");
            this.m_Parameters.addNumericalValue(HEIGHT, Sextante.getText((String)"Height_of_point") + " 1", 0.0, 2);
            this.m_Parameters.addNumericalValue(HEIGHT2, Sextante.getText((String)"Height_of_point") + " 2", 0.0, 2);
            this.addOutputChart(GRAPH, Sextante.getText((String)"Line_of_sight"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        this.setName(Sextante.getText((String)"Line_of_sight"));
        this.setGroup(Sextante.getText((String)"Visibility_and_lighting"));
    }

    private void calculateLOS(int x, int y, int x2, int y2) {
        double d;
        double dMaxSlope = Double.MAX_VALUE;
        double dLastD = 0.0;
        boolean bLast = true;
        XYSeries serie = new XYSeries((Comparable)((Object)"serie"));
        XYSeries lineSerie = new XYSeries((Comparable)((Object)"lineSerie"));
        this.m_Dataset.addSeries(serie);
        double dx = x2 - x;
        double dy = y2 - y;
        double d2 = d = Math.abs(dx) > Math.abs(dy) ? Math.abs(dx) : Math.abs(dy);
        if (d > 0.0) {
            double dist = Math.sqrt(dx * dx + dy * dy);
            dx /= d;
            dy /= d;
            d = dist / d;
            double id = 0.0;
            double ix = (double)x + 0.5;
            double iy = (double)y + 0.5;
            double iz = this.m_DEM.getCellValueAsDouble(x, y);
            if (this.m_DEM.isNoDataValue(iz)) {
                return;
            }
            double dLastZ = iz += this.m_dHeight;
            while (id < dist) {
                boolean bSeen;
                id += d;
                x = (int)(ix += dx);
                y = (int)(iy += dy);
                double z = this.m_DEM.getCellValueAsDouble(x, y);
                if (this.m_DEM.isNoDataValue(z)) continue;
                double dSlope = (z - iz) / id;
                if (dMaxSlope == Double.MAX_VALUE) {
                    dMaxSlope = dSlope;
                    bLast = true;
                    bSeen = true;
                    serie.add(0.0, iz);
                } else if (dSlope <= dMaxSlope) {
                    bSeen = false;
                } else {
                    bSeen = true;
                    dMaxSlope = dSlope;
                }
                if (bSeen == bLast) {
                    serie.add(id * this.m_DEM.getWindowCellSize(), z);
                    dLastD = id * this.m_DEM.getWindowCellSize();
                    dLastZ = z;
                } else {
                    serie = new XYSeries((Comparable)((Object)("sid" + id)));
                    this.m_Dataset.addSeries(serie);
                    serie.add(dLastD, dLastZ);
                    dLastD = id * this.m_DEM.getWindowCellSize();
                    dLastZ = z;
                    serie.add(dLastD, dLastZ);
                    bLast = bSeen;
                }
                this.m_dMin = Math.min(this.m_dMin, dLastZ);
            }
            lineSerie.add(0.0, iz);
            lineSerie.add(dLastD, dLastZ + this.m_dHeight2);
            this.m_Dataset.addSeries(lineSerie);
        }
    }

    private void createChart() {
        int i;
        JFreeChart chart = ChartFactory.createXYLineChart(null, null, null, (XYDataset)this.m_Dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)true);
        ChartPanel jPanelChart = new ChartPanel(chart);
        jPanelChart.setPreferredSize(new Dimension(500, 300));
        jPanelChart.setBorder(BorderFactory.createLineBorder(Color.gray, 1));
        XYPlot plot = (XYPlot)chart.getPlot();
        XYItemRenderer ren = plot.getRenderer();
        for (i = 0; i < this.m_Dataset.getSeriesCount() - 1; ++i) {
            if (i % 2 != 0) {
                ren.setSeriesPaint(i, (Paint)Color.red);
                continue;
            }
            ren.setSeriesPaint(i, (Paint)Color.green);
        }
        ren.setSeriesPaint(i, (Paint)Color.BLACK);
        plot.getRangeAxis().setAutoRange(false);
        plot.getRangeAxis().setLowerBound(this.m_dMin);
        this.addOutputChart(GRAPH, Sextante.getText((String)"Line_of_sight"), jPanelChart);
    }
}

