/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.morphometry.realArea;

import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;

public class RealAreaAlgorithm
extends GeoAlgorithm {
    public static final String DEM = "DEM";
    public static final String REALAREA = "REALAREA";
    IRasterLayer m_RealArea;
    IRasterLayer m_DEM = null;
    private double m_DX2;

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_DEM = this.m_Parameters.getParameterValueAsRasterLayer(DEM);
        this.m_RealArea = this.getNewRasterLayer(REALAREA, Sextante.getText((String)"Real_area"), 4);
        AnalysisExtent extent = this.m_RealArea.getWindowGridExtent();
        this.m_DEM.setWindowExtent(extent);
        int iNX = this.m_DEM.getNX();
        int iNY = this.m_DEM.getNY();
        this.m_DX2 = this.m_DEM.getWindowCellSize() * this.m_DEM.getWindowCellSize();
        for (int y = 0; y < iNY && this.setProgress(y, iNY); ++y) {
            for (int x = 0; x < iNX; ++x) {
                this.setRealArea(x, y);
            }
        }
        return !this.m_Task.isCanceled();
    }

    public void defineCharacteristics() {
        this.setUserCanDefineAnalysisExtent(true);
        this.setGroup(Sextante.getText((String)"Geomorphometry_and_terrain_analysis"));
        this.setName(Sextante.getText((String)"Real_area"));
        try {
            this.m_Parameters.addInputRasterLayer(DEM, Sextante.getText((String)"Elevation"), true);
            this.addOutputRasterLayer(REALAREA, Sextante.getText((String)"Real_area"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    private void setRealArea(int x, int y) {
        double dSlope = this.m_DEM.getSlope(x, y);
        if (!this.m_DEM.isNoDataValue(dSlope)) {
            double dArea = this.m_DX2 / Math.cos(dSlope);
            this.m_RealArea.setCellValue(x, y, dArea);
        } else {
            this.m_RealArea.setNoData(x, y);
        }
    }
}

