/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.morphometry.slope;

import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;

public class SlopeAlgorithm
extends GeoAlgorithm {
    public static final int METHOD_MAXIMUM_SLOPE = 0;
    public static final int METHOD_TARBOTON = 1;
    public static final int METHOD_BURGESS = 2;
    public static final int METHOD_BAUER = 3;
    public static final int METHOD_HEERDEGEN = 4;
    public static final int METHOD_ZEVENBERGEN = 5;
    public static final int METHOD_HARALICK = 6;
    public static final int UNITS_RADIANS = 0;
    public static final int UNITS_DEGREES = 1;
    public static final int UNITS_PERCENTAGE = 2;
    public static final String METHOD = "METHOD";
    public static final String UNITS = "UNITS";
    public static final String DEM = "DEM";
    public static final String SLOPE = "SLOPE";
    private static final int[] m_iOffsetX = new int[]{0, 1, 1, 1, 0, -1, -1, -1};
    private static final int[] m_iOffsetY = new int[]{1, 1, 0, -1, -1, -1, 0, 1};
    private IRasterLayer m_DEM;
    private IRasterLayer m_Slope;
    private int m_iUnits;
    private double _2DX;
    private double _6DX;

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        int iMethod = this.m_Parameters.getParameterValueAsInt(METHOD);
        this.m_iUnits = this.m_Parameters.getParameterValueAsInt(UNITS);
        this.m_DEM = this.m_Parameters.getParameterValueAsRasterLayer(DEM);
        this.m_Slope = this.getNewRasterLayer(SLOPE, Sextante.getText((String)"Slope"), 4);
        AnalysisExtent extent = this.m_Slope.getWindowGridExtent();
        this.m_DEM.setWindowExtent(extent);
        int iNX = this.m_DEM.getNX();
        int iNY = this.m_DEM.getNY();
        this._2DX = this.m_DEM.getWindowCellSize() * 2.0;
        this._6DX = this.m_DEM.getWindowCellSize() * 6.0;
        for (int y = 0; y < iNY && this.setProgress(y, iNY); ++y) {
            block10: for (int x = 0; x < iNX; ++x) {
                switch (iMethod) {
                    case 0: {
                        this.Do_MaximumSlope(x, y);
                        continue block10;
                    }
                    case 1: {
                        this.Do_Tarboton(x, y);
                        continue block10;
                    }
                    case 2: {
                        this.Do_LeastSquare(x, y);
                        continue block10;
                    }
                    case 3: {
                        this.Do_FD_BRM(x, y);
                        continue block10;
                    }
                    case 4: {
                        this.Do_FD_Heerdegen(x, y);
                        continue block10;
                    }
                    case 5: {
                        this.Do_FD_Zevenbergen(x, y);
                        continue block10;
                    }
                    case 6: {
                        this.Do_FD_Haralick(x, y);
                    }
                }
            }
        }
        return !this.m_Task.isCanceled();
    }

    public void defineCharacteristics() {
        String[] sMethod = new String[]{Sextante.getText((String)"M\u00e1ximum_slope__Travis_et_al_1975"), Sextante.getText((String)"Maximum_Triangle_Slope__Tarboton_1997"), Sextante.getText((String)"Plane_fitting__Costa-Cabral_&_Burgess_1996"), Sextante.getText((String)"Fit_2_Degree_Polynom__Bauer_Rohdenburg_Bork_1985"), Sextante.getText((String)"Fit_2_Degree_Polynom__Heerdegen_&_Beran_1982"), Sextante.getText((String)"Fit_2_Degree_Polynom__Zevenbergen_&_Thorne_1987"), Sextante.getText((String)"Fit_3_Degree_Polynom__Haralick_1983")};
        String[] sUnits = new String[]{Sextante.getText((String)"Radians"), Sextante.getText((String)"Degrees"), Sextante.getText((String)"Percentage")};
        this.setName(Sextante.getText((String)"Slope"));
        this.setGroup(Sextante.getText((String)"Geomorphometry_and_terrain_analysis"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputRasterLayer(DEM, Sextante.getText((String)"Elevation"), true);
            this.m_Parameters.addSelection(METHOD, Sextante.getText((String)"Method"), sMethod);
            this.m_Parameters.addSelection(UNITS, Sextante.getText((String)"Units"), sUnits);
            this.addOutputRasterLayer(SLOPE, Sextante.getText((String)"Slope"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    private void Do_MaximumSlope(int x, int y) {
        double z = this.m_DEM.getCellValueAsDouble(x, y);
        if (this.m_DEM.isNoDataValue(z)) {
            this.Set_Parameters_NoData(x, y);
        } else {
            double dMaxSlope = 0.0;
            for (int i = 0; i < 8; ++i) {
                double dSlope;
                double z2 = this.m_DEM.getCellValueAsDouble(x + m_iOffsetX[i], y + m_iOffsetY[i]);
                if (this.m_DEM.isNoDataValue(z2) || !((dSlope = Math.atan((z - z2) / this.m_DEM.getDistToNeighborInDir(i))) > dMaxSlope)) continue;
                dMaxSlope = dSlope;
            }
            this.Set_Parameters(x, y, dMaxSlope);
        }
    }

    private void Do_Tarboton(int x, int y) {
        double[] zm = new double[8];
        double z = this.m_DEM.getCellValueAsDouble(x, y);
        if (this.m_DEM.isNoDataValue(z)) {
            this.Set_Parameters_NoData(x, y);
        } else {
            int i;
            for (i = 0; i < 8; ++i) {
                double z2 = this.m_DEM.getCellValueAsDouble(x + m_iOffsetX[i], y + m_iOffsetY[i]);
                zm[i] = !this.m_DEM.isNoDataValue(z2) ? z2 : (!this.m_DEM.isNoDataValue(z2 = this.m_DEM.getCellValueAsDouble(x + m_iOffsetX[(i + 4) % 8], y + m_iOffsetY[(i + 4) % 8])) ? z - (z2 - z) : z);
            }
            double Slope = 0.0;
            int j = 1;
            for (i = 0; i < 8; ++i) {
                double H;
                double G;
                if (i % 2 != 0) {
                    G = (z - zm[j]) / this.m_DEM.getWindowCellSize();
                    H = (zm[j] - zm[i]) / this.m_DEM.getWindowCellSize();
                } else {
                    G = (z - zm[i]) / this.m_DEM.getWindowCellSize();
                    H = (zm[i] - zm[j]) / this.m_DEM.getWindowCellSize();
                }
                double iSlope = H < 0.0 ? G : (H > G ? (z - zm[i % 2 != 0 ? i : j]) / (Math.sqrt(2.0) * this.m_DEM.getWindowCellSize()) : Math.sqrt(G * G + H * H));
                if (iSlope > Slope) {
                    Slope = iSlope;
                }
                j = (j + 1) % 8;
            }
            this.Set_Parameters(x, y, Math.atan(Slope));
        }
    }

    private void Do_LeastSquare(int x, int y) {
        double[] zm = new double[9];
        if (this.Get_SubMatrix3x3(x, y, zm)) {
            double a = (zm[2] + 2.0 * zm[5] + zm[8] - (zm[0] + 2.0 * zm[3] + zm[6])) / (8.0 * this.m_DEM.getWindowCellSize());
            double b = (zm[6] + 2.0 * zm[7] + zm[8] - (zm[0] + 2.0 * zm[1] + zm[2])) / (8.0 * this.m_DEM.getWindowCellSize());
            if (a != 0.0) {
                this.Set_Parameters(x, y, Math.atan(Math.sqrt(a * a + b * b)));
            } else if (b > 0.0) {
                this.Set_Parameters(x, y, Math.atan(Math.sqrt(a * a + b * b)));
            } else if (b < 0.0) {
                this.Set_Parameters(x, y, Math.atan(Math.sqrt(a * a + b * b)));
            } else {
                this.Set_Parameters_NoData(x, y);
            }
        }
    }

    private void Do_FD_BRM(int x, int y) {
        double[] zm = new double[9];
        if (this.Get_SubMatrix3x3(x, y, zm)) {
            double G = (zm[2] - zm[0] + (zm[5] - zm[3]) + (zm[8] - zm[6])) / this._6DX;
            double H = (zm[6] - zm[0] + (zm[7] - zm[1]) + (zm[8] - zm[2])) / this._6DX;
            this.Set_Parameters_Derive(x, y, G, H);
        }
    }

    private void Do_FD_Heerdegen(int x, int y) {
        double[] zm = new double[9];
        if (this.Get_SubMatrix3x3(x, y, zm)) {
            double G = (-zm[0] + zm[2] - zm[3] + zm[5] - zm[6] + zm[8]) / this._6DX;
            double H = (-zm[0] - zm[1] - zm[2] + zm[6] + zm[7] + zm[8]) / this._6DX;
            this.Set_Parameters_Derive(x, y, G, H);
        }
    }

    private void Do_FD_Zevenbergen(int x, int y) {
        double[] zm = new double[9];
        if (this.Get_SubMatrix3x3(x, y, zm)) {
            double G = (zm[5] - zm[3]) / this._2DX;
            double H = (zm[7] - zm[1]) / this._2DX;
            this.Set_Parameters_Derive(x, y, G, H);
        }
    }

    private void Do_FD_Haralick(int x, int y) {
        int[][][] Mtrx = new int[][][]{new int[][]{{31, -5, -17, -5, 31}, {-44, -62, -68, -62, -44}, {0, 0, 0, 0, 0}, {44, 62, 68, 62, 44}, {-31, 5, 17, 5, -31}}, new int[][]{{31, -44, 0, 44, -31}, {-5, -62, 0, 62, 5}, {-17, -68, 0, 68, 17}, {-5, -62, 0, 62, 5}, {31, -44, 0, 44, -31}}, new int[][]{{2, 2, 2, 2, 2}, {-1, -1, -1, -1, -1}, {-2, -2, -2, -2, -2}, {-1, -1, -1, -1, -1}, {2, 2, 2, 2, 2}}, new int[][]{{4, 2, 0, -2, -4}, {2, 1, 0, -1, -2}, {0, 0, 0, 0, 0}, {-2, -1, 0, 1, 2}, {-4, -2, 0, 2, 4}}, new int[][]{{2, -1, -2, -1, 2}, {2, -1, -2, -1, 2}, {2, -1, -2, -1, 2}, {2, -1, -2, -1, 2}, {2, -1, -2, -1, 2}}};
        int[] QMtrx = new int[]{4200, 4200, 700, 1000, 700};
        double[] zm = new double[25];
        double[] k = new double[2];
        if (this.Get_SubMatrix5x5(x, y, zm)) {
            for (int i = 0; i < 2; ++i) {
                int n = 0;
                double Sum = 0.0;
                for (int iy = 0; iy < 5; ++iy) {
                    int ix = 0;
                    while (ix < 5) {
                        Sum += zm[n] * (double)Mtrx[i][ix][iy];
                        ++ix;
                        ++n;
                    }
                }
                k[i] = Sum / (double)QMtrx[i];
            }
            this.Set_Parameters_Derive(x, y, k[1], k[0]);
        }
    }

    private void Set_Parameters(int x, int y, double dSlope) {
        if (this.m_iUnits == 1) {
            dSlope = Math.toDegrees(dSlope);
        } else if (this.m_iUnits == 2) {
            dSlope = Math.tan(dSlope) * 100.0;
        }
        this.m_Slope.setCellValue(x, y, dSlope);
    }

    private void Set_Parameters_Derive(int x, int y, double G, double H) {
        double k2 = G * G + H * H;
        if (G != 0.0) {
            this.Set_Parameters(x, y, Math.atan(Math.sqrt(k2)));
        } else if (H > 0.0) {
            this.Set_Parameters(x, y, Math.atan(Math.sqrt(k2)));
        } else if (H < 0.0) {
            this.Set_Parameters(x, y, Math.atan(Math.sqrt(k2)));
        } else {
            this.Set_Parameters(x, y, Math.atan(Math.sqrt(k2)));
        }
    }

    private void Set_Parameters_NoData(int x, int y) {
        this.m_Slope.setNoData(x, y);
    }

    private boolean Get_SubMatrix3x3(int x, int y, double[] SubMatrix) {
        int[] iSub = new int[]{5, 8, 7, 6, 3, 0, 1, 2};
        double z = this.m_DEM.getCellValueAsDouble(x, y);
        if (!this.m_DEM.isNoDataValue(z)) {
            SubMatrix[4] = 0.0;
            for (int i = 0; i < 8; ++i) {
                double z2 = this.m_DEM.getCellValueAsDouble(x + m_iOffsetX[i], y + m_iOffsetY[i]);
                SubMatrix[iSub[i]] = !this.m_DEM.isNoDataValue(z2) ? z2 - z : (!this.m_DEM.isNoDataValue(z2 = this.m_DEM.getCellValueAsDouble(x + m_iOffsetX[(i + 4) % 8], y + m_iOffsetY[(i + 4) % 8])) ? z - z2 : 0.0);
            }
            return true;
        }
        this.Set_Parameters_NoData(x, y);
        return false;
    }

    private boolean Get_SubMatrix5x5(int x, int y, double[] SubMatrix) {
        double z = this.m_DEM.getCellValueAsDouble(x, y);
        if (!this.m_DEM.isNoDataValue(z)) {
            int i = 0;
            for (int iy = y - 2; iy <= y + 2; ++iy) {
                int jy = iy < 0 ? 0 : (iy >= this.m_DEM.getNY() ? this.m_DEM.getNY() - 1 : iy);
                int ix = x - 2;
                while (ix <= x + 2) {
                    int jx = ix < 0 ? 0 : (ix >= this.m_DEM.getNX() ? this.m_DEM.getNY() - 1 : ix);
                    double z2 = this.m_DEM.getCellValueAsDouble(jx, jy);
                    SubMatrix[i] = !this.m_DEM.isNoDataValue(z2) ? z2 - z : 0.0;
                    ++ix;
                    ++i;
                }
            }
            return true;
        }
        return false;
    }
}

