/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.nonSpatial.calculator;

import es.unex.sextante.core.ObjectAndDescription;
import es.unex.sextante.core.OutputObjectsSet;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.gui.modeler.GeoAlgorithmModelerParametersPanel;
import es.unex.sextante.modeler.elements.ModelElementNumericalValue;
import es.unex.sextante.nonSpatial.calculator.CalculatorKeysPanel;
import es.unex.sextante.outputs.Output;
import es.unex.sextante.parameters.Parameter;
import info.clearthought.layout.TableLayout;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.nfunk.jep.JEP;

public class CalculatorModelerParametersPanel
extends GeoAlgorithmModelerParametersPanel {
    private JTextArea jTextExpression;
    private JScrollPane jScrollPane;
    private JTree jTree;
    private JScrollPane jScrollPane1;
    private CalculatorKeysPanel m_KeysPanel;
    private HashMap m_Constants;

    protected void initGUI() {
        this.setPreferredSize(new Dimension(570, 350));
        TableLayout thisLayout = new TableLayout((double[][])new double[][]{{10.0, -1.0, -1.0, -1.0, -1.0, 10.0}, {10.0, -1.0, -1.0, -1.0, 50.0, 5.0, 50.0, 5.0, 10.0}});
        thisLayout.setHGap(10);
        thisLayout.setVGap(10);
        this.setLayout((LayoutManager)thisLayout);
        this.setSize(new Dimension(350, 350));
        this.jScrollPane = new JScrollPane();
        this.add(this.jScrollPane, "1, 4, 4, 4");
        this.jScrollPane.setHorizontalScrollBarPolicy(31);
        this.jTextExpression = new JTextArea();
        this.jScrollPane.setViewportView(this.jTextExpression);
        this.jTextExpression.setPreferredSize(new Dimension(0, 0));
        this.jTextExpression.setBorder(BorderFactory.createBevelBorder(1));
        try {
            Parameter param = this.m_Algorithm.getParameters().getParameter("FORMULA");
            ObjectAndDescription oad = (ObjectAndDescription)this.getParameterValue(param);
            if (oad != null) {
                String sFormula = (String)oad.getObject();
                this.jTextExpression.setText(sFormula);
            }
        }
        catch (Exception e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        this.m_KeysPanel = new CalculatorKeysPanel(this.jTextExpression);
        this.add(this.m_KeysPanel, "3, 1, 4, 3");
        this.jScrollPane1 = new JScrollPane();
        this.add(this.jScrollPane1, "1, 1, 2, 3");
        this.jTree = new JTree();
        this.jScrollPane1.setViewportView(this.jTree);
        this.jScrollPane1.setHorizontalScrollBarPolicy(31);
        this.jTree.setBorder(BorderFactory.createBevelBorder(1));
        MouseAdapter ml = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int iRow = CalculatorModelerParametersPanel.this.jTree.getRowForLocation(e.getX(), e.getY());
                TreePath path = CalculatorModelerParametersPanel.this.jTree.getPathForLocation(e.getX(), e.getY());
                if (iRow != -1 && e.getClickCount() == 2) {
                    CalculatorModelerParametersPanel.this.insertTextFromTree(path);
                }
            }
        };
        this.jTree.addMouseListener(ml);
        try {
            this.populateTree();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void populateTree() {
        DefaultMutableTreeNode child;
        int i;
        this.jTree.setModel(null);
        ObjectAndDescription[] values = this.getElementsOfClass(ModelElementNumericalValue.class, false);
        DefaultMutableTreeNode main = new DefaultMutableTreeNode(Sextante.getText((String)"ELEMENTS"));
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(Sextante.getText((String)"Numerical_values"));
        for (i = 0; i < values.length; ++i) {
            String sName = values[i].getDescription();
            String sVariableName = values[i].getObject().toString();
            child = new DefaultMutableTreeNode(new ObjectAndDescription(sName, (Object)sVariableName));
            node.add(child);
        }
        main.add(node);
        String[] sFunctions = new String[]{"sin", "cos", "tan", "asin", "acos", "atan", "atan2", "sinh", "cosh", "tanh", "asinh", "acosh", "atanh", "ln", "log", "exp", "abs", "rand", "mod", "sqrt", "if"};
        node = new DefaultMutableTreeNode(Sextante.getText((String)"Functions"));
        for (i = 0; i < sFunctions.length; ++i) {
            child = new DefaultMutableTreeNode(" " + sFunctions[i] + "() ");
            node.add(child);
        }
        main.add(node);
        String[] sOperators = new String[]{"+", "-", "*", "/", "%", "!", "^", "&&", "||", "<", ">", "<=", ">=", "==", "!="};
        node = new DefaultMutableTreeNode(Sextante.getText((String)"Operators"));
        for (i = 0; i < sOperators.length; ++i) {
            String s = " " + sOperators[i] + " ";
            child = new DefaultMutableTreeNode(new ObjectAndDescription(s, (Object)s));
            node.add(child);
        }
        main.add(node);
        node = new DefaultMutableTreeNode(Sextante.getText((String)"Constants"));
        this.m_Constants = new HashMap();
        this.m_Constants.put("e", " " + Double.toString(Math.E) + " ");
        this.m_Constants.put("Pi", " " + Double.toString(Math.PI) + " ");
        Set set = this.m_Constants.keySet();
        for (String s : set) {
            child = new DefaultMutableTreeNode(new ObjectAndDescription(s, (Object)s));
            node.add(child);
        }
        main.add(node);
        this.jTree.setModel(new DefaultTreeModel(main));
        DefaultTreeCellRenderer renderer = (DefaultTreeCellRenderer)this.jTree.getCellRenderer();
        renderer.setOpenIcon(null);
        renderer.setClosedIcon(null);
        renderer.setLeafIcon(null);
    }

    private void insertTextFromTree(TreePath path) {
        TreePath parent = path.getParentPath();
        if (parent != null && !parent.toString().equals("[" + Sextante.getText((String)"ELEMENTS") + "]")) {
            String sParentName = parent.toString();
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            String s = (String)((ObjectAndDescription)node.getUserObject()).getObject();
            if (sParentName.equals("[" + Sextante.getText((String)"ELEMENTS") + ", " + Sextante.getText((String)"Constants]"))) {
                s = this.m_Constants.containsKey(s) ? (String)this.m_Constants.get(s) : "";
            }
            this.jTextExpression.insert(s, this.jTextExpression.getCaretPosition());
            if (sParentName.equals("[" + Sextante.getText((String)"ELEMENTS") + ", " + Sextante.getText((String)"Functions]"))) {
                this.jTextExpression.setCaretPosition(this.jTextExpression.getCaretPosition() - 2);
            }
        }
    }

    public boolean assignParameters(HashMap map) {
        ObjectAndDescription[] values = this.getElementsOfClass(ModelElementNumericalValue.class, false);
        JEP jep = new JEP();
        jep.addStandardConstants();
        jep.addStandardFunctions();
        for (int i = 0; i < values.length; ++i) {
            if (!this.jTextExpression.getText().contains(values[i].getObject().toString())) continue;
            jep.addVariable(values[i].getObject().toString(), 0.0);
            map.put("DUMMY" + this.getInnerParameterKey(), values[i].getObject().toString());
        }
        jep.parseExpression(this.jTextExpression.getText());
        if (jep.hasError()) {
            return false;
        }
        String sFormulaKey = this.getInnerParameterKey();
        map.put("FORMULA", sFormulaKey);
        this.m_DataObjects.put(sFormulaKey, new ObjectAndDescription("String", (Object)this.jTextExpression.getText()));
        OutputObjectsSet oosetGlobal = this.m_GlobalAlgorithm.getOutputObjects();
        OutputObjectsSet ooset = this.m_Algorithm.getOutputObjects();
        String sName = "RESULT" + this.m_sAlgorithmName;
        try {
            Output out = ooset.getOutput("RESULT");
            Output outToAdd = (Output)out.getClass().newInstance();
            outToAdd.setName(sName);
            outToAdd.setDescription(sName);
            oosetGlobal.add(outToAdd);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }
}

